/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.securitypolicy.assertions;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKeyGenerator;
import com.sap.engine.lib.xml.signature.encryption.XMLEncryptor;
import com.sap.security.core.policy.exceptions.ProcessException;
import com.sap.security.core.policy.exceptions.ProcessMessage;
import com.sap.security.core.securitypolicy.assertions.SecurityPolicyConstants;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.security.core.ws.dsig.KeyInfoElement;
import com.sap.security.core.ws.dsig.RetrievalMethodElement;
import com.sap.security.core.ws.dsig.TransformElement;
import com.sap.security.core.ws.dsig.TransformsElement;
import com.sap.security.core.ws.mapping.WSMappingUtil;
import com.sap.security.core.ws.wss.AttachmentData;
import com.sap.security.core.ws.wss.WSProcessor;
import com.sap.security.core.ws.wss.WSSecurityDocument;
import com.sap.security.core.ws.wss.tokens.securitytoken.KeyIdentifierElement;
import com.sap.security.core.ws.wss.tokens.securitytoken.SecurityTokenReference;
import com.sap.security.core.ws.xenc.CipherDataElement;
import com.sap.security.core.ws.xenc.CipherReferenceElement;
import com.sap.security.core.ws.xenc.EncryptedDataElement;
import com.sap.security.core.ws.xenc.EncryptedKeyElement;
import com.sap.security.core.ws.xenc.EncryptionMethodElement;
import iaik.x509.X509Certificate;
import java.security.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.parsers.FactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttachmentEncryptionProcessor
implements WSProcessor {
    private String encryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private X509Certificate certificate;
    private List attchmentIDList = new ArrayList();
    private static int ID;
    static /* synthetic */ Class class$com$sap$security$core$ws$xenc$EncryptedKeyElement;

    public void apply(WSSecurityDocument securityDocument) throws ProcessException {
        if (this.attchmentIDList.size() == 0) {
            return;
        }
        try {
            SecurityPolicyConstants constants = securityDocument.getSecurityContext().getConstants();
            Document soapDocument = securityDocument.getSoapDocument();
            Element securityHeaderElement = securityDocument.getSecurityHeaderElement();
            String keyAlg = null;
            String symAlgURI = this.getEncryptionAlgorithm();
            if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(symAlgURI)) {
                keyAlg = "AES";
            } else if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(symAlgURI)) {
                keyAlg = "DESede";
            }
            KeyGenerator keyGen = null;
            keyGen = KeyGenerator.getInstance(keyAlg);
            SecretKey symmetricKey = keyGen.generateKey();
            EncryptedKeyElement keyElement = this.createEncryptedKey(constants, symmetricKey, this.getCertificate());
            String keyID = this.getID("EK");
            keyElement.setId(keyID);
            Element securityHeader = securityDocument.getSecurityHeaderElement();
            WSMappingUtil mapping = SecurityPolicyConstants.getMappingUtilByNamespace(constants.WSSE_URI);
            mapping.marshall(keyElement, securityHeader, keyElement.getClass().getClassLoader());
            Iterator attachmentIdIterator = this.attchmentIDList.iterator();
            while (attachmentIdIterator.hasNext()) {
                String attachmentID = (String)attachmentIdIterator.next();
                AttachmentData attachment = securityDocument.getAttachments().getAttachmentData(attachmentID.substring(1));
                attachment.setContentID(attachmentID.substring(1));
                if (attachment == null) {
                    IDMessage message = ProcessMessage.ID0600_CONFIDENTIALITY_APPLY_ERROR.create((Object)"No such attchment ", (Object)attachmentID);
                    throw new ProcessException(message, null);
                }
                EncryptedDataElement ed = this.encryptAttachment(constants, attachment, symmetricKey, keyElement, symAlgURI);
                mapping.marshall(ed, securityHeader, keyElement.getClass().getClassLoader());
            }
        }
        catch (Throwable ex) {
            throw new ProcessException(ProcessMessage.ID0700_CONFIDENTIALITY_PROCESS_ERROR.create((Object)ex.getClass().getName(), (Object)ex.getMessage()), ex);
        }
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void addToEncryptionList(String attachmentId) {
        this.attchmentIDList.add(attachmentId);
    }

    public int getEncryptionListSize() {
        return this.attchmentIDList.size();
    }

    private String getID(String prefix) {
        String idString = prefix + "-" + System.currentTimeMillis() + "-" + ++ID;
        return idString;
    }

    public EncryptedDataElement encryptAttachment(SecurityPolicyConstants constants, AttachmentData data, Key symmetricKey, EncryptedKeyElement encryptedKeyElement, String symmetricKeyAlgorithm) throws SignatureException {
        XMLEncryptor enc = new XMLEncryptor();
        enc.setEncryptionKey(symmetricKey);
        byte[] encryptedData = enc.encryptRaw(data.getPayload(), symmetricKeyAlgorithm);
        CipherReferenceElement cr = new CipherReferenceElement();
        cr.setURI("#" + data.getContentID());
        TransformElement tr = new TransformElement();
        tr.setAlgorithm(constants.WSSE_SWA_ATTACHMENT_CONTENT_ONLY);
        TransformsElement trs = new TransformsElement();
        trs.addTransform(tr);
        cr.setTransforms(trs);
        CipherDataElement cd = new CipherDataElement();
        cd.setCipherReference(cr);
        EncryptionMethodElement em = new EncryptionMethodElement();
        em.setAlgorithm(symmetricKeyAlgorithm);
        RetrievalMethodElement retrievalMethodElement = new RetrievalMethodElement();
        KeyInfoElement keyInfo = new KeyInfoElement();
        retrievalMethodElement.setURI("#" + encryptedKeyElement.getId());
        retrievalMethodElement.setType("http://www.w3.org/2001/04/xmlenc#EncryptedKey");
        keyInfo.setRetrievalMethod(retrievalMethodElement);
        EncryptedDataElement ed = new EncryptedDataElement();
        ed.setMimeType(data.getContentType());
        ed.setType(constants.WSSE_SWA_ATTACHMENT_CONTENT_ONLY);
        ed.setCipherData(cd);
        ed.setEncryptionMethod(em);
        ed.setKeyInfo(keyInfo);
        data.setContentType("application/octet-stream");
        data.setPayload(encryptedData);
        return ed;
    }

    public EncryptedKeyElement createEncryptedKey(SecurityPolicyConstants constants, Key symmetricKey, X509Certificate certificate) throws FactoryConfigurationError, Exception {
        Document doc = new DocumentBuilderFactoryImpl().newDocumentBuilder().newDocument();
        EncryptedKeyGenerator ekg = new EncryptedKeyGenerator();
        ekg.init((Node)doc.getDocumentElement());
        ekg.setType(null);
        EncryptedKey ek = ekg.getEncryptedKey("http://www.w3.org/2001/04/xmlenc#rsa-1_5", (Key)certificate.getPublicKey(), symmetricKey);
        WSMappingUtil mapping = SecurityPolicyConstants.getMappingUtilByNamespace(constants.WSSE_URI);
        EncryptedKeyElement encryptedKey = (EncryptedKeyElement)mapping.unmarshall((Element)ek.getDomRepresentation(), (class$com$sap$security$core$ws$xenc$EncryptedKeyElement == null ? (class$com$sap$security$core$ws$xenc$EncryptedKeyElement = AttachmentEncryptionProcessor.class$("com.sap.security.core.ws.xenc.EncryptedKeyElement")) : class$com$sap$security$core$ws$xenc$EncryptedKeyElement).getClassLoader());
        KeyIdentifierElement kid = new KeyIdentifierElement(certificate, constants.WSSE_BASE64_BINARY_URI, constants.WSSE_SUBJECT_KEY_IDENTIFIER_URI);
        SecurityTokenReference str = new SecurityTokenReference();
        str.setKeyIdentifier(kid);
        KeyInfoElement ki = new KeyInfoElement();
        ki.setSecurityTokenReference(str);
        encryptedKey.setKeyInfo(ki);
        return encryptedKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

