/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.policy;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import java.io.IOException;
import java.io.Serializable;

public class WSPolicyConfigurationData
implements Serializable {
    String inboundPolicyProfile = "";
    String outboundPolicyProfile = "";
    String inboundPolicyTemplate = "";
    String outboundPolicyTemplate = "";
    final String VERSION = "1.0";

    public WSPolicyConfigurationData() {
    }

    public WSPolicyConfigurationData(String inboundPolicyProfile, String outboundPolicyProfile) {
        this.inboundPolicyProfile = inboundPolicyProfile;
        this.outboundPolicyProfile = outboundPolicyProfile;
    }

    public WSPolicyConfigurationData(Configuration configuration) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        this.read(configuration);
    }

    public void read(Configuration applicationConfiguration) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        Configuration wssConfiguration = null;
        Configuration inboundConfiguration = null;
        Configuration outboundConfiguration = null;
        wssConfiguration = applicationConfiguration.getSubConfiguration("wss");
        inboundConfiguration = wssConfiguration.getSubConfiguration("inbound");
        outboundConfiguration = wssConfiguration.getSubConfiguration("outbound");
        String version = (String)wssConfiguration.getConfigEntry("version");
        if (!"1.0".equals(version)) {
            throw new ConfigurationException("Invalid version");
        }
        this.inboundPolicyProfile = (String)inboundConfiguration.getConfigEntry("profile");
        this.outboundPolicyProfile = (String)outboundConfiguration.getConfigEntry("profile");
        this.inboundPolicyTemplate = (String)inboundConfiguration.getConfigEntry("template");
        this.outboundPolicyTemplate = (String)outboundConfiguration.getConfigEntry("template");
    }

    public void store(Configuration applicationConfiguration) throws ConfigurationLockedException, ConfigurationException, IOException {
        Configuration wssConfiguration = null;
        Configuration inboundConfiguration = null;
        Configuration outboundConfiguration = null;
        if (applicationConfiguration.existsSubConfiguration("wss")) {
            wssConfiguration = applicationConfiguration.getSubConfiguration("wss");
            inboundConfiguration = wssConfiguration.getSubConfiguration("inbound");
            outboundConfiguration = wssConfiguration.getSubConfiguration("outbound");
            String version = (String)wssConfiguration.getConfigEntry("version");
            if (!"1.0".equals(version)) {
                throw new ConfigurationException("Invalid version");
            }
        } else {
            wssConfiguration = applicationConfiguration.createSubConfiguration("wss");
            inboundConfiguration = wssConfiguration.createSubConfiguration("inbound");
            outboundConfiguration = wssConfiguration.createSubConfiguration("outbound");
            wssConfiguration.addConfigEntry("version", (Object)"1.0");
        }
        if (inboundConfiguration.existsConfigEntry("profile")) {
            inboundConfiguration.deleteConfigEntry("profile");
            inboundConfiguration.addConfigEntry("profile", (Object)this.inboundPolicyProfile);
        } else {
            inboundConfiguration.addConfigEntry("profile", (Object)this.inboundPolicyProfile);
        }
        if (inboundConfiguration.existsConfigEntry("template")) {
            inboundConfiguration.deleteConfigEntry("template");
            inboundConfiguration.addConfigEntry("template", (Object)this.inboundPolicyTemplate);
        } else {
            inboundConfiguration.addConfigEntry("template", (Object)this.inboundPolicyTemplate);
        }
        if (outboundConfiguration.existsConfigEntry("profile")) {
            outboundConfiguration.deleteConfigEntry("profile");
            outboundConfiguration.addConfigEntry("profile", (Object)this.outboundPolicyProfile);
        } else {
            outboundConfiguration.addConfigEntry("profile", (Object)this.outboundPolicyProfile);
        }
        if (outboundConfiguration.existsConfigEntry("template")) {
            outboundConfiguration.deleteConfigEntry("template");
            outboundConfiguration.addConfigEntry("template", (Object)this.outboundPolicyTemplate);
        } else {
            outboundConfiguration.addConfigEntry("template", (Object)this.outboundPolicyTemplate);
        }
    }

    public String getInboundPolicyProfile() {
        return this.inboundPolicyProfile;
    }

    public String getOutboundPolicyProfile() {
        return this.outboundPolicyProfile;
    }

    public void setInboundPolicyProfile(String string) {
        this.inboundPolicyProfile = string;
    }

    public void setOutboundPolicyProfile(String string) {
        this.outboundPolicyProfile = string;
    }

    public String getInboundPolicyTemplate() {
        return this.inboundPolicyTemplate;
    }

    public String getOutboundPolicyTemplate() {
        return this.outboundPolicyTemplate;
    }

    public void setInboundPolicyTemplate(String string) {
        this.inboundPolicyTemplate = string;
    }

    public void setOutboundPolicyTemplate(String string) {
        this.outboundPolicyTemplate = string;
    }
}

