/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.client.ws;

import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.security.core.client.ws.AuthenticationContext;
import com.sap.security.core.client.ws.AuthenticationContextMessage;
import com.sap.security.core.client.ws.DestinationServiceNotAvailableException;
import com.sap.security.core.client.ws.DestinationServiceNotAvailableExceptionMessage;
import com.sap.security.core.client.ws.SSO2Exception;
import com.sap.security.core.client.ws.SSO2ExceptionMessage;
import com.sap.security.core.server.destinations.api.DestinationException;
import com.sap.security.core.server.destinations.api.DestinationService;
import com.sap.security.core.server.destinations.service.HTTPDestinationImpl;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class DeployableAuthenticationContext
extends AuthenticationContext {
    public static final String DESTINATION_TYPE = "WebService";
    private PropertyContext authenticationFeatureContext;
    private boolean invalidateAllSessions;
    private transient KeystoreManager keystoreManager;
    private Hashtable httpHeaderHashtable = new Hashtable();
    private DestinationService dstService;
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$client$ws$AuthenticationContext == null ? (class$com$sap$security$core$client$ws$AuthenticationContext = DeployableAuthenticationContext.class$("com.sap.security.core.client.ws.AuthenticationContext")) : class$com$sap$security$core$client$ws$AuthenticationContext));
    Category CATEGORY = Category.SYS_SECURITY;
    private int dstHash = 0;
    static /* synthetic */ Class class$com$sap$security$core$client$ws$AuthenticationContext;

    public DeployableAuthenticationContext(DestinationService dstService, KeystoreManager keystoreManager, PropertyContext authenticationFeatureContext, boolean invalidateAllSessions) {
        super(authenticationFeatureContext);
        String method = "DeployableAuthenticationContext";
        LOCATION.entering("DeployableAuthenticationContext");
        this.authenticationFeatureContext = authenticationFeatureContext;
        this.dstService = dstService;
        this.keystoreManager = keystoreManager;
        this.invalidateAllSessions = invalidateAllSessions;
        LOCATION.exiting();
    }

    private final X509Certificate[] getClientCertificate(String clientAuthenticationView, String certificateAlias) throws CertificateException, RemoteException, KeyStoreException {
        String method = "getClientCertificate";
        LOCATION.entering("getClientCertificate");
        KeystoreManager ks = this.getKeystoreManager();
        if (!ks.existKeystoreView(clientAuthenticationView)) {
            CertificateException ce = new CertificateException("No such view:" + clientAuthenticationView);
            LOCATION.exiting((Object)ce);
            throw ce;
        }
        if (!ks.getKeystore(clientAuthenticationView).containsAlias(certificateAlias)) {
            CertificateException ce = new CertificateException("No such certificate " + certificateAlias + " in view " + clientAuthenticationView);
            LOCATION.exiting((Object)ce);
            throw ce;
        }
        Certificate[] chain = ks.getKeystore(clientAuthenticationView).getCertificateChain(certificateAlias);
        X509Certificate[] x509Certificates = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            if (chain[i] instanceof X509Certificate) {
                x509Certificates[i] = (X509Certificate)chain[i];
            }
            ++i;
        }
        LOCATION.exiting((Object)x509Certificates);
        return x509Certificates;
    }

    private final List getServerCertificates(String keystoreView) throws CertificateException, RemoteException, KeyStoreException {
        String method = "getServerCertificates";
        LOCATION.entering("getServerCertificates");
        KeystoreManager km = this.getKeystoreManager();
        if (!km.existKeystoreView(keystoreView)) {
            CertificateException ce = new CertificateException("No such view:" + keystoreView);
            LOCATION.exiting((Object)ce);
            throw ce;
        }
        KeyStore keystore = km.getKeystore(keystoreView);
        Enumeration<String> aliasEnumeration = keystore.aliases();
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        while (aliasEnumeration.hasMoreElements()) {
            String alias = aliasEnumeration.nextElement();
            Certificate cert = keystore.getCertificate(alias);
            if (!(cert instanceof X509Certificate)) continue;
            list.add(cert);
        }
        LOCATION.exiting(list);
        return list;
    }

    private KeystoreManager getKeystoreManager() throws KeyStoreException {
        String method = "getKeystoreManager";
        LOCATION.entering("getKeystoreManager");
        if (this.keystoreManager == null) {
            KeyStoreException kex = new KeyStoreException("Keystore service not running");
            LOCATION.exiting((Object)kex);
            throw kex;
        }
        LOCATION.exiting((Object)this.keystoreManager);
        return this.keystoreManager;
    }

    private final PrivateKey getClientPrivateKey(String clientAuthenticationView, String certificateAlias) throws CertificateException, RemoteException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String method = "getClientPrivateKey";
        LOCATION.entering("getClientPrivateKey");
        KeystoreManager ks = this.getKeystoreManager();
        if (!ks.existKeystoreView(clientAuthenticationView)) {
            CertificateException ce = new CertificateException("No such view:" + clientAuthenticationView);
            LOCATION.exiting((Object)ce);
            throw ce;
        }
        if (!ks.getKeystore(clientAuthenticationView).containsAlias(certificateAlias)) {
            CertificateException ce = new CertificateException("No such certificate " + certificateAlias + " in view " + clientAuthenticationView);
            LOCATION.exiting((Object)ce);
            throw ce;
        }
        Key key = ks.getKeystore(clientAuthenticationView).getKey(certificateAlias, new char[0]);
        if (key instanceof PrivateKey) {
            PrivateKey pk = (PrivateKey)key;
            LOCATION.exiting((Object)"key:found");
            return pk;
        }
        CertificateException ex = new CertificateException("Private key is not an instance of java.security.PrivateKey");
        LOCATION.exiting((Object)ex);
        throw ex;
    }

    protected void setDestination(String destinationName, PropertyContext context) throws DestinationServiceNotAvailableException, KeyStoreException, CertificateException, RemoteException, UnrecoverableKeyException, NoSuchAlgorithmException, SSO2Exception, DestinationException {
        if (this.dstService == null) {
            throw new DestinationServiceNotAvailableException(DestinationServiceNotAvailableExceptionMessage.ID0100_NO_DESTINATION_SERVICE.create((Object)"tc~sec~destinations~service"), null);
        }
        HTTPDestinationImpl destination = (HTTPDestinationImpl)this.dstService.getDestination(DESTINATION_TYPE, destinationName);
        this.setDestination(destination, context);
    }

    protected void setDestination(HTTPDestinationImpl destination, PropertyContext context) throws CertificateException, KeyStoreException, RemoteException, UnrecoverableKeyException, NoSuchAlgorithmException, SSO2Exception {
        Properties destinationProperties;
        String method = "setDestination";
        LOCATION.entering("setDestination");
        boolean sendSessionID = true;
        PropertyContext featureConfig = context.getSubContext("featureConfig");
        PropertyContext authFeature = featureConfig.getSubContext("http://www.sap.com/webas/630/soap/features/authentication");
        PropertyContext sessionFeature = featureConfig.getSubContext("http://www.sap.com/webas/630/soap/features/session/");
        String authenticationMechanism = (String)authFeature.getProperty("AuthenticationMechanism");
        this.httpHeaderHashtable.clear();
        if (this.CATEGORY.beInfo()) {
            Properties clonedProperties = (Properties)((Hashtable)destination.getDestinationProperties()).clone();
            if (((Hashtable)clonedProperties).containsKey("PASSWORD")) {
                clonedProperties.setProperty("PASSWORD", "XXX");
            }
            if (((Hashtable)clonedProperties).containsKey("SSO2.ENCODED")) {
                clonedProperties.setProperty("SSO2.ENCODED", "XXX");
            }
            if (((Hashtable)clonedProperties).containsKey("SSO2")) {
                clonedProperties.setProperty("SSO2", "XXX");
            }
            AuthenticationContextMessage.ID0100_SET_DESTINATION.create((Object)clonedProperties).log(300, this.CATEGORY, LOCATION, "setDestination");
        }
        this.setUsername(null);
        this.setPassword(null);
        String authenticationType = destination.getAuthenticationType();
        if ("Logon Ticket".equals(authenticationType)) {
            destinationProperties = destination.getDestinationProperties();
            if (destinationProperties.getProperty("SSO2.ENCODED") == null) {
                SSO2Exception sso2Exception = new SSO2Exception(SSO2ExceptionMessage.ID0100_NO_SSO2.create(), null);
                LOCATION.exiting((Object)sso2Exception);
                throw sso2Exception;
            }
            this.httpHeaderHashtable.put("Cookie", "MYSAPSSO2=" + destinationProperties.getProperty("SSO2.ENCODED"));
            sendSessionID = false;
        } else if ("BASIC".equals(authenticationType)) {
            destinationProperties = destination.getDestinationProperties();
            this.setUsername(destinationProperties.getProperty("USERNAME"));
            this.setPassword(destinationProperties.getProperty("PASSWORD"));
            int hashBuffer = ((Hashtable)destinationProperties).hashCode();
            boolean passwordChanged = this.dstHash != hashBuffer;
            this.dstHash = hashBuffer;
            sendSessionID = !passwordChanged;
        }
        if ("X.509 Client Certificate".equals(authenticationType) || !destination.isIgnoreServerCertificates()) {
            Object result = AccessController.doPrivileged(new SetDestinationPrivilegedAction(destination, context));
            if (result != null) {
                LOCATION.exiting(result);
                if (result instanceof CertificateException) {
                    throw (CertificateException)result;
                }
                if (result instanceof KeyStoreException) {
                    throw (KeyStoreException)result;
                }
                if (result instanceof RemoteException) {
                    throw (RemoteException)result;
                }
                if (result instanceof UnrecoverableKeyException) {
                    throw (UnrecoverableKeyException)result;
                }
                if (result instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)result;
                }
                if (result instanceof SSO2Exception) {
                    throw (SSO2Exception)((Object)result);
                }
            }
            sendSessionID = true;
        }
        if ("Document".equals(authenticationMechanism)) {
            sendSessionID = false;
        }
        if ((this.invalidateAllSessions || !sendSessionID) && sessionFeature.isDefined()) {
            sessionFeature.clearProperty("SessionCoockie");
            sessionFeature.setProperty("maintainSession", (Object)"yes");
        }
        LOCATION.exiting();
    }

    protected void setHTTPDestination(String destinationName, PropertyContext context) throws ClientProtocolException {
        String method = "setHTTPDestination";
        LOCATION.entering("setHTTPDestination");
        try {
            try {
                if (this.dstService == null) {
                    throw new DestinationServiceNotAvailableException(DestinationServiceNotAvailableExceptionMessage.ID0100_NO_DESTINATION_SERVICE.create((Object)"tc~sec~destinations~service"), null);
                }
                HTTPDestinationImpl destination = (HTTPDestinationImpl)this.dstService.getDestination("HTTP", destinationName);
                this.setDestination(destination, context);
            }
            catch (Exception e) {
                IDMessage message = AuthenticationContextMessage.ID0200_ERROR_SETTING_DESTINATION.create((Object)e.getClass().getName(), (Object)e.getMessage());
                message.log(500, this.CATEGORY, LOCATION, "setHTTPDestination");
                throw new ClientProtocolException(message.format());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    protected void setDestinationInternal(HTTPDestinationImpl destination, PropertyContext context) throws CertificateException, KeyStoreException, RemoteException, UnrecoverableKeyException, NoSuchAlgorithmException, SSO2Exception {
        String method = "setDestinationInternal";
        LOCATION.entering("setDestinationInternal");
        if (destination == null) {
            return;
        }
        String authenticationType = destination.getAuthenticationType();
        if ("X.509 Client Certificate".equals(authenticationType)) {
            Properties destinationProperties = destination.getDestinationProperties();
            String certificateView = destinationProperties.getProperty("CLIENT_AUTHENTICATION_KEYSTORE_VIEW", "");
            String certificateAlias = destinationProperties.getProperty("CLIENT_AUTHENTICATION_KEYSTORE_CERTIFICATE", "");
            X509Certificate[] certificates = this.getClientCertificate(certificateView, certificateAlias);
            PrivateKey certificateKey = this.getClientPrivateKey(certificateView, certificateAlias);
            this.addClientCertificate(certificates, certificateKey);
        }
        this.setIgnoreSSLServerCertificate(destination.isIgnoreServerCertificates());
        if (!destination.isIgnoreServerCertificates() && destination.getUrl() != null && destination.getUrl().toLowerCase().startsWith("https")) {
            String serverCertificateView = destination.getSslServerCertificateView();
            this.setServerCertificateList(this.getServerCertificates(serverCertificateView));
        }
    }

    protected Hashtable getHttpHeaderHashtable() {
        return this.httpHeaderHashtable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SetDestinationPrivilegedAction
    implements PrivilegedAction {
        HTTPDestinationImpl destination;
        PropertyContext context = null;

        public SetDestinationPrivilegedAction(HTTPDestinationImpl destination, PropertyContext context) {
            this.destination = destination;
            this.context = context;
        }

        public Object run() {
            String method = "SetDestinationPrivilegedAction:run";
            LOCATION.entering("SetDestinationPrivilegedAction:run");
            try {
                DeployableAuthenticationContext.this.setDestinationInternal(this.destination, this.context);
                LOCATION.exiting((Object)null);
                return null;
            }
            catch (Exception ex) {
                LOCATION.exiting((Object)ex);
                return ex;
            }
        }
    }
}

