/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.scanner.IJverClassEnumeration;
import com.sap.tc.jtools.jver.scanner.IJverClassLoader;
import com.sap.tc.jtools.jver.scanner.IJverScannerMsg;
import com.sap.tc.jtools.jver.scanner.IScanner;
import com.sap.tc.jtools.jver.scanner.JverClassPathSet;
import com.sap.tc.jtools.jver.scanner.JverTargetVector;
import com.sap.tc.jtools.jver.scanner.PTComponent;
import com.sap.tc.jtools.jver.scanner.PTComposite;
import com.sap.tc.jtools.jver.scanner.PTWalker;
import com.sap.tc.jtools.jver.scanner.PackageTree;
import java.io.File;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ScannerByPackage
implements IScanner {
    protected PackageTree packageTree_;
    private PTWalker ptWalker_;
    private String[] packages_ = null;
    private int iCurrentSubTree_ = -1;
    private IMsgCollector msgCollector_ = null;
    private IJverClassLoader loader_ = null;

    public void init(IJverClassLoader loader, IMsgCollector msgCollector) {
        this.loader_ = loader;
        this.msgCollector_ = msgCollector;
    }

    public void setTargets(JverConfig config, JverTargetVector packages, String classPath) {
        JverClassPathSet classPathSet = new JverClassPathSet();
        String loadPath = null;
        if (classPath != null && classPath.length() > 0) {
            classPathSet.readPathList(classPath, false);
            loadPath = classPath;
        } else {
            classPathSet.readDefaultClassPath();
        }
        this.packageTree_ = new PackageTree(this.msgCollector_, config);
        this.packageTree_.fill(classPathSet);
        this.ptWalker_ = new PTWalker(this.loader_, loadPath, this.msgCollector_);
        if (packages.size() == 0) {
            this.ptWalker_.setSubTreeRoot(this.packageTree_.getRoot(), "");
        } else {
            this.setPackages(packages.getTargetArray());
            this.setSubTreeFirst();
        }
    }

    public Enumeration elements() {
        return new IJverClassEnumeration(){
            private boolean fetch = true;
            private Class nextClass = null;

            private void fetchIfNecessary() {
                if (this.fetch) {
                    this.nextClass = ScannerByPackage.this.getNextClass();
                    this.fetch = false;
                }
            }

            public boolean hasMoreElements() {
                this.fetchIfNecessary();
                return this.nextClass != null;
            }

            public Object nextElement() {
                ScannerByPackage scannerByPackage = ScannerByPackage.this;
                synchronized (scannerByPackage) {
                    this.fetchIfNecessary();
                    this.fetch = true;
                    if (this.nextClass == null) {
                        throw new NoSuchElementException("Scanner Enumeration");
                    }
                    Class clazz = this.nextClass;
                    return clazz;
                }
            }

            public File getCurrentPropertyFile() {
                return null;
            }
        };
    }

    private Class getNextClass() {
        Class cl;
        while (((cl = this.ptWalker_.getNextClassFromCurrentPackage()) != null || this.setSubTreeNext()) && cl == null) {
        }
        return cl;
    }

    private void setSubTreeFirst() {
        this.iCurrentSubTree_ = -1;
        this.setSubTreeNext();
    }

    private boolean setSubTreeNext() {
        while (this.getPackages() != null && ++this.iCurrentSubTree_ < this.getPackages().length) {
            String packageName = this.getPackages(this.iCurrentSubTree_);
            DbgLog.println("Examining subtree:'" + packageName + "'");
            PTComponent target = this.packageTree_.findComponent(packageName);
            if (target == null) {
                IJverScannerMsg.PACKAGE_NOT_FOUND.add(this.msgCollector_, packageName);
                continue;
            }
            PTComposite targetNode = target.getComposite();
            if (targetNode == null) {
                if (!this.ptWalker_.setNextTestClassIfValid(packageName)) continue;
                return true;
            }
            this.ptWalker_.setSubTreeRoot(targetNode, packageName);
            return true;
        }
        return false;
    }

    public String[] getPackages() {
        return this.packages_;
    }

    public String getPackages(int i) {
        return this.packages_[i];
    }

    public void setPackages(String[] packages) {
        this.packages_ = packages;
    }
}

