/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.scanner.IJverClassLoader;
import com.sap.tc.jtools.jver.scanner.IJverScannerMsg;
import com.sap.tc.jtools.jver.scanner.JverTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Vector;

public class JverTargetVector
extends Vector {
    private JverTarget currentSet = null;
    private InfoType currentInfo = new InfoEmpty();
    private int currentTestCount = 0;
    private String commonClassPath = "";
    private String parent_ = null;

    public void setCommonClassPath(String path) {
        this.commonClassPath = path;
    }

    public String getCommonClassPath() {
        return this.commonClassPath;
    }

    public synchronized String[] getTargetArray() {
        String[] result = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            result[i] = this.getTargetSet(i).getTarget();
            ++i;
        }
        return result;
    }

    public JverTarget getTargetSet(int pos) {
        return (JverTarget)this.elementAt(pos);
    }

    public void readList(String[] targets) {
        int ii = 0;
        while (ii < targets.length) {
            JverTarget set = new JverTarget();
            set.setTarget(targets[ii]);
            this.add(set);
            ++ii;
        }
    }

    public void readTaskFile(File targetList) throws FileNotFoundException, IOException, JverProcessException {
        this.parent_ = targetList.getParent();
        FileReader taskReader = new FileReader(targetList);
        StreamTokenizer input = new StreamTokenizer(taskReader);
        this.readTask(input);
    }

    public void readTaskFile(String taskPath, IJverClassLoader jverClassLoader, String addPath) throws FileNotFoundException, IOException, JverProcessException {
        InputStream taskInputStream = jverClassLoader.getResourceAsStream(taskPath, addPath);
        if (taskInputStream == null) {
            throw new FileNotFoundException();
        }
        InputStreamReader isReader = new InputStreamReader(taskInputStream);
        BufferedReader reader = new BufferedReader(isReader);
        StreamTokenizer input = new StreamTokenizer(reader);
        this.parent_ = this.getParentForResource(taskPath, jverClassLoader, addPath);
        this.readTask(input);
    }

    private void readTask(StreamTokenizer input) throws IOException, JverProcessException {
        input.commentChar(35);
        input.quoteChar(34);
        input.wordChars(95, 95);
        input.wordChars(36, 36);
        input.wordChars(123, 123);
        input.wordChars(125, 125);
        int tokenType = 0;
        this.currentTestCount = 0;
        this.currentInfo = new InfoEmpty();
        boolean bReady = false;
        do {
            tokenType = input.nextToken();
            switch (tokenType) {
                case -3: 
                case 34: {
                    this.currentInfo.process(input.sval);
                    break;
                }
                case 61: {
                    this.currentInfo.flagAssignToken();
                    break;
                }
                case -1: {
                    bReady = true;
                    break;
                }
            }
        } while (!bReady);
        if (this.currentInfo.getTokenNumber() != 0) {
            throw new JverProcessException(IJverScannerMsg.WRONG_TASK_FORMAT, (Object)"unbalanced key value pair");
        }
    }

    protected String getParentForResource(String resource, IJverClassLoader jverClassLoader, String addPath) {
        URL url = jverClassLoader.getResource(resource, addPath);
        if (url != null) {
            String u = url.toString();
            File file = new File(u);
            String parent = file.getParent();
            return parent;
        }
        return null;
    }

    private class InfoProperties
    extends InfoValue {
        private InfoProperties() {
        }

        public void process(String sval) throws JverProcessException {
            this.checkAssignmentFlag();
            if (JverTargetVector.this.currentSet != null) {
                File propertyFile = new File(JverTargetVector.this.parent_, this.resolve(sval));
                JverTargetVector.this.currentSet.setPropertyFile(propertyFile);
            }
            JverTargetVector.this.currentInfo = new InfoEmpty();
        }
    }

    private class InfoCommonClassPath
    extends InfoValue {
        private InfoCommonClassPath() {
        }

        public void process(String sval) throws JverProcessException {
            this.checkAssignmentFlag();
            JverTargetVector.this.setCommonClassPath(this.resolve(sval));
            JverTargetVector.this.currentInfo = new InfoEmpty();
        }
    }

    private class InfoClassPath
    extends InfoValue {
        private InfoClassPath() {
        }

        public void process(String sval) throws JverProcessException {
            this.checkAssignmentFlag();
            if (JverTargetVector.this.currentSet != null) {
                JverTargetVector.this.currentSet.setClassPath(this.resolve(sval));
            }
            JverTargetVector.this.currentInfo = new InfoEmpty();
        }
    }

    private class InfoTest
    extends InfoValue {
        private InfoTest() {
        }

        public void process(String sval) throws JverProcessException {
            this.checkAssignmentFlag();
            JverTargetVector.this.currentSet = new JverTarget();
            JverTargetVector.this.currentSet.setTarget(this.resolve(sval));
            JverTargetVector.this.currentTestCount++;
            JverTargetVector.this.add(JverTargetVector.this.currentSet);
            JverTargetVector.this.currentInfo = new InfoEmpty();
        }
    }

    private class InfoEmpty
    implements InfoType {
        private InfoEmpty() {
        }

        public void process(String sval) {
            if (sval.equalsIgnoreCase("test")) {
                JverTargetVector.this.currentInfo = new InfoTest();
            } else if (sval.equalsIgnoreCase("classpath")) {
                JverTargetVector.this.currentInfo = new InfoClassPath();
            } else if (sval.equalsIgnoreCase("commonclasspath")) {
                JverTargetVector.this.currentInfo = new InfoCommonClassPath();
            } else if (sval.equalsIgnoreCase("properties")) {
                JverTargetVector.this.currentInfo = new InfoProperties();
            }
        }

        public void flagAssignToken() throws JverProcessException {
            throw new JverProcessException(IJverScannerMsg.WRONG_TASK_FORMAT, (Object)"unbalanced key value pair (no key)");
        }

        public int getTokenNumber() {
            return 0;
        }
    }

    private abstract class InfoValue
    implements InfoType {
        private boolean bAssignTokenSeen_ = false;

        private InfoValue() {
        }

        public abstract void process(String var1) throws JverProcessException;

        public void checkAssignmentFlag() throws JverProcessException {
            if (!this.bAssignTokenSeen_) {
                throw new JverProcessException(IJverScannerMsg.WRONG_TASK_FORMAT, (Object)"unbalanced key value pair");
            }
        }

        protected String resolve(String sval) throws JverProcessException {
            int posB = sval.indexOf("${");
            if (posB < 0) {
                return sval;
            }
            int len = sval.length();
            StringBuffer buffer = new StringBuffer(len * 2);
            int posE = 0;
            do {
                buffer.append(sval.substring(posE, posB));
                posE = sval.indexOf(125, posB);
                if (posE < 0) {
                    throw new JverProcessException(IJverScannerMsg.WRONG_TASK_FORMAT, (Object)"unbalanced ${}");
                }
                String var = sval.substring(posB, ++posE);
                String value = this.getReplacementItem(var);
                buffer.append(value);
            } while ((posB = sval.indexOf("${", posE)) >= 0);
            buffer.append(sval.substring(posE, len));
            return buffer.toString();
        }

        private String getReplacementItem(String var) {
            int len = var.length();
            String item = System.getProperty(var.substring(2, len - 1), var);
            return item;
        }

        public void flagAssignToken() {
            this.bAssignTokenSeen_ = true;
        }

        public int getTokenNumber() {
            return this.bAssignTokenSeen_ ? 2 : 1;
        }
    }

    private static interface InfoType {
        public void process(String var1) throws JverProcessException;

        public void flagAssignToken() throws JverProcessException;

        public int getTokenNumber();
    }
}

