/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.scanner;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.scanner.JverJ2eeConfig;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class JverClassPathSet
extends Vector {
    public JverClassPathSet() {
    }

    public JverClassPathSet(int initialCapacity) {
        super(initialCapacity);
    }

    public void readPathList(String pathList) {
        this.readPathList(pathList, true);
    }

    public void readPathList(String pathList, boolean bIncludeDefault) {
        this.readPathListInternal(pathList);
        if (bIncludeDefault) {
            this.readDefaultClassPath();
        }
    }

    public boolean add(Object o) {
        if (o instanceof File) {
            return super.add(o);
        }
        throw new RuntimeException("Only 'File' objects allowed.");
    }

    public boolean add(File pFile) throws IOException {
        File file = pFile.getCanonicalFile();
        return super.add(file);
    }

    public void readDefaultClassPath() {
        String path = JverJ2eeConfig.isRunningInJ2ee() ? JverJ2eeConfig.getJ2eeDefaultClassPath() : System.getProperty("java.class.path", ".");
        this.readPathListInternal(path);
    }

    private void readPathListInternal(String pathList) {
        if (pathList == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(pathList, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String pathSingle = tokenizer.nextToken().trim();
            if (pathSingle == null) continue;
            File file = new File(pathSingle);
            if (file.exists()) {
                try {
                    if (this.contains(file)) continue;
                    this.add(file);
                }
                catch (IOException e) {
                    DbgLog.println("Path: " + file.getAbsolutePath() + " ignored: could not be resolved.");
                    DbgLog.printStackTrace(e);
                }
                continue;
            }
            DbgLog.println("Path: " + file.getAbsolutePath() + " ignored: does not exist.");
        }
    }
}

