/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverFlopException;
import com.sap.tc.jtools.jver.core.JverLogPerf;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.driver.IJverFixture;
import com.sap.tc.jtools.jver.driver.performance.APerfTestRun;
import com.sap.tc.jtools.jver.driver.performance.PerfConfig;
import com.sap.tc.jtools.jver.driver.performance.PerfExecStateMT;
import com.sap.tc.jtools.jver.driver.performance.PerfMsgCollectorMT;
import com.sap.tc.jtools.jver.driver.performance.PerfResultMT;
import com.sap.tc.jtools.jver.driver.performance.PerfTestDescription;
import com.sap.tc.jtools.jver.driver.performance.PerfTestThreadMT;
import com.sap.tc.jtools.jver.framework.Test;

public class PerfTestRunMT
extends APerfTestRun {
    private long fgThgCnt = 0L;

    public PerfTestRunMT(IMsgCollector msgCollector, PerfConfig config) {
        super(msgCollector, config);
    }

    protected APerfTestRun.IPerfResult execTestMethod(PerfTestDescription description, Test testObject) throws InterruptedException {
        int numThreads = description.getNumThreads();
        PerfTestThreadMT[] perfThreads = new PerfTestThreadMT[numThreads];
        int ii = 0;
        while (ii < numThreads) {
            perfThreads[ii] = new PerfTestThreadMT(description, testObject);
            ++ii;
        }
        final PerfResultMT[] curResults = this.execute(description, perfThreads, this.config_.getMtXtraTimeout());
        return new APerfTestRun.IPerfResult(){

            public PerfResultMT[] getResultArray() {
                return curResults;
            }

            public long getDurationMilliSecs() {
                return 0L;
            }
        };
    }

    protected boolean evalResult(PerfTestDescription pTestMethod, APerfTestRun.IPerfResult pTestResult, APerfTestRun.IPerfResult pRefResult, long pGcTestMillis, long pGcRefMillis) {
        PerfResultMT[] testResults = pTestResult.getResultArray();
        String fullName = pTestMethod.getFullName();
        String fullNameBrackets = "[" + pTestMethod.getFullName() + "]";
        long burdenMillis = pRefResult.getDurationMilliSecs();
        long nRepetitions = pTestMethod.getRepetitions();
        long nThreads = testResults.length;
        long totalDurationMs = pTestMethod.getTotalDuration();
        long maxDurationMs = pTestMethod.getMaxMillis();
        long gcTestMicros = 1000L * pGcTestMillis;
        long gcRefMicros = 1000L * pGcRefMillis;
        boolean totalSuccess = true;
        String logText = "";
        JverLogPerf.println(this.getMessageExecution(fullName, nRepetitions, nThreads));
        JverLogPerf.println("burden total:      \t " + this.formatMilliSeconds(burdenMillis));
        JverLogPerf.println("duration per single step(repetition):");
        PerfThreadStats stats = new PerfThreadStats();
        long sumTestMillis = 0L;
        int jj = 0;
        while (jj < testResults.length) {
            this.checkThreadPerformance(stats, testResults[jj], jj, nRepetitions, burdenMillis, maxDurationMs);
            sumTestMillis += testResults[jj].getDurationMilliSeconds();
            ++jj;
        }
        long avgTestMillis = sumTestMillis / (long)testResults.length;
        JverLogPerf.println("Summary:");
        JverLogPerf.println("avg. thread:\t\t " + this.formatMilliSeconds(avgTestMillis));
        if (0L <= totalDurationMs) {
            JverLogPerf.println("monitor thread:\t\t " + this.formatMilliSeconds(totalDurationMs));
        } else {
            JverLogPerf.println("monitor thread:\t\t not available");
        }
        if (this.config_.isDoShowTimesGC()) {
            JverLogPerf.println("tgc:" + this.formatMicroSeconds(gcTestMicros) + ",bgc:" + this.formatMicroSeconds(gcRefMicros));
        }
        if (0 != stats.cntTooLong) {
            logText = fullNameBrackets + " max.duration exceeded: in " + stats.cntTooLong + " threads.";
            JverLogPerf.println(logText);
            this.performanceWarning(logText, "perf.lim.exceed");
            totalSuccess = false;
        }
        if (0 != stats.cntError) {
            String xptTxt = fullNameBrackets + " runtime problems in " + stats.cntError + " threads.";
            JverLogPerf.println(xptTxt);
            this.performanceWarning(xptTxt, "perf.thread.err");
            totalSuccess = false;
        }
        this.msgCollector_.announceTestEnd(totalSuccess);
        int kk = 0;
        while (kk < testResults.length) {
            PerfResultMT curResult = testResults[kk];
            if (null != curResult.fXpt) {
                JverLogPerf.println("thread( " + kk + ") " + curResult.fXpt.toString());
                if (curResult.fXpt instanceof JverFlopException) {
                    this.msgCollector_.addFlop((JverFlopException)curResult.fXpt);
                } else if (curResult.fXpt instanceof JverProcessException) {
                    this.msgCollector_.addWarning((JverProcessException)curResult.fXpt);
                } else {
                    this.performanceWarning(curResult.fXpt.toString(), "perf.thread.err");
                }
            }
            ++kk;
        }
        return totalSuccess;
    }

    private String getMessageExecution(String fullName, long nRepetitions, long nThreads) {
        String sRepetitions = Integer.toString((int)nRepetitions);
        String sThreads = Integer.toString((int)nThreads);
        int msgLen = fullName.length() + sRepetitions.length() + sThreads.length() + 40;
        StringBuffer buffer = new StringBuffer(msgLen);
        buffer.append(fullName);
        buffer.append(": executed (");
        buffer.append(sRepetitions);
        buffer.append(") times in ( ");
        buffer.append(sThreads);
        buffer.append(") threads.");
        return buffer.toString();
    }

    private void checkThreadPerformance(PerfThreadStats stats, PerfResultMT curResult, int iThread, long nRepetitions, long burdenMillis, long maxDurationMs) {
        PerfExecStateMT curState = curResult.fState;
        if (curState.isSuccessfull()) {
            long invokeMicros;
            long curTestMillis = curResult.getDurationMilliSeconds();
            long maxMicros = maxDurationMs * 1000L;
            try {
                double invokeMillis = (double)(curTestMillis - burdenMillis) / (double)nRepetitions;
                invokeMicros = (long)(invokeMillis * 1000.0);
            }
            catch (ArithmeticException e1) {
                invokeMicros = maxMicros + 1L;
            }
            if (invokeMicros > maxMicros) {
                JverLogPerf.println("thread[" + iThread + "] invocation\t\t too long");
                ++stats.cntTooLong;
            } else {
                JverLogPerf.println("thread[" + iThread + "] invocation\t " + this.formatMicroSeconds(invokeMicros));
            }
        } else {
            JverLogPerf.println("thread[" + iThread + "]\t\t" + curState.getDescription());
            if (curState.isTimeout()) {
                ++stats.cntTooLong;
            }
            if (curState.isError()) {
                ++stats.cntError;
            }
        }
    }

    private PerfResultMT[] execute(PerfTestDescription pMethData, PerfTestThreadMT[] pExecArray, long pXtraWaitMT) throws InterruptedException {
        pMethData.setTotalDuration(0L);
        long repetitions = pMethData.getRepetitions();
        int numThreads = pMethData.getNumThreads();
        long startMillis = System.currentTimeMillis();
        long maxMillis = pMethData.getMaxMillis();
        boolean allDone = false;
        long expectedEnd = 0L;
        long multiFactor = 1L + (long)Math.log(numThreads);
        Thread[] threadArray = new Thread[numThreads];
        PerfResultMT[] resultArray = new PerfResultMT[numThreads];
        ThreadGroup tg = new ThreadGroup("JVER-THG-" + this.fgThgCnt++);
        int ii = 0;
        while (ii < numThreads) {
            resultArray[ii] = pExecArray[ii].getResult();
            threadArray[ii] = new Thread(tg, pExecArray[ii], tg.getName() + "-THR-" + ii);
            ++ii;
        }
        tg.setDaemon(true);
        startMillis = System.currentTimeMillis();
        expectedEnd = startMillis + maxMillis * repetitions * multiFactor + pXtraWaitMT;
        try {
            int ii2;
            int ii3 = 0;
            while (ii3 < numThreads) {
                threadArray[ii3].start();
                ++ii3;
            }
            allDone = false;
            while (System.currentTimeMillis() < expectedEnd && !allDone) {
                Thread.sleep(100L);
                allDone = true;
                ii2 = 0;
                while (ii2 < numThreads) {
                    allDone = allDone && !threadArray[ii2].isAlive();
                    ++ii2;
                }
            }
            pMethData.setTotalDuration(System.currentTimeMillis() - startMillis);
            if (!allDone) {
                ii2 = 0;
                while (ii2 < numThreads) {
                    if (threadArray[ii2].isAlive()) {
                        pExecArray[ii2].requestCancel();
                    }
                    ++ii2;
                }
                Thread.sleep(100L);
                allDone = true;
                int ii4 = 0;
                while (ii4 < numThreads) {
                    allDone = allDone && !threadArray[ii4].isAlive();
                    ++ii4;
                }
            }
            if (!allDone) {
                boolean oneAlive = true;
                int hh = 0;
                while (hh < 10 && oneAlive) {
                    Thread.sleep(100L);
                    oneAlive = false;
                    int ii5 = 0;
                    while (ii5 < numThreads) {
                        if (threadArray[ii5].isAlive()) {
                            oneAlive = true;
                            threadArray[ii5].interrupt();
                        }
                        ++ii5;
                    }
                    ++hh;
                }
                boolean bl = allDone = !oneAlive;
            }
            if (!allDone) {
                ii2 = 0;
                while (ii2 < numThreads) {
                    if (threadArray[ii2].isAlive()) {
                        resultArray[ii2] = resultArray[ii2].cloneThis();
                        resultArray[ii2].fState = PerfExecStateMT.STATE_XPT_SWALLOWED;
                        int jj = 0;
                        while (jj < 10) {
                            threadArray[jj].interrupt();
                            ++jj;
                        }
                    }
                    ++ii2;
                }
            }
            threadArray = null;
            tg = null;
            PerfResultMT[] perfResultMTArray = resultArray;
            Object var26_20 = null;
            if (null != tg && 0 != tg.activeCount()) {
                tg.interrupt();
            }
            return perfResultMTArray;
        }
        catch (Throwable throwable) {
            block19: {
                Object var26_21 = null;
                if (null == tg || 0 == tg.activeCount()) break block19;
                tg.interrupt();
            }
            throw throwable;
        }
    }

    protected IJverFixture getPerfTestFixture(IJverFixture fixture) {
        IJverFixture clone = fixture.getClone();
        PerfMsgCollectorMT perfMsgCollector = PerfMsgCollectorMT.newInstance(true);
        clone.setMsgCollector(perfMsgCollector);
        return fixture;
    }

    private class PerfThreadStats {
        int cntTooLong = 0;
        int cntError = 0;

        PerfThreadStats() {
        }
    }
}

