/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

import com.sap.tc.jtools.jver.core.IJverException;
import com.sap.tc.jtools.jver.core.IJverListener;
import com.sap.tc.jtools.jver.core.IJverMsgContents;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverFlopException;
import com.sap.tc.jtools.jver.core.JverLogPerf;
import com.sap.tc.jtools.jver.core.JverPerformanceException;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.driver.JverListenerSilent;
import com.sap.tc.jtools.jver.driver.performance.PerfFlopBreakException;
import com.sap.tc.jtools.jver.driver.performance.PerfWarningBreakException;
import java.util.Enumeration;
import java.util.Vector;

class PerfMsgCollectorMT
extends JverListenerSilent
implements IMsgCollector {
    private Vector fFlops = null;
    private Vector fWarnings = null;
    int fVeriCount = 0;
    int fTestCount = 0;

    public void add(IJverException pException) {
        if (pException instanceof JverFlopException) {
            this.addFlop((JverFlopException)pException);
        } else if (pException instanceof JverProcessException) {
            this.addWarning((JverProcessException)pException);
        }
    }

    public void addFlop(JverFlopException pFlop) {
        if (null != pFlop) {
            if (null == this.fFlops) {
                this.fFlops = new Vector(5, 5);
            }
            this.fFlops.add(pFlop);
        }
        throw new PerfFlopBreakException(pFlop);
    }

    public void addWarning(JverProcessException pWarning) {
        if (null != pWarning) {
            if (null == this.fWarnings) {
                this.fWarnings = new Vector(5, 5);
            }
            this.fWarnings.add(pWarning);
            throw new PerfWarningBreakException(pWarning);
        }
    }

    public void addExceed(JverPerformanceException pExceed) {
    }

    public void addInfo(String pInfo) {
        if (null == pInfo) {
            // empty if block
        }
    }

    public void incVeriCount() {
        ++this.fVeriCount;
    }

    public int getVeriCount() {
        return this.fVeriCount;
    }

    public void incTestCount() {
        ++this.fTestCount;
    }

    public int getTestCount() {
        return this.fTestCount;
    }

    public String logInit(String logFileName, boolean append) {
        this.logln("Log Init Request: " + logFileName);
        return logFileName;
    }

    public synchronized void log(String pMessageText) {
        JverLogPerf.print(pMessageText);
    }

    public synchronized void logln(String pMessageText) {
        JverLogPerf.println(pMessageText);
    }

    public synchronized void logStackTrace(Throwable e) {
        JverLogPerf.printStackTrace(e);
    }

    public void logFinish() {
        JverLogPerf.finish();
    }

    protected void resetState() {
        this.fFlops = null;
        this.fWarnings = null;
    }

    public int getFlopCount() {
        int count = this.fFlops.size();
        return count;
    }

    public int getTolerantFlopCount() {
        return 0;
    }

    public IJverMsgContents getFlop(int ndxFlop) {
        if (null == this.fFlops) {
            return null;
        }
        if (0 <= ndxFlop && this.fFlops.size() > ndxFlop) {
            JverFlopException e = (JverFlopException)this.fFlops.elementAt(ndxFlop);
            return e.getContents();
        }
        return null;
    }

    public int getWarningCount() {
        return this.fWarnings.size();
    }

    public IJverMsgContents getWarning(int ndxWarning) {
        if (null == this.fWarnings) {
            return null;
        }
        if (0 <= ndxWarning && this.fWarnings.size() > ndxWarning) {
            return ((JverProcessException)this.fWarnings.elementAt(ndxWarning)).getContents();
        }
        return null;
    }

    static PerfMsgCollectorMT newInstance(boolean doSynchronize) {
        if (doSynchronize) {
            return new PerfMsgCollectorMT(){

                public void addFlop(JverFlopException newFlop) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        super.addFlop(newFlop);
                    }
                }

                public void addWarning(JverProcessException newWarning) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        super.addWarning(newWarning);
                    }
                }
            };
        }
        return new PerfMsgCollectorMT();
    }

    private PerfMsgCollectorMT() {
    }

    public boolean hasListener() {
        return false;
    }

    public void setListener(IJverListener listener) {
        throw new UnsupportedOperationException("Method 'setListener' not supported by PerfMsgCollectorMT.");
    }

    public void setListeners(IJverListener[] listener) {
        throw new UnsupportedOperationException("Method 'setListeners' not supported by PerfMsgCollectorMT.");
    }

    public IJverMsgContents getExceed(int ii) {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }

    public int getExceedCount() {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }

    public String getInfo(int index) {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }

    public int getInfoCount() {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }

    public Enumeration getExceeds() {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }

    public Enumeration getFlops() {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }

    public Enumeration getWarnings() {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }

    public String getSummary() {
        throw new UnsupportedOperationException("Method not supported by PerfMsgCollectorMT.");
    }
}

