/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver.performance;

import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.core.JverLogPerf;

public final class PerfConfig {
    private int fGcSleepAfter = 0;
    private int fnRelTestBurden = 10;
    private long fMtXtraTimeout = 1000L;
    private String fsRelTestBurden = new Integer(this.fnRelTestBurden).toString();
    private boolean fDoShowTimesGC = false;
    private boolean fSkipFunctional = false;

    public void init(JverConfig config) {
        String keySkipFunctional = "perf.skip.functional.test";
        String keyGcSleepAfter = "perf.gc.sleep.after";
        String keyRelTestBurden = "perf.rel.test.burden";
        String keyShowTimesGC = "perf.gc.show.times";
        String keyMtXtraWait = "perf.mt.xtra.wait";
        this.fSkipFunctional = config.getBooleanValue("perf.skip.functional.test", false);
        this.fGcSleepAfter = config.getIntegerValue("perf.gc.sleep.after", 0);
        this.fnRelTestBurden = config.getIntegerValue("perf.rel.test.burden", 20);
        this.fsRelTestBurden = String.valueOf(this.fnRelTestBurden);
        this.fDoShowTimesGC = config.getBooleanValue("perf.gc.show.times", false);
        this.fMtXtraTimeout = config.getIntegerValue("perf.mt.xtra.wait", 1000);
        JverLogPerf.printHeader("Performance Configuration:", '-');
        JverLogPerf.println("perf.skip.functional.test: " + this.fSkipFunctional);
        JverLogPerf.println("perf.rel.test.burden: " + this.fsRelTestBurden);
        JverLogPerf.println("perf.gc.sleep.after: " + this.fGcSleepAfter);
        JverLogPerf.println("perf.gc.show.times: " + this.fDoShowTimesGC);
        JverLogPerf.println("perf.mt.xtra.wait: " + this.fMtXtraTimeout);
        JverLogPerf.println("");
    }

    public boolean isDoShowTimesGC() {
        return this.fDoShowTimesGC;
    }

    public int getGcSleepAfter() {
        return this.fGcSleepAfter;
    }

    public long getMtXtraTimeout() {
        return this.fMtXtraTimeout;
    }

    public int getRelTestBurden() {
        return this.fnRelTestBurden;
    }

    public String getRelTestBurdenAsString() {
        return this.fsRelTestBurden;
    }

    public boolean isSkipFunctional() {
        return this.fSkipFunctional;
    }
}

