/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IJverException;
import com.sap.tc.jtools.jver.core.IJverTestAttributesInternal;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.driver.AJverMethodRunner;
import com.sap.tc.jtools.jver.driver.IJverDriverMsg;
import com.sap.tc.jtools.jver.driver.IJverDriverState;
import com.sap.tc.jtools.jver.driver.JverMethodRunnerPerformance;
import com.sap.tc.jtools.jver.driver.JverMethodRunnerStd;
import com.sap.tc.jtools.jver.framework.TestAttributes;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class JverTestClassRunner {
    private IMsgCollector msgCollector_ = null;
    private final IJverDriverState driverState_;
    private static final Class[] noArg_ = new Class[0];
    private boolean bPerformanceTest_ = false;
    private AJverMethodRunner stdMethodRunner_ = null;
    private AJverMethodRunner performanceMethodRunner_ = null;
    static /* synthetic */ Class class$com$sap$tc$jtools$jver$framework$IJverTestAttributes;

    protected JverTestClassRunner(IMsgCollector msgCollector, IJverDriverState state) {
        this.msgCollector_ = msgCollector;
        this.driverState_ = state;
    }

    protected boolean isPerformanceTest() {
        return this.bPerformanceTest_;
    }

    protected void setPerformanceTest(boolean val) {
        this.bPerformanceTest_ = val;
    }

    protected void runTestClass(Class clazz, IJverTestAttributesInternal attributes, JverConfig config) {
        boolean doPerformanceTest;
        String className = clazz.getName();
        DbgLog.println("");
        DbgLog.print("========== run test class: ");
        DbgLog.print(className);
        DbgLog.println(" ==========");
        AJverMethodRunner funcRunner = null;
        boolean doFunctionalTest = true;
        boolean isFunctionalTestOK = false;
        AJverMethodRunner perfRunner = null;
        boolean bl = doPerformanceTest = this.isPerformanceTest() && attributes.hasPerformanceTestSet();
        if (doPerformanceTest) {
            perfRunner = this.getPerformanceMethodRunner(config);
            perfRunner.init(clazz, attributes);
            boolean bl2 = doFunctionalTest = !((JverMethodRunnerPerformance)perfRunner).getSkipFunctional();
        }
        if (doFunctionalTest) {
            funcRunner = this.getStdMethodRunner();
            funcRunner.init(clazz, attributes);
            this.runConcreteTestClass(funcRunner);
            isFunctionalTestOK = funcRunner.isSuccessfull();
        }
        if (doPerformanceTest) {
            if (doFunctionalTest && !isFunctionalTestOK) {
                IJverDriverMsg.SKIP_PERFORMANCE_TEST.add(this.msgCollector_, className);
            } else {
                this.runConcreteTestClass(perfRunner);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IJverTestAttributesInternal readTestAttributes(Class clazz) throws JverProcessException {
        IJverTestAttributesInternal attributes = null;
        try {
            try {
                try {
                    attributes = this.readCreatedTestAttributes(clazz);
                }
                catch (NoSuchMethodException e) {
                    attributes = new TestAttributes();
                    this.readAdjustedTestAttributes(clazz, attributes);
                }
                Object var10_5 = null;
                if (attributes != null) return attributes;
                throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
            }
            catch (NoSuchMethodException e1) {
                DbgLog.println(clazz.getName() + ": no explicite attributes specified, using default!");
                Object var10_6 = null;
                if (attributes != null) return attributes;
                throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
            }
            catch (IllegalArgumentException e) {
                IJverDriverMsg.METHOD_SIGNATURE.add(this.msgCollector_, e);
                Object var10_7 = null;
                if (attributes != null) return attributes;
                throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
            }
            catch (IllegalAccessException e) {
                IJverDriverMsg.METHOD_NOT_PUBLIC.add(this.msgCollector_, e.getLocalizedMessage());
                Object var10_8 = null;
                if (attributes != null) return attributes;
                throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
            }
            catch (InvocationTargetException e) {
                IJverDriverMsg.ATTRIBUTES_EXCEPTION.add(this.msgCollector_, e.getTargetException(), clazz.getName());
                Object var10_9 = null;
                if (attributes != null) return attributes;
                throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
            }
            catch (ExceptionInInitializerError e) {
                IJverDriverMsg.STATIC_INIT_ERROR.add(this.msgCollector_, e, clazz.getName());
                Object var10_10 = null;
                if (attributes != null) return attributes;
                throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
            }
            catch (Throwable e) {
                IJverDriverMsg.UNEXPECTED_ERROR.add(this.msgCollector_, e.toString());
                Object var10_11 = null;
                if (attributes != null) return attributes;
                throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (attributes != null) throw throwable;
            throw new JverProcessException(IJverDriverMsg.NO_ATTRIBUTES_ERROR, (Object)clazz.getName());
        }
    }

    private IJverTestAttributesInternal readCreatedTestAttributes(Class clazz) throws InvocationTargetException, NoSuchMethodException, NoSuchMethodException, IllegalAccessException {
        Method method = null;
        TestAttributes attributes = null;
        try {
            method = clazz.getMethod("createTestAttributes", noArg_);
        }
        catch (NoSuchMethodException e0) {
            method = clazz.getMethod("getAttributes", noArg_);
            DbgLog.println(IJverDriverMsg.DEPRECATED_GETATTRIBUTES.getMessage());
        }
        if (this.assertStaticAttributeMethod(method)) {
            attributes = (TestAttributes)method.invoke(null, (Object[])noArg_);
        }
        return attributes;
    }

    private void readAdjustedTestAttributes(Class clazz, IJverTestAttributesInternal attributes) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class[] argTypes = new Class[]{class$com$sap$tc$jtools$jver$framework$IJverTestAttributes == null ? (class$com$sap$tc$jtools$jver$framework$IJverTestAttributes = JverTestClassRunner.class$("com.sap.tc.jtools.jver.framework.IJverTestAttributes")) : class$com$sap$tc$jtools$jver$framework$IJverTestAttributes};
        Method method = clazz.getMethod("adjustTestAttributes", argTypes);
        if (this.assertStaticAttributeMethod(method)) {
            method.invoke(null, attributes);
        }
    }

    private boolean assertStaticAttributeMethod(Method method) {
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        if (!isStatic) {
            IJverDriverMsg.ATTRIB_NOT_STATIC.add(this.msgCollector_);
        }
        return isStatic;
    }

    private void runConcreteTestClass(AJverMethodRunner runner) {
        try {
            this.msgCollector_.announceTestsetStart(runner);
            runner.runTestMethods();
        }
        catch (JverProcessException e) {
            this.msgCollector_.addWarning(e);
        }
        catch (NoSuchMethodException e) {
            IJverDriverMsg.MISSING_FIXTURE.add(this.msgCollector_, e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable eTarget = e.getTargetException();
            if (eTarget instanceof IJverException) {
                IJverException jverException = (IJverException)((Object)eTarget);
                if (jverException.getLevel() != 3) {
                    IJverDriverMsg.NON_FATAL_AT_CLASS_LEVEL.add(this.msgCollector_, jverException.toString());
                } else if (!jverException.isHandled()) {
                    this.msgCollector_.add(jverException);
                }
            } else {
                IJverDriverMsg.UNEXPECTED_ERROR.add(this.msgCollector_, eTarget.toString());
            }
        }
        catch (ClassCastException e) {
            IJverDriverMsg.CLASS_MISMATCH.add(this.msgCollector_, e.toString());
        }
        catch (ExceptionInInitializerError e) {
            IJverDriverMsg.STATIC_INIT_ERROR.add(this.msgCollector_, e, runner.getTestClass().getName());
        }
        catch (Throwable e) {
            DbgLog.println(IJverDriverMsg.FIXTURE_EXCEPTION.getMessage());
            DbgLog.printStackTrace(e);
            IJverDriverMsg.FIXTURE_EXCEPTION.add(this.msgCollector_, e);
        }
    }

    private AJverMethodRunner getStdMethodRunner() {
        if (this.stdMethodRunner_ == null) {
            this.stdMethodRunner_ = new JverMethodRunnerStd(this.msgCollector_, this.driverState_);
        }
        return this.stdMethodRunner_;
    }

    private AJverMethodRunner getPerformanceMethodRunner(JverConfig config) {
        if (this.performanceMethodRunner_ == null) {
            this.performanceMethodRunner_ = new JverMethodRunnerPerformance(this.msgCollector_, config, this.driverState_);
        }
        return this.performanceMethodRunner_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

