/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.IJverMsgContents;
import com.sap.tc.jtools.jver.core.IJverMsgFmt;
import com.sap.tc.jtools.jver.core.IJverPrinter;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverMsgFmtXml;
import com.sap.tc.jtools.jver.core.JverPrinter;
import com.sap.tc.jtools.jver.driver.AJverListener;

public class JverListenerXml
extends AJverListener
implements IJverMsgFmt {
    protected JverMsgFmtXml formatter;
    protected IJverPrinter printer_ = null;

    public JverListenerXml() {
        this(new JverPrinter(System.out));
    }

    public JverListenerXml(IJverPrinter printer) {
        this.printer_ = printer;
        this.formatter = new JverMsgFmtXml();
    }

    public void announceFlop(IJverMsgContents flop) {
        this.printer_.println(this.formatter.formatContents(flop, this.getAdditionalStackFilter()));
    }

    public void announcePerformanceFlop(IJverMsgContents perfFlop) {
        this.printer_.println(this.formatter.formatContents(perfFlop, this.getAdditionalStackFilter()));
    }

    public void announceWarning(IJverMsgContents warning) {
        this.printer_.println(this.formatter.formatContents(warning, this.getAdditionalStackFilter()));
    }

    public void announceTestTaskStart(int nTestTargets) {
        this.formatter.printTaskOpeningTag(this.printer_, nTestTargets);
    }

    public void announceTestTaskEnd(IMsgCollector msgCollector) {
        this.formatter.printInfos(this.printer_, msgCollector);
        this.formatter.printSummary(this.printer_, msgCollector);
        this.formatter.printTaskClosingTag(this.printer_);
    }
}

