/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverConfig;
import com.sap.tc.jtools.jver.driver.IJverDriverMsg;
import com.sap.tc.jtools.jver.scanner.IJverClassLoader;
import com.sap.tc.jtools.jver.scanner.IScanner;
import com.sap.tc.jtools.jver.scanner.JverTargetVector;
import com.sap.tc.jtools.jver.scanner.ScannerByPackage;
import com.sap.tc.jtools.jver.scanner.ScannerFixTestSet;
import java.util.Enumeration;

class JverClassManager
implements IScanner {
    private IScanner scanner = null;
    private IMsgCollector msgCollector_ = null;
    private IJverClassLoader jverClassLoader_ = null;

    public void createScanner(boolean isFixTestSet, boolean isAltScanner, String altScannerName) {
        if (isFixTestSet) {
            DbgLog.println("Scan: call given test classes directly");
            this.setScanner(new ScannerFixTestSet());
        } else if (isAltScanner) {
            DbgLog.println("Scan: use alternative Scanner: " + altScannerName);
            this.setScanner(altScannerName);
        } else {
            DbgLog.println("Scan: use default scanner");
            this.setDefaultScanner();
        }
        this.scanner.init(this.jverClassLoader_, this.msgCollector_);
    }

    private void setDefaultScanner() {
        this.setScanner(new ScannerByPackage());
    }

    private void setScanner(String altScannerName) {
        try {
            Class<?> scannerClass = Class.forName(altScannerName);
            IScanner IScanner2 = (IScanner)scannerClass.newInstance();
            this.setScanner(IScanner2);
        }
        catch (Exception e) {
            IJverDriverMsg.DEFAULT_SCANNER.add(this.msgCollector_, e.toString());
            this.setDefaultScanner();
        }
    }

    public void init(IJverClassLoader loader, IMsgCollector msgCollector) {
        this.msgCollector_ = msgCollector;
        this.jverClassLoader_ = loader;
    }

    public void setTargets(JverConfig config, JverTargetVector testClasses, String path) {
        if (this.scanner == null) {
            this.createScanner(false, false, "");
        }
        this.scanner.setTargets(config, testClasses, path);
    }

    public Enumeration elements() {
        return this.scanner.elements();
    }

    public IScanner getScanner() {
        return this.scanner;
    }

    public void setScanner(IScanner scanner) {
        this.scanner = scanner;
    }
}

