/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.driver;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IJverException;
import com.sap.tc.jtools.jver.core.IJverListener;
import com.sap.tc.jtools.jver.core.IJverMsgContents;
import com.sap.tc.jtools.jver.core.IJverMsgFmt;
import com.sap.tc.jtools.jver.core.IJverRunnerSettings;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverFlopException;
import com.sap.tc.jtools.jver.core.JverPerformanceException;
import com.sap.tc.jtools.jver.core.JverPrinter;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.core.JverRuntimeException;
import com.sap.tc.jtools.jver.driver.AJverListenerResultOutput;
import com.sap.tc.jtools.jver.driver.IJverDriverMsg;
import com.sap.tc.jtools.jver.driver.JverListenerSilent;
import com.sap.tc.jtools.jver.driver.JverUserLog;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;

public abstract class AJverMsgCollector
implements IMsgCollector,
IJverListener,
IJverMsgFmt {
    private IJverListener[] listeners_ = null;
    int veriCount_;
    int testCount_;
    private int countWarningsWithoutListener_ = 0;
    private int countTolerantFlops_ = 0;
    private JverUserLog log_ = null;
    private static final String defaultSummary = "Ready: {0} verification{0, choice, 0#s| 1#| 2#s} in {1} test{1, choice, 0#s| 1#| 2#s}: {2} failed, {3} warning{3, choice, 0#s.| 1#.| 2#s.}";
    private static final MessageFormat resultFormatStd = new MessageFormat("Ready: {0} verification{0, choice, 0#s| 1#| 2#s} in {1} test{1, choice, 0#s| 1#| 2#s}: {2} failed, {3} warning{3, choice, 0#s.| 1#.| 2#s.}");

    public void setListener(IJverListener listener) {
        this.listeners_ = new IJverListener[]{listener};
    }

    public void setListeners(IJverListener[] listeners) {
        this.listeners_ = listeners;
    }

    public boolean hasListener() {
        return this.listeners_ != null;
    }

    public int getTestCount() {
        return this.testCount_;
    }

    public void incTestCount() {
        ++this.testCount_;
    }

    public int getVeriCount() {
        return this.veriCount_;
    }

    public void incVeriCount() {
        ++this.veriCount_;
    }

    public void addWarning(JverProcessException e) {
        IJverMsgContents contents = e.getContents();
        this.announceWarning(contents);
        DbgLog.println(contents.toString());
        this.collectWarning(contents);
    }

    protected abstract void collectWarning(IJverMsgContents var1);

    public abstract int getWarningCount();

    public abstract IJverMsgContents getWarning(int var1);

    public abstract Enumeration getWarnings();

    public void addFlop(JverFlopException e) {
        e.setHandled(true);
        IJverMsgContents contents = e.getContents();
        if (contents.getLevel() == 1) {
            ++this.countTolerantFlops_;
        }
        this.announceFlop(contents);
        this.collectFlop(contents);
    }

    protected abstract void collectFlop(IJverMsgContents var1);

    public abstract int getFlopCount();

    public abstract IJverMsgContents getFlop(int var1);

    public abstract Enumeration getFlops();

    public void addExceed(JverPerformanceException e) {
        IJverMsgContents contents = e.getContents();
        this.announcePerformanceFlop(contents);
        this.collectExceeds(contents);
    }

    protected abstract void collectExceeds(IJverMsgContents var1);

    public abstract int getExceedCount();

    public abstract IJverMsgContents getExceed(int var1);

    public abstract Enumeration getExceeds();

    public void add(IJverException e) {
        if (e instanceof JverFlopException) {
            this.addFlop((JverFlopException)e);
        } else if (e instanceof JverProcessException) {
            this.addWarning((JverProcessException)e);
        } else if (e instanceof JverPerformanceException) {
            this.addExceed((JverPerformanceException)e);
        } else if (e instanceof JverRuntimeException) {
            this.addWarning(new JverProcessException(e.getContents()));
        }
    }

    public void addInfo(String txt) {
        this.collectInfo(txt);
    }

    protected abstract void collectInfo(String var1);

    public abstract int getInfoCount();

    public abstract String getInfo(int var1);

    public void announceTestTaskStart(int nTestSet) {
        int ii;
        if (this.listeners_ == null) {
            IJverDriverMsg.MISSING_LISTENER.add(this);
            this.listeners_ = new IJverListener[]{new JverListenerSilent()};
        }
        if (this.countWarningsWithoutListener_ > 0) {
            ii = 0;
            while (ii < this.countWarningsWithoutListener_) {
                this.announceWarning(this.getWarning(ii));
                ++ii;
            }
        }
        ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceTestTaskStart(nTestSet);
            ++ii;
        }
    }

    public void announceTestsetStart(String className) {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceTestsetStart(className);
            ++ii;
        }
    }

    public void announceTestsetStart(IJverRunnerSettings runnerSettings) {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceTestsetStart(runnerSettings);
            ++ii;
        }
    }

    public void announceTestTaskEnd(IMsgCollector msgCollector) {
        if (this.listeners_ != null) {
            int ii = 0;
            while (ii < this.listeners_.length) {
                this.listeners_[ii].announceTestTaskEnd(msgCollector);
                ++ii;
            }
        } else {
            JverPrinter sysErr = new JverPrinter(System.err);
            new AJverListenerResultOutput(sysErr){}.announceTestTaskEnd(msgCollector);
        }
    }

    public void announceTestsetEnd() {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceTestsetEnd();
            ++ii;
        }
    }

    public void announceTestStart(String methodName) {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceTestStart(methodName);
            ++ii;
        }
    }

    public void announceWarning(IJverMsgContents contents) {
        if (this.listeners_ == null) {
            ++this.countWarningsWithoutListener_;
        } else {
            int ii = 0;
            while (ii < this.listeners_.length) {
                this.listeners_[ii].announceWarning(contents);
                ++ii;
            }
        }
    }

    public void announceFlop(IJverMsgContents contents) {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceFlop(contents);
            ++ii;
        }
    }

    public void announcePerformanceFlop(IJverMsgContents contents) {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announcePerformanceFlop(contents);
            ++ii;
        }
    }

    public void announceTestEnd(boolean ok) {
        this.incTestCount();
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceTestEnd(ok);
            ++ii;
        }
    }

    public void announceTestSkip(String methodName) {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].announceTestSkip(methodName);
            ++ii;
        }
    }

    public void internalMessage(String msg) {
        int ii = 0;
        while (ii < this.listeners_.length) {
            this.listeners_[ii].internalMessage(msg);
            ++ii;
        }
    }

    public void setAdditionalStackFilter(String[] strings) {
    }

    public String logInit(String logFileName, boolean append) {
        String fileName = null;
        try {
            this.logFinish();
            this.log_ = new JverUserLog(logFileName, append);
            fileName = this.log_.getLogFileName();
            this.addInfo("User Logging written to: " + fileName);
        }
        catch (IOException ioe) {
            IJverDriverMsg.USER_LOGFILE_EXCEPTION.add((IMsgCollector)this, ioe);
        }
        return fileName;
    }

    public void log(String msg) {
        if (this.log_ != null) {
            this.log_.print(msg);
        }
    }

    public void logln(String msg) {
        if (this.log_ != null) {
            this.log_.println(msg);
        }
    }

    public void logStackTrace(Throwable e) {
        if (this.log_ != null) {
            this.log_.printStackTrace(e);
        }
    }

    public void logFinish() {
        if (this.log_ != null) {
            this.log_.finish();
            this.log_ = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.logFinish();
    }

    public String getSummary() {
        String summary = resultFormatStd.format(new Object[]{new Integer(this.getVeriCount()), new Integer(this.getTestCount()), new Integer(this.getFlopCount() + this.getExceedCount()), new Integer(this.getWarningCount())});
        return summary;
    }

    public int getTolerantFlopCount() {
        return this.countTolerantFlops_;
    }
}

