/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.IJverCoreMsg;
import com.sap.tc.jtools.jver.core.JverRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JverTestParameters {
    private Properties properties_ = null;

    public void defineParameters(String[] input) {
        if (this.properties_ == null) {
            int numberPair = input.length;
            int numberChar = 0;
            int ii = 0;
            while (ii < numberPair) {
                numberChar += input[ii].length();
                ++ii;
            }
            StringBuffer buffer = new StringBuffer(numberChar + numberPair);
            int ii2 = 0;
            while (ii2 < numberPair) {
                buffer.append(input[ii2]);
                buffer.append('\n');
                ++ii2;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(buffer.toString().getBytes());
            this.properties_ = new Properties();
            try {
                this.properties_.load(in);
            }
            catch (IOException e) {
                throw new JverRuntimeException("defineParameters: wrong format");
            }
        } else {
            throw new JverRuntimeException("Parameters must not be redefined!");
        }
    }

    public boolean redefineParameter(String key, String value) {
        if (this.properties_ != null && ((Hashtable)this.properties_).containsKey(key)) {
            this.properties_.setProperty(key, value);
            return true;
        }
        return false;
    }

    public void loadParametersFromFile(File propertyFile) throws FileNotFoundException, IOException, JverRuntimeException {
        InputStream in = null;
        this.checkParameterDefinition();
        String propertyFileName = propertyFile.getPath();
        if (propertyFile == null) {
            throw new JverRuntimeException("Parameter file must not be null!");
        }
        if (propertyFileName.startsWith("jar:file:")) {
            int pling = propertyFileName.indexOf("!");
            String jarName = propertyFileName.substring(10, pling);
            String entryName = propertyFileName.substring(pling + 2);
            JarFile jarFile = new JarFile(jarName);
            ZipEntry entry = jarFile.getEntry(entryName = entryName.replace('\\', '/'));
            if (entry == null) {
                throw new FileNotFoundException(propertyFileName + " not found!");
            }
            in = jarFile.getInputStream(entry);
        } else if (propertyFileName.startsWith("file:")) {
            propertyFileName = propertyFileName.substring(5);
            in = new FileInputStream(propertyFileName);
        } else {
            in = new FileInputStream(propertyFileName);
        }
        Properties fileProperties = new Properties();
        fileProperties.load(in);
        this.syncWithDefinedParametersWarnMissing(fileProperties);
    }

    public String[] getParameters() throws JverRuntimeException {
        Properties parameter = this.getProperties();
        Enumeration<?> keys = parameter.propertyNames();
        int len = ((Hashtable)parameter).size();
        String[] array = new String[len];
        int ii = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            array[ii] = key + "=" + parameter.getProperty(key);
            ++ii;
        }
        return array;
    }

    public Enumeration getParameterNames() {
        return this.getProperties().propertyNames();
    }

    public String getParameter(String key) throws JverRuntimeException {
        String value = this.getProperties().getProperty(key);
        if (value == null) {
            throw new JverRuntimeException(IJverCoreMsg.UNDEFINED_PARAM, key);
        }
        return value;
    }

    public void syncWithDefinedParametersDontWarn(Properties updateProperties) {
        this.syncWithDefinedParameters(updateProperties, false);
    }

    public void syncWithDefinedParametersWarnMissing(Properties updateProperties) {
        this.syncWithDefinedParameters(updateProperties, true);
    }

    private void syncWithDefinedParameters(Properties updateProps, boolean doWarn) {
        String ignored = "";
        Enumeration<?> names = updateProps.propertyNames();
        while (names.hasMoreElements()) {
            String value;
            String key = (String)names.nextElement();
            if (this.redefineParameter(key, value = updateProps.getProperty(key)) || !doWarn) continue;
            ignored = ignored + " " + key;
        }
        if (ignored.length() > 0) {
            throw new JverRuntimeException("Parameters not defined in test attributes: '" + ignored + "'");
        }
    }

    private void checkParameterDefinition() {
        if (this.properties_ == null) {
            throw new JverRuntimeException("no parameters defined in test attributes!");
        }
    }

    private Properties getProperties() throws JverRuntimeException {
        this.checkParameterDefinition();
        return this.properties_;
    }
}

