/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.IJverMsgContents;
import com.sap.tc.jtools.jver.core.IJverMsgFmt;
import com.sap.tc.jtools.jver.core.IJverPrinter;
import com.sap.tc.jtools.jver.core.IMsgCollector;
import com.sap.tc.jtools.jver.core.JverPrinter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;

public class JverMsgFmtStd
implements IJverMsgFmt {
    private MessageFormat messageFormat_ = null;

    public JverMsgFmtStd() {
        this("{1,choice, 1#W| 2#F| 3#P| 4#E}: {2} {3, choice, 0#| 1#[{4}]}{5, choice, 0#| 1#{6}}");
    }

    public JverMsgFmtStd(String formatPattern) {
        this.messageFormat_ = new MessageFormat(formatPattern);
    }

    public String formatContents(IJverMsgContents contents, String[] stackFilter) {
        Object[] object = contents.getObjects(stackFilter);
        String s = this.messageFormat_.format(object);
        return s;
    }

    public void printResult(PrintStream printStream, IMsgCollector collector) {
        this.printResult(new JverPrinter(printStream), collector, null);
    }

    public void printResult(PrintStream printStream, IMsgCollector collector, String[] filter) {
        this.printResult(new JverPrinter(printStream), collector, filter);
    }

    public void printResult(PrintWriter printWriter, IMsgCollector collector) {
        this.printResult(new JverPrinter(printWriter), collector, null);
    }

    public void printResult(PrintWriter printWriter, IMsgCollector collector, String[] filter) {
        this.printResult(new JverPrinter(printWriter), collector, filter);
    }

    public void printResult(IJverPrinter printer, IMsgCollector collector, String[] filter) {
        String message;
        printer.println("");
        int count = collector.getWarningCount();
        int ii = 0;
        while (ii < count) {
            IJverMsgContents contents = collector.getWarning(ii);
            message = this.formatContents(contents, filter);
            printer.println(message);
            ++ii;
        }
        if (count > 0) {
            printer.println("");
        }
        count = collector.getFlopCount();
        ii = 0;
        while (ii < count) {
            message = this.formatContents(collector.getFlop(ii), filter);
            printer.println(message);
            ++ii;
        }
        if (count > 0) {
            printer.println("");
        }
        count = collector.getExceedCount();
        ii = 0;
        while (ii < count) {
            message = this.formatContents(collector.getExceed(ii), filter);
            printer.println(message);
            ++ii;
        }
        if (count > 0) {
            printer.println("");
        }
        int infoCount = collector.getInfoCount();
        ii = 0;
        while (ii < infoCount) {
            printer.print("JverInfo: ");
            printer.println(collector.getInfo(ii));
            ++ii;
        }
        if (infoCount > 0) {
            printer.println("");
        }
        printer.println(collector.getSummary());
    }
}

