/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.IJverCoreMsg;
import com.sap.tc.jtools.jver.core.IJverMsgContents;
import com.sap.tc.jtools.jver.core.IJverMsgFmt;
import com.sap.tc.jtools.jver.core.JverExceptionType;
import com.sap.tc.jtools.jver.core.JverMsgDescription;
import com.sap.tc.jtools.jver.core.JverMsgStack;
import com.sap.tc.jtools.jver.core.JverProcessException;
import com.sap.tc.jtools.jver.core.JverRuntimeException;
import java.text.MessageFormat;

public class JverMsgContents
implements IJverMsgContents,
IJverMsgFmt {
    private String message_ = null;
    private String id_ = null;
    private int level_ = 0;
    private JverMsgStack stack_ = null;
    private JverExceptionType type_ = null;

    public JverMsgContents() {
    }

    public JverMsgContents(String message, String id) {
        this.setMessage(message);
        this.setId(id);
        this.setLevel(2);
    }

    public JverMsgContents(String message, String id, int level) throws JverProcessException {
        this.setMessage(message);
        this.setId(id);
        this.setLevelCheck(level);
    }

    public JverMsgContents(JverMsgDescription descr) {
        this.setMessage(descr.getMessage());
        this.setId(descr.getId());
        this.setLevel(2);
    }

    public JverMsgContents(JverMsgDescription descr, Object param) {
        String message = descr.formatMessage(new Object[]{param});
        this.setMessage(message);
        this.setId(descr.getId());
        this.setLevel(2);
    }

    public JverMsgContents(JverMsgDescription descr, Throwable throwable) {
        String message = descr.formatMessage(new Object[]{throwable.toString()});
        this.setMessage(message);
        this.setId(descr.getId());
        this.setLevel(2);
        this.saveFilteredStack(throwable);
    }

    public JverMsgContents(JverMsgDescription descr, Throwable throwable, Object object) {
        String message = descr.formatMessage(new Object[]{throwable.toString(), object});
        this.setMessage(message);
        this.setId(descr.getId());
        this.setLevel(2);
        this.saveFilteredStack(throwable);
    }

    public JverMsgContents(JverMsgDescription descr, Object param1, Object param2) {
        String message = descr.formatMessage(new Object[]{param1, param2});
        this.setMessage(message);
        this.setId(descr.getId());
        this.setLevel(2);
    }

    public JverMsgContents(JverMsgDescription descr, Object[] object) {
        String message = descr.formatMessage(object);
        this.setMessage(message);
        this.setId(descr.getId());
        this.setLevel(2);
    }

    public JverMsgContents(Throwable throwable, int level) throws JverProcessException {
        this.setMessage(throwable.toString());
        this.setId("");
        this.setLevelCheck(level);
        this.saveFilteredStack(throwable);
    }

    public JverMsgContents(Throwable throwable, String msg, String id) {
        msg = this.combineMessages(throwable, msg);
        this.setMessage(msg);
        this.setId(id);
        this.setLevel(2);
        this.saveFilteredStack(throwable);
    }

    public JverMsgContents(Throwable throwable, String msg, String id, int level) throws JverProcessException {
        msg = this.combineMessages(throwable, msg);
        this.setMessage(msg);
        this.setId(id);
        this.setLevelCheck(level);
        this.saveFilteredStack(throwable);
    }

    public JverMsgContents(JverRuntimeException e) {
        this.setMessage(e.getLocalizedMessage());
        this.setId("JVER");
        this.setLevel(2);
        this.saveFilteredStack(e);
    }

    public String toString() {
        Object[] object = this.getObjects(null);
        MessageFormat format = new MessageFormat("{1,choice, 1#W| 2#F| 3#P| 4#E}: {2} {3, choice, 0#| 1#[{4}]}{5, choice, 0#| 1#{6}}");
        return format.format(object);
    }

    public Object[] getObjects(String[] addFilter) {
        Object[] object = new Object[7];
        object[0] = new Integer(this.getLevel());
        object[1] = new Integer(this.getType().getId());
        object[2] = this.getMessage();
        String id = this.getId();
        object[3] = new Integer(id != null && id.length() > 0 ? 1 : 0);
        object[4] = id;
        JverMsgStack filteredStack = addFilter == null ? this.getStack() : new JverMsgStack(addFilter, this.getStack());
        boolean hasStack = filteredStack != null && filteredStack.getLength() > 0;
        object[5] = new Integer(hasStack ? 1 : 0);
        object[6] = filteredStack;
        return object;
    }

    public JverMsgStack getStack() {
        if (null == this.stack_ || 0 == this.stack_.getLength()) {
            return null;
        }
        return this.stack_;
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String id) {
        this.id_ = id;
    }

    public void setLevel(int level) {
        this.level_ = level;
    }

    public void setLevelCheck(int level) throws JverProcessException {
        boolean nok;
        boolean bl = nok = level < 1 || level > 3;
        if (nok) {
            String id = this.id_ == null ? "" : this.id_;
            String msg = this.message_ == null ? "" : this.message_;
            throw new JverProcessException(IJverCoreMsg.LEVEL_OUT_OF_RANGE, new Object[]{Integer.toString(level), msg, id});
        }
        this.setLevel(level);
    }

    public int getLevel() {
        return this.level_;
    }

    public String getMessage() {
        return this.message_;
    }

    public void setMessage(String message) {
        this.message_ = message;
    }

    public void setType(JverExceptionType type) {
        this.type_ = type;
    }

    public JverExceptionType getType() {
        return this.type_;
    }

    public void saveFilteredStack(Throwable throwable) {
        if (this.stack_ == null) {
            this.stack_ = new JverMsgStack(throwable);
        }
    }

    private String combineMessages(Throwable throwable, String msg) {
        String name = throwable.getClass().getName();
        String detail = throwable.getLocalizedMessage();
        msg = msg + " (" + name;
        if (detail != null && detail.length() > 0) {
            msg = msg + ": " + detail;
        }
        msg = msg + ")";
        return msg;
    }

    public String format(String string) {
        Object[] object = this.getObjects(null);
        MessageFormat format = new MessageFormat(string);
        return format.format(object);
    }
}

