/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jver.core;

import com.sap.tc.jtools.jver.core.DbgLog;
import com.sap.tc.jtools.jver.core.IJverCoreMsg;
import com.sap.tc.jtools.jver.core.JverProcessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class JverConfig {
    private static final String SKIP_MYSELF = "com.sap.tc.jtools.jver.";
    private static final String CONFIG_FILE = "JverConfig.properties";
    private static boolean selfTest = false;
    private Vector skipPackages_ = null;
    private Vector suffixArchive_ = null;
    private Properties properties_ = null;

    public void init() throws JverProcessException {
        URL urlConfig = this.getDefaultConfigURL();
        this.init(urlConfig);
    }

    public void init(ClassLoader loader, String configFileName) throws JverProcessException {
        URL urlConfig = configFileName == null || configFileName.length() == 0 ? this.getDefaultConfigURL(loader) : (!configFileName.equals("NONE") ? this.getConfigURL(loader, configFileName) : null);
        this.init(urlConfig);
    }

    public void init(URL urlConfig) throws JverProcessException {
        if (null != urlConfig) {
            try {
                this.readProperties(urlConfig);
                this.initMembers();
            }
            catch (IOException ioe) {
                throw new JverProcessException(IJverCoreMsg.READ_CONFIG_FAILED, (Throwable)ioe);
            }
        } else {
            this.properties_ = new Properties();
            this.initMembers();
        }
    }

    private void readProperties(URL configUrl) throws IOException {
        InputStream is = configUrl.openStream();
        try {
            this.properties_ = new Properties();
            this.properties_.load(is);
            String urlName = configUrl.toExternalForm();
            DbgLog.println("Properties loaded from '" + urlName + "'");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }

    private URL getDefaultConfigURL() throws JverProcessException {
        URL url = this.getClass().getResource("/JverConfig.properties");
        if (url == null) {
            throw new JverProcessException(IJverCoreMsg.FIND_CONFIG_FAILED, (Object)CONFIG_FILE);
        }
        return url;
    }

    private URL getDefaultConfigURL(ClassLoader loader) throws JverProcessException {
        URL url = loader.getResource(CONFIG_FILE);
        if (url == null) {
            throw new JverProcessException(IJverCoreMsg.FIND_CONFIG_FAILED, (Object)CONFIG_FILE);
        }
        return url;
    }

    private URL getConfigURL(ClassLoader loader, String configFileName) throws JverProcessException {
        File configFile = new File(configFileName);
        URL url = null;
        if (configFile.exists()) {
            try {
                url = configFile.toURL();
            }
            catch (MalformedURLException mue) {
                throw new JverProcessException(IJverCoreMsg.READ_CONFIG_FAILED, (Throwable)mue);
            }
        } else {
            url = loader.getResource(configFileName);
            if (url == null) {
                throw new JverProcessException(IJverCoreMsg.FIND_CONFIG_FAILED, (Object)configFileName);
            }
        }
        return url;
    }

    private void initMembers() {
        this.skipPackages_ = new Vector(10);
        this.suffixArchive_ = new Vector(5);
        if (this.properties_ != null) {
            Enumeration<?> e = this.properties_.propertyNames();
            while (e.hasMoreElements()) {
                String path;
                String key = (String)e.nextElement();
                if (key.startsWith("skip.")) {
                    path = this.properties_.getProperty(key);
                    if ((path = path.trim()).length() <= 0) continue;
                    this.skipPackages_.addElement(path);
                    continue;
                }
                if (!key.startsWith("suffixArchive.")) continue;
                path = this.properties_.getProperty(key);
                if ((path = path.trim()).length() <= 0) continue;
                this.suffixArchive_.addElement(path);
            }
        }
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        boolean bValue = defaultValue;
        Properties properties = this.getProperties();
        if (properties != null && ((Hashtable)properties).containsKey(key)) {
            String sValue = properties.getProperty(key);
            bValue = Boolean.valueOf(sValue.trim());
        }
        return bValue;
    }

    public String getStringValue(String key, String defaultValue) {
        String sValue = defaultValue;
        Properties properties = this.getProperties();
        if (properties != null && ((Hashtable)properties).containsKey(key)) {
            sValue = properties.getProperty(key);
        }
        return sValue;
    }

    public int getIntegerValue(String key, int defaultValue) {
        int iValue = defaultValue;
        Properties properties = this.getProperties();
        if (properties != null && ((Hashtable)properties).containsKey(key)) {
            String sValue = properties.getProperty(key);
            try {
                iValue = Integer.parseInt(sValue.trim());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return iValue;
    }

    public Vector getSkipPackages() {
        return this.skipPackages_;
    }

    public void setSkipPackages(Vector skipPackages) {
        this.skipPackages_ = skipPackages;
    }

    public boolean isInFilterList(String name) {
        Vector skipPackages = this.getSkipPackages();
        int nSkipPackages = skipPackages.size();
        int ii = 0;
        while (ii < nSkipPackages) {
            if (name.startsWith((String)skipPackages.elementAt(ii))) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public boolean isJverClass(String name) {
        return name.startsWith(SKIP_MYSELF);
    }

    public boolean isArchive(File file) {
        String name = file.getName();
        Vector suffixArchive = this.getSuffixArchive();
        int ii = 0;
        while (ii < suffixArchive.size()) {
            if (name.endsWith((String)suffixArchive.elementAt(ii))) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public boolean isTestArchive(File file) {
        return this.isArchive(file) && file.getName().toLowerCase().indexOf("test") != -1;
    }

    public boolean passesSkipFilter(String name) {
        boolean passes = false;
        passes = !this.isInFilterList(name) && (!this.isJverClass(name) || JverConfig.isSelfTest());
        return passes;
    }

    public static final void setSelfTest(boolean val) {
        selfTest = val;
    }

    public static final boolean isSelfTest() {
        return selfTest;
    }

    private Properties getProperties() {
        return this.properties_;
    }

    private Vector getSuffixArchive() {
        return this.suffixArchive_;
    }
}

