/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class JFaceColors {
    private static Hashtable colorTable = new Hashtable();
    private static ArrayList allocatedColors = new ArrayList();

    public static Color getBannerBackground(Display display) {
        return display.getSystemColor(25);
    }

    public static Color getBannerForeground(Display display) {
        return display.getSystemColor(24);
    }

    public static Color getErrorBackground(Display display) {
        return display.getSystemColor(22);
    }

    public static Color getErrorBorder(Display display) {
        return display.getSystemColor(17);
    }

    public static Color getErrorText(Display display) {
        return JFaceColors.getColorSetting(display, "ERROR_COLOR");
    }

    public static Color getHyperlinkText(Display display) {
        return JFaceColors.getColorSetting(display, "HYPERLINK_COLOR");
    }

    public static Color getActiveHyperlinkText(Display display) {
        return JFaceColors.getColorSetting(display, "ACTIVE_HYPERLINK_COLOR");
    }

    public static void clearColor(String colorName) {
        colorTable.remove(colorName);
    }

    private static Color getColorSetting(Display display, String preferenceName) {
        if (colorTable.containsKey(preferenceName)) {
            return (Color)colorTable.get(preferenceName);
        }
        IPreferenceStore store = JFacePreferences.getPreferenceStore();
        if (store == null) {
            Color color = JFaceColors.getDefaultColor(display, preferenceName);
            colorTable.put(preferenceName, color);
            return color;
        }
        Color color = new Color((Device)display, PreferenceConverter.getColor(store, preferenceName));
        allocatedColors.add(color);
        colorTable.put(preferenceName, color);
        return color;
    }

    private static Color getDefaultColor(Display display, String preferenceName) {
        if (preferenceName.equals("ERROR_COLOR")) {
            return display.getSystemColor(3);
        }
        if (preferenceName.equals("HYPERLINK_COLOR")) {
            Color color = new Color((Device)display, 0, 0, 153);
            allocatedColors.add(color);
            return color;
        }
        if (preferenceName.equals("ACTIVE_HYPERLINK_COLOR")) {
            return display.getSystemColor(9);
        }
        return display.getSystemColor(2);
    }

    public static void disposeColors() {
        Iterator colors = ((AbstractList)allocatedColors).iterator();
        while (colors.hasNext()) {
            ((Color)colors.next()).dispose();
        }
    }

    public static void setColors(Control control, Color foreground, Color background) {
        if (foreground != null) {
            control.setForeground(foreground);
        }
        if (background != null) {
            control.setBackground(background);
        }
    }
}

