/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontRegistry {
    private ListenerList listeners = new ListenerList();
    private Map stringToFont = new HashMap(7);
    private Map stringToFontData = new HashMap(7);
    private List staleFonts = new ArrayList();

    public FontRegistry() {
        Display display = Display.getCurrent();
        Assert.isNotNull(display);
        this.hookDisplayDispose(display);
    }

    public FontRegistry(String location, ClassLoader loader) throws MissingResourceException {
        Display display = Display.getCurrent();
        Assert.isNotNull(display);
        this.readResourceBundle(location);
        this.hookDisplayDispose(display);
    }

    public FontRegistry(String location) throws MissingResourceException {
        this(location, null);
    }

    private void readResourceBundle(String location) {
        block7: {
            String osname = System.getProperty("os.name").trim();
            String wsname = SWT.getPlatform();
            osname = StringConverter.removeWhiteSpaces(osname).toLowerCase();
            wsname = StringConverter.removeWhiteSpaces(wsname).toLowerCase();
            String OSLocation = location;
            String WSLocation = location;
            ResourceBundle bundle = null;
            if (osname != null) {
                OSLocation = String.valueOf(location) + "_" + osname;
                if (wsname != null) {
                    WSLocation = String.valueOf(OSLocation) + "_" + wsname;
                }
            }
            try {
                bundle = ResourceBundle.getBundle(WSLocation);
                this.readResourceBundle(bundle, WSLocation);
            }
            catch (MissingResourceException missingResourceException) {
                try {
                    bundle = ResourceBundle.getBundle(OSLocation);
                    this.readResourceBundle(bundle, WSLocation);
                }
                catch (MissingResourceException osException) {
                    if (location != OSLocation) {
                        bundle = ResourceBundle.getBundle(location);
                        this.readResourceBundle(bundle, WSLocation);
                        break block7;
                    }
                    throw osException;
                }
            }
        }
    }

    public FontRegistry(Display display) {
        Assert.isNotNull(display);
        this.hookDisplayDispose(display);
    }

    public void addListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public FontData bestData(FontData[] fonts, Display display) {
        int i = 0;
        while (i < fonts.length) {
            FontData fd = fonts[i];
            if (fd == null) break;
            FontData[] fixedFonts = display.getFontList(fd.getName(), false);
            if (this.isFixedFont(fixedFonts, fd)) {
                return fd;
            }
            FontData[] scalableFonts = display.getFontList(fd.getName(), true);
            if (scalableFonts.length > 0) {
                return fd;
            }
            ++i;
        }
        if (fonts.length > 0) {
            return fonts[0];
        }
        return null;
    }

    public FontData[] bestDataArray(FontData[] fonts, Display display) {
        FontData bestData = this.bestData(fonts, display);
        if (bestData == null) {
            return null;
        }
        FontData[] datas = new FontData[]{bestData};
        return datas;
    }

    private Font createFont(String symbolicName, FontData[] fonts) {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        FontData[] validData = this.bestDataArray(fonts, display);
        if (validData == null) {
            return null;
        }
        this.put(symbolicName, validData, false);
        return new Font((Device)display, validData);
    }

    Font defaultFont() {
        Display current = Display.getCurrent();
        if (current == null) {
            Shell shell = new Shell();
            Font font = shell.getFont();
            shell.dispose();
            return font;
        }
        return current.getSystemFont();
    }

    private FontData[] defaultFontData() {
        return this.defaultFont().getFontData();
    }

    private void fireFontMappingChanged(String name) {
        String finalName = name;
        Object[] listeners = this.listeners.getListeners();
        if (listeners.length > 0) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, finalName, null, null);
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }
    }

    public FontData[] getFontData(String symbolicName) {
        Assert.isNotNull(symbolicName);
        Object result = this.stringToFontData.get(symbolicName);
        if (result == null) {
            return this.defaultFontData();
        }
        return (FontData[])result;
    }

    public Font get(String symbolicName) {
        Assert.isNotNull(symbolicName);
        Object result = this.stringToFont.get(symbolicName);
        if (result != null) {
            return (Font)result;
        }
        result = this.stringToFontData.get(symbolicName);
        if (result == null) {
            return this.defaultFont();
        }
        Font font = this.createFont(symbolicName, (FontData[])result);
        if (font == null) {
            return this.defaultFont();
        }
        this.stringToFont.put(symbolicName, font);
        return font;
    }

    public boolean hasValueFor(String fontKey) {
        return this.stringToFontData.containsKey(fontKey);
    }

    private void handleDisplayDispose() {
        this.disposeFonts(this.stringToFont.values().iterator());
        this.disposeFonts(this.staleFonts.iterator());
        this.stringToFont.clear();
        this.staleFonts.clear();
        this.listeners.clear();
    }

    private void disposeFonts(Iterator iterator) {
        while (iterator.hasNext()) {
            Object next = iterator.next();
            ((Font)next).dispose();
        }
    }

    private void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                FontRegistry.this.handleDisplayDispose();
            }
        });
    }

    private boolean isFixedFont(FontData[] fixedFonts, FontData fd) {
        int height = fd.getHeight();
        String name = fd.getName();
        int i = 0;
        while (i < fixedFonts.length) {
            FontData fixed = fixedFonts[i];
            if (fixed.getHeight() == height && fixed.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private FontData makeFontData(String value) throws MissingResourceException {
        try {
            return StringConverter.asFontData(value.trim());
        }
        catch (DataFormatException dataFormatException) {
            throw new MissingResourceException("Wrong font data format. Value is: \"" + value + "\"", this.getClass().getName(), value);
        }
    }

    public void put(String symbolicName, FontData[] fontData) {
        this.put(symbolicName, fontData, true);
    }

    private void put(String symbolicName, FontData[] fontData, boolean update) {
        Assert.isNotNull(symbolicName);
        Assert.isNotNull(fontData);
        Object[] existing = (FontData[])this.stringToFontData.get(symbolicName);
        if (Arrays.equals(existing, fontData)) {
            return;
        }
        Font oldFont = (Font)this.stringToFont.remove(symbolicName);
        this.stringToFontData.put(symbolicName, fontData);
        if (update) {
            this.fireFontMappingChanged(symbolicName);
        }
        if (oldFont == this.defaultFont()) {
            return;
        }
        if (oldFont != null) {
            this.staleFonts.add(oldFont);
        }
    }

    private void readResourceBundle(ResourceBundle bundle, String bundleName) throws MissingResourceException {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            int pos = key.lastIndexOf(46);
            if (pos == -1) {
                this.stringToFontData.put(key, new FontData[]{this.makeFontData(bundle.getString(key))});
                continue;
            }
            String name = key.substring(0, pos);
            int i = 0;
            try {
                i = Integer.parseInt(key.substring(pos + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MissingResourceException("Wrong key format ", bundleName, key);
            }
            FontData[] elements = (FontData[])this.stringToFontData.get(name);
            if (elements == null) {
                elements = new FontData[8];
                this.stringToFontData.put(name, elements);
            }
            if (i > elements.length) {
                FontData[] na = new FontData[i + 8];
                System.arraycopy(elements, 0, na, 0, elements.length);
                elements = na;
                this.stringToFontData.put(name, elements);
            }
            elements[i] = this.makeFontData(bundle.getString(key));
        }
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }
}

