/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.rendering.adapter;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.AbstractViewElementProperty;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElementAggregation;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElementProperty;
import com.sap.ide.webdynpro.rendering.UIElement;
import com.sap.ide.webdynpro.rendering.adapter.IdePaginator;
import com.sap.ide.webdynpro.rendering.adapter.IdePatternContainerIconButton;
import com.sap.ide.webdynpro.rendering.adapter.IdePatternContainerTabItem;
import com.sap.ide.webdynpro.rendering.uielements.PatternContainerTab;
import com.sap.ide.webdynpro.rendering.uri.IPaginator;
import com.sap.ide.webdynpro.rendering.uri.IPatternContainerIconButton;
import com.sap.ide.webdynpro.rendering.uri.IPatternContainerTabItem;

public class IdePatternContainerTab
extends PatternContainerTab {
    private ViewElementAggregation mTabs = null;
    private ViewElementAggregation mFunctions = null;

    public IdePatternContainerTab(DevelopmentObject object, String id) {
        super(object, id);
        if (object instanceof ViewElement) {
            UIElement sitem;
            ViewElement item;
            int i;
            ViewElement patternSequence = (ViewElement)object;
            this.mTabs = patternSequence.getOutgoingAggregation("tabs");
            if (this.mTabs != null) {
                i = 0;
                while (i < this.mTabs.getAggregatedObjectCount()) {
                    item = this.mTabs.getAggregatedObject(i);
                    sitem = new IdePatternContainerTabItem((DevelopmentObject)item, item.getName());
                    this.addItems((IPatternContainerTabItem)((Object)sitem));
                    ++i;
                }
            }
            this.mFunctions = patternSequence.getOutgoingAggregation("ExpandFunctions");
            if (this.mFunctions != null) {
                i = 0;
                while (i < this.mFunctions.getAggregatedObjectCount()) {
                    item = this.mFunctions.getAggregatedObject(i);
                    sitem = new IdePatternContainerIconButton((DevelopmentObject)item, item.getName());
                    this.addAdditionalButtons((IPatternContainerIconButton)((Object)sitem));
                    ++i;
                }
            }
        }
    }

    public int getMaxVisibleItems() {
        ViewElement patternSequence;
        AbstractViewElementProperty property;
        int lMax = 0;
        if (this.mObject instanceof ViewElement && (property = (patternSequence = (ViewElement)this.mObject).getProperty("maxVisibleTabs")) instanceof ViewElementProperty) {
            try {
                lMax = Integer.parseInt(((ViewElementProperty)property).getValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (lMax == 0) {
            lMax = 1;
        }
        return lMax;
    }

    public boolean getHasAdditionalButtons() {
        if (this.mFunctions != null) {
            return this.mFunctions.getAggregatedObjectCount() > 0;
        }
        return super.getHasAdditionalButtons();
    }

    public int getSelectedIndex() {
        ViewElement active;
        ViewElement patternSequence;
        AbstractViewElementProperty property;
        if (this.mObject instanceof ViewElement && (property = (patternSequence = (ViewElement)this.mObject).getProperty("selectedTab")) instanceof ViewElementProperty && (active = this.mTabs.getAggregatedObject(((ViewElementProperty)property).getValue())) != null) {
            return this.mTabs.getAggregatedObjectPosition(active);
        }
        return super.getSelectedIndex();
    }

    public IPaginator getPaginator() {
        if (this.getHasPageIndicator()) {
            return new IdePaginator(null, "");
        }
        return null;
    }

    public boolean getHasPageIndicator() {
        return this.getMaxVisibleItems() < this.mTabs.getAggregatedObjectCount();
    }

    public boolean getScrollableItems() {
        return true;
    }
}

