/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.rendering;

import com.sap.ide.webdynpro.rendering.IdeRenderManager;
import com.sap.ide.webdynpro.rendering.custom.IRenderingElementDefinition;
import com.sap.ide.webdynpro.rendering.custom.LayoutElementDefinition;
import com.sap.ide.webdynpro.rendering.custom.RenderingElementDefinition;
import com.sap.ide.webdynpro.rendering.mapping.ElementMapper;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RenderingPlugin
extends AbstractUIPlugin {
    private static RenderingPlugin plugin;
    public static final String RENDERING_PLUGIN_ID = "com.sap.ide.webdynpro.rendering";
    private static final String SAP_EXTENSION_POINT_RENDERING_DEFINITION = "renderingPluginDefinition";
    private static final String EXTENSION_CLASS_NAME = "class";

    public RenderingPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static RenderingPlugin getDefault() {
        return plugin;
    }

    public static String getURL() {
        Plugin plugin = Platform.getPlugin((String)RENDERING_PLUGIN_ID);
        PluginDescriptor descriptor = (PluginDescriptor)plugin.getDescriptor();
        return descriptor.getLocation() + "resources" + File.separator;
    }

    private Hashtable getExtensions() {
        Hashtable<String, IConfigurationElement> lExt = new Hashtable<String, IConfigurationElement>();
        IExtensionPoint lExtensionPoint = this.getDescriptor().getExtensionPoint(SAP_EXTENSION_POINT_RENDERING_DEFINITION);
        if (lExtensionPoint == null) {
            return lExt;
        }
        IExtension[] lExtensions = lExtensionPoint.getExtensions();
        int i = 0;
        while (i < lExtensions.length) {
            IConfigurationElement[] lConfigurationElements = lExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < lConfigurationElements.length) {
                if (lConfigurationElements[j].getAttribute(EXTENSION_CLASS_NAME) != null) {
                    lExt.put(lExtensions[i].getUniqueIdentifier(), lConfigurationElements[j]);
                }
                ++j;
            }
            ++i;
        }
        return lExt;
    }

    public void startup() throws CoreException {
        super.startup();
        Hashtable lExt = this.getExtensions();
        Enumeration lExtPoints = lExt.keys();
        String lExtPointId = null;
        while (lExtPoints.hasMoreElements()) {
            lExtPointId = (String)lExtPoints.nextElement();
            Object lNextElement = lExt.get(lExtPointId);
            if (!(lNextElement instanceof IConfigurationElement)) continue;
            IConfigurationElement lConfigElement = (IConfigurationElement)lNextElement;
            String lClassName = lConfigElement.getAttribute(EXTENSION_CLASS_NAME);
            try {
                IExtension lDeclExtension = lConfigElement.getDeclaringExtension();
                ClassLoader lClassLoader = lDeclExtension.getDeclaringPluginDescriptor().getPluginClassLoader();
                Object lClassInstance = lClassLoader.loadClass(lClassName).newInstance();
                if (!(lClassInstance instanceof IRenderingElementDefinition)) continue;
                IRenderingElementDefinition definition = (IRenderingElementDefinition)lClassInstance;
                RenderingElementDefinition[] array = definition.getRenderingElementDefinitions();
                int i = 0;
                while (i < array.length) {
                    IdeRenderManager.addRenderer(array[i].getAdapterClass(), array[i].getRendererClass());
                    ElementMapper.addAdapter(array[i].getLibrary() + "~" + array[i].getElement(), array[i].getAdapterClass());
                    ++i;
                }
                LayoutElementDefinition[] layouts = definition.getLayoutElementDefinitions();
                int i2 = 0;
                while (i2 < layouts.length) {
                    IdeRenderManager.addRenderer(layouts[i2].getAdapterClass(), layouts[i2].getRendererClass());
                    ElementMapper.addLayout(layouts[i2].getLibrary() + "~" + layouts[i2].getElement(), layouts[i2].getConvertClass(), layouts[i2].getMethod());
                    ++i2;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

