/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent.tree;

import com.sap.ide.tools.core.treemappingcomponent.LinkPainter;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropValidator;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeMappingComposite;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import java.util.Vector;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerDropAdapter
extends ViewerDropAdapter {
    private DragDropValidator mExternalValidator;
    private TreeMappingValidator mValidator;
    private TreeViewer mTargetViewer;
    private TreeMappingComposite mComposite;
    private TreeMappingListener mListener;
    private Object mTarget;
    private LinkPainter mPainter;
    private int mDirection;
    private Vector mDragDropListeners = new Vector();

    public TreeViewerDropAdapter(Viewer viewer, TreeMappingComposite composite, LinkPainter painter, int direction) {
        super(viewer);
        this.mTargetViewer = (TreeViewer)viewer;
        this.mComposite = composite;
        this.mPainter = painter;
        this.mDirection = direction;
    }

    public boolean performDrop(Object data) {
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (this.mDirection != this.mComposite.getDragType()) {
            return false;
        }
        if (null == target) {
            return false;
        }
        if (null == this.mValidator) {
            return true;
        }
        TreeNode targetNode = (TreeNode)target;
        TreeNode srcNode = (TreeNode)this.mComposite.getDraggedItem();
        this.mTarget = target;
        return this.mValidator.allowMapping(targetNode.getData(), srcNode.getData(), this.mDirection);
    }

    public void setValidator(TreeMappingValidator mValidator) {
        this.mValidator = mValidator;
    }

    public void setListener(TreeMappingListener mListener) {
        this.mListener = mListener;
    }

    public void drop(DropTargetEvent event) {
        TreeItem item = (TreeItem)event.item;
        TreeNode targetNode = (TreeNode)item.getData();
        TreeNode srcNode = (TreeNode)this.mComposite.getDraggedItem();
        if (null != this.mExternalValidator && !this.mExternalValidator.allowDrop(srcNode.getData(), targetNode.getData())) {
            return;
        }
        if (this.mDirection == 0x2000000) {
            this.mComposite.createNewLink(srcNode.getData(), targetNode.getData());
        } else {
            this.mComposite.createNewLink(targetNode.getData(), srcNode.getData());
        }
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        try {
            TreeItem item = (TreeItem)event.item;
            TreeNode targetNode = (TreeNode)item.getData();
            TreeNode srcNode = (TreeNode)this.mComposite.getDraggedItem();
            if (null == targetNode || null == srcNode) {
                return;
            }
            Object src = null;
            Object target = null;
            src = srcNode.getData();
            target = targetNode.getData();
            if (null == src || null == target) {
                return;
            }
            if (this.mDirection == 0x2000000) {
                src = targetNode.getData();
                target = srcNode.getData();
            }
            if (this.mValidator.allowMapping(src, target, this.mDirection)) {
                event.detail = this.mComposite.getDragCursorType(this.mDirection);
            }
        }
        catch (Exception e) {
            event.detail = this.mComposite.getDragCursorType(this.mDirection);
        }
        this.fireDragOverEvent();
    }

    private void fireDragOverEvent() {
        int i = 0;
        while (i < this.mDragDropListeners.size()) {
            DragDropListener listener = (DragDropListener)this.mDragDropListeners.get(i);
            listener.dragOver(this.getDraggedData(), this.mDirection);
            ++i;
        }
    }

    public void setDragDropValidator(DragDropValidator validator) {
        this.mExternalValidator = validator;
    }

    public void addDragDropListener(DragDropListener dragDropListener) {
        this.mDragDropListeners.add(dragDropListener);
    }

    public void removeDragDropListener(DragDropListener dragDropListener) {
        this.mDragDropListeners.remove(dragDropListener);
    }

    private Object getDraggedData() {
        Object data = null;
        if (null != this.mComposite.getDraggedItem() && this.mComposite.getDraggedItem() instanceof TreeNode) {
            TreeNode node = (TreeNode)this.mComposite.getDraggedItem();
            data = node.getData();
        }
        return data;
    }
}

