/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent.tree;

import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropListener;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeMappingComposite;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import java.util.Vector;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public class TreeViewerDragAdapter
implements DragSourceListener {
    private TreeViewer mSourceTreeViewer;
    private TreeMappingComposite mComposite;
    private int mDirection;
    private Vector mDragDropListener = new Vector();

    public TreeViewerDragAdapter(TreeViewer sourceViewer, TreeMappingComposite composite, int direction) {
        this.mSourceTreeViewer = sourceViewer;
        this.mComposite = composite;
        this.mDirection = direction;
    }

    public void dragFinished(DragSourceEvent event) {
        this.fireDragFinishedEvent();
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.mSourceTreeViewer.getSelection();
        if (null != selection && !selection.isEmpty()) {
            this.mComposite.setDraggedItem(selection.getFirstElement());
        }
        event.data = new String("Test");
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.mSourceTreeViewer.getSelection();
        if (null != selection && !selection.isEmpty()) {
            TreeNode node = (TreeNode)selection.getFirstElement();
            event.data = null != node.getData() ? node.getData().toString() : new String("Test");
            this.mComposite.setDraggedItem(node);
            this.mComposite.setDragType(this.mDirection);
        }
        this.fireDragStartEvent();
    }

    private void fireDragStartEvent() {
        int i = 0;
        while (i < this.mDragDropListener.size()) {
            DragDropListener listener = (DragDropListener)this.mDragDropListener.get(i);
            listener.dragStart(this.getDraggedData(), this.mDirection);
            ++i;
        }
    }

    public void setSourceTreeViewer(TreeViewer mSourceTreeViewer) {
        this.mSourceTreeViewer = mSourceTreeViewer;
    }

    public void addDragDropListener(DragDropListener dragDropListener) {
        this.mDragDropListener.add(dragDropListener);
    }

    public void removeDragDropListener(DragDropListener dragDropListener) {
        this.mDragDropListener.remove(dragDropListener);
    }

    private void fireDragFinishedEvent() {
        int i = 0;
        while (i < this.mDragDropListener.size()) {
            DragDropListener listener = (DragDropListener)this.mDragDropListener.get(i);
            listener.dragFinished(this.getDraggedData(), this.mDirection);
            ++i;
        }
    }

    private Object getDraggedData() {
        Object data = null;
        if (null != this.mComposite.getDraggedItem() && this.mComposite.getDraggedItem() instanceof TreeNode) {
            TreeNode node = (TreeNode)this.mComposite.getDraggedItem();
            data = node.getData();
        }
        return data;
    }
}

