/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent.tree;

import com.sap.ide.tools.core.treemappingcomponent.LinkPainter;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.tools.core.treemappingcomponent.decorator.LinkDecorator;
import com.sap.ide.tools.core.treemappingcomponent.drawing.ShapeInfo;
import com.sap.ide.tools.core.treemappingcomponent.filter.DrawingAreaFilter;
import com.sap.ide.tools.core.treemappingcomponent.filter.TreeMappingFilter;
import com.sap.ide.tools.core.treemappingcomponent.filter.TreeViewerFilter;
import com.sap.ide.tools.core.treemappingcomponent.listener.CompositeSelectionListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.DragDropValidator;
import com.sap.ide.tools.core.treemappingcomponent.listener.MappingSelectionListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import com.sap.ide.tools.core.treemappingcomponent.provider.TreeMappingContentProvider;
import com.sap.ide.tools.core.treemappingcomponent.provider.TreeMappingLabelProvider;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeViewerDragAdapter;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeViewerDropAdapter;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeMappingComposite
extends Composite {
    private IMenuListener mTargetMenuListener;
    private IMenuListener mSrcMenuListener;
    private IMenuListener mCanvasMenuListener;
    private int mDragType;
    private boolean mEnableReverseDragDrop = false;
    public static final int ALL_LEVELS = -1;
    public static final int ARROW_RIGHT = 1;
    public static final int ARROW_LEFT = 2;
    public static final int ARROW_NONE = 3;
    public static final int ARROW_DEFAULT = 1;
    public static final int ARROW_BOTH = 4;
    public static final int LEFT = 16384;
    public static final int RIGHT = 131072;
    public static final int BOTH = 7;
    public static final int LINK = 11;
    public static final int SHAPE_WITHLINK = 8;
    public static final int SHAPE_WITHOUTLINK = 9;
    public static final int SHAPE_ALL = 10;
    public static final int LINE_SOLID = 1;
    public static final int LINE_DOT = 3;
    private TreeViewer mSourceTreeViewer;
    private Canvas mDrawingArea;
    private TreeViewer mTargetTreeViewer;
    private TreeMappingLabelProvider mInternalLabelProviderSource;
    private TreeMappingLabelProvider mInternalLabelProviderTarget;
    private TreeMappingContentProvider mInternalContentProviderSource;
    private TreeMappingContentProvider mInternalContentProviderTarget;
    private TreeViewerDropAdapter mDropAdapter;
    private TreeViewerDragAdapter mDragAdapter;
    private TreeViewerDropAdapter mDropAdapterReverse;
    private TreeViewerDragAdapter mDragAdapterReverse;
    private boolean mEnableDragDrop = false;
    private LinkPainter mLinkPainter;
    private Object mDraggedItem;
    private Label mLeftTreeHeader;
    private Label mRightTreeHeader;
    private Label mDrawingAreaHeader;
    private CompositeSelectionListener mSelectionListener;
    private int mLeftExpandLevel = -1;
    private int mRightExpandLevel = -1;
    private boolean mHeaderVisible = true;
    private Composite mCompLabels;
    private SashForm mSplitter;
    private int mLeftDragType = 2;
    private int mRightDragType = 2;

    public TreeMappingComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        Composite composite = new Composite((Composite)this, 0);
        GridLayout compGridLayout = new GridLayout(1, false);
        compGridLayout.marginHeight = 0;
        compGridLayout.marginHeight = 0;
        composite.setLayout((Layout)compGridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.mInternalLabelProviderSource = new TreeMappingLabelProvider();
        this.mInternalLabelProviderTarget = new TreeMappingLabelProvider();
        this.mInternalContentProviderSource = new TreeMappingContentProvider(16384);
        this.mInternalContentProviderTarget = new TreeMappingContentProvider(131072);
        this.mCompLabels = new Composite(composite, 0);
        this.mCompLabels.setLayoutData((Object)new GridData(768));
        this.mCompLabels.setLayout((Layout)new GridLayout(3, false));
        this.mLeftTreeHeader = new Label(this.mCompLabels, 0);
        this.mDrawingAreaHeader = new Label(this.mCompLabels, 0);
        this.mRightTreeHeader = new Label(this.mCompLabels, 0);
        this.mSplitter = new SashForm(composite, 0);
        this.mSplitter.setLayoutData((Object)new GridData(1808));
        this.mSourceTreeViewer = new TreeViewer((Composite)this.mSplitter);
        this.mSourceTreeViewer.setLabelProvider((IBaseLabelProvider)this.mInternalLabelProviderSource);
        this.mSourceTreeViewer.setContentProvider((IContentProvider)this.mInternalContentProviderSource);
        this.mDrawingArea = new Canvas((Composite)this.mSplitter, 2048);
        this.mTargetTreeViewer = new TreeViewer((Composite)this.mSplitter);
        this.mTargetTreeViewer.setLabelProvider((IBaseLabelProvider)this.mInternalLabelProviderTarget);
        this.mTargetTreeViewer.setContentProvider((IContentProvider)this.mInternalContentProviderTarget);
        this.mLinkPainter = new LinkPainter(this.mDrawingArea, this.mSourceTreeViewer, this.mTargetTreeViewer);
        this.mDropAdapter = new TreeViewerDropAdapter((Viewer)this.mTargetTreeViewer, this, this.mLinkPainter, 0x2000000);
        this.mDragAdapter = new TreeViewerDragAdapter(this.mSourceTreeViewer, this, 0x2000000);
        this.mDropAdapterReverse = new TreeViewerDropAdapter((Viewer)this.mSourceTreeViewer, this, this.mLinkPainter, 0x4000000);
        this.mDragAdapterReverse = new TreeViewerDragAdapter(this.mTargetTreeViewer, this, 0x4000000);
        this.mSelectionListener = new CompositeSelectionListener(this.mSourceTreeViewer, this.mTargetTreeViewer);
        this.mSourceTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.mSelectionListener);
        this.mTargetTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.mSelectionListener);
        this.mLinkPainter.addLinkSelectionListener(this.mSelectionListener);
        this.mSplitter.setWeights(new int[]{38, 24, 38});
        this.mSplitter.SASH_WIDTH = 1;
        this.mSourceTreeViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TreeMappingComposite.this.setLabelBounds();
            }
        });
        this.mDrawingArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TreeMappingComposite.this.setLabelBounds();
            }
        });
        this.mTargetTreeViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TreeMappingComposite.this.setLabelBounds();
            }
        });
        this.attachContextMenu();
        this.diableMultipleSelection();
    }

    private void diableMultipleSelection() {
        this.mSourceTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener());
        this.mTargetTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener());
    }

    private void attachContextMenu() {
        MenuManager srcMenuManager = new MenuManager();
        Menu srcMenu = srcMenuManager.createContextMenu(this.mSourceTreeViewer.getControl());
        srcMenuManager.setRemoveAllWhenShown(true);
        this.mSourceTreeViewer.getControl().setMenu(srcMenu);
        srcMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (null != TreeMappingComposite.this.mSrcMenuListener) {
                    TreeMappingComposite.this.mSrcMenuListener.menuAboutToShow(manager);
                }
            }
        });
        MenuManager targetMenuManager = new MenuManager();
        Menu targetMenu = targetMenuManager.createContextMenu(this.mTargetTreeViewer.getControl());
        targetMenuManager.setRemoveAllWhenShown(true);
        this.mTargetTreeViewer.getControl().setMenu(targetMenu);
        targetMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (null != TreeMappingComposite.this.mTargetMenuListener) {
                    TreeMappingComposite.this.mTargetMenuListener.menuAboutToShow(manager);
                }
            }
        });
        MenuManager canvasMenuManager = new MenuManager();
        final Menu canvasMenu = canvasMenuManager.createContextMenu((Control)this.mDrawingArea);
        canvasMenuManager.setRemoveAllWhenShown(true);
        this.mDrawingArea.setMenu(canvasMenu);
        this.mLinkPainter.setCanvasMenu(canvasMenuManager);
        canvasMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (null != TreeMappingComposite.this.mCanvasMenuListener) {
                    if (null != TreeMappingComposite.this.getSelectedLink()) {
                        TreeMappingComposite.this.mCanvasMenuListener.menuAboutToShow(manager);
                    } else {
                        canvasMenu.setVisible(false);
                    }
                }
            }
        });
    }

    private void setLabelBounds() {
        if (this.mLeftTreeHeader.isDisposed() || this.mDrawingAreaHeader.isDisposed() || this.mRightTreeHeader.isDisposed() || this.mSourceTreeViewer.getTree().isDisposed() || this.mDrawingArea.isDisposed() || this.mTargetTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.mLeftTreeHeader.setBounds(this.mSourceTreeViewer.getTree().getBounds().x, 1, this.mSourceTreeViewer.getTree().getBounds().width - 1, 18);
        this.mDrawingAreaHeader.setBounds(this.mDrawingArea.getBounds().x, 1, this.mDrawingArea.getBounds().width - 1, 18);
        this.mRightTreeHeader.setBounds(this.mTargetTreeViewer.getTree().getBounds().x, 1, this.mTargetTreeViewer.getTree().getBounds().width - 1, 18);
    }

    public void setContentProvider(ITreeContentProvider source, ITreeContentProvider target) {
        if (null != source) {
            this.mInternalContentProviderSource.setExternalContentProvider(source);
            this.mSourceTreeViewer.refresh();
        }
        if (null != target) {
            this.mInternalContentProviderTarget.setExternalContentProvider(target);
            this.mTargetTreeViewer.refresh();
        }
    }

    public void setLabelProvider(ILabelProvider source, ILabelProvider target) {
        if (null != source) {
            this.mInternalLabelProviderSource.setExternalLabelProvider(source);
        }
        if (null != target) {
            this.mInternalLabelProviderTarget.setExternalLabelProvider(target);
        }
    }

    public void setInput(Object left, Object right) {
        if (null != this.mSourceTreeViewer.getContentProvider()) {
            this.mSourceTreeViewer.setInput(left);
            this.mSourceTreeViewer.expandToLevel(this.mLeftExpandLevel);
            this.setDefaultSelection(this.mSourceTreeViewer);
        }
        if (null != this.mTargetTreeViewer.getContentProvider()) {
            this.mTargetTreeViewer.setInput(right);
            this.mTargetTreeViewer.expandToLevel(this.mRightExpandLevel);
            this.setDefaultSelection(this.mTargetTreeViewer);
        }
    }

    private void setDefaultSelection(TreeViewer treeViewer) {
        Tree tree = treeViewer.getTree();
        TreeItem[] items = tree.getItems();
        tree.showItem(items[0]);
    }

    public MappingObject[] getMappings() {
        return this.mLinkPainter.getMappings();
    }

    public void setEnableDragDrop(boolean enable) {
        this.mEnableDragDrop = enable;
        if (this.mEnableDragDrop) {
            this.attachDNDAdapter();
        }
    }

    public void setEnableDragDrop(int direction, boolean enable) {
        if (direction == 0x4000000) {
            this.setEnableReverseDragDrop(enable);
        } else if (direction == 0x2000000) {
            this.setEnableDragDrop(enable);
        } else if (direction == 0x6000000) {
            this.setEnableDragDrop(enable);
            this.setEnableReverseDragDrop(enable);
        }
    }

    private void setEnableReverseDragDrop(boolean enable) {
        this.mEnableReverseDragDrop = enable;
        this.attachReverseDNDAdapter();
    }

    private void attachReverseDNDAdapter() {
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.mTargetTreeViewer.addDragSupport(this.mRightDragType, transfers, (DragSourceListener)this.mDragAdapterReverse);
        this.mSourceTreeViewer.addDropSupport(this.mRightDragType, transfers, (DropTargetListener)this.mDropAdapterReverse);
    }

    public void setExpandLevel(int left, int right) {
        this.mLeftExpandLevel = left;
        this.mRightExpandLevel = right;
    }

    public void createLink(Object source, Object target) {
        this.mLinkPainter.createLink(source, target);
    }

    public void createLink(Object source, Object target, boolean fireEvent) {
        this.mLinkPainter.createLink(source, target, fireEvent);
    }

    public void createLink(Object source, Object target, int sourceEnframeStyle, int targetEnframeStyle, boolean includeSourceChildren, boolean includeTargetChildren) {
        this.mLinkPainter.createLink(source, target, sourceEnframeStyle, targetEnframeStyle, includeSourceChildren, includeTargetChildren);
    }

    void createNewLink(Object source, Object target) {
        this.mLinkPainter.createNewLink(source, target);
    }

    public void deleteLink(MappingObject mappingObject) {
        this.mLinkPainter.deleteLink(mappingObject);
    }

    public void deleteLink(MappingObject mapping, boolean fireEvent) {
        this.mLinkPainter.deleteLink(mapping, fireEvent);
    }

    public void deleteLink(Object source, Object target) {
        this.mLinkPainter.deleteLink(source, target);
    }

    public void deleteLink(Object source, Object target, boolean firePostDeleteEvent) {
        this.mLinkPainter.deleteLink(source, target, firePostDeleteEvent);
    }

    public void editLink(Object oldSource, Object oldTarget, Object newSource, Object newTarget) {
        this.mLinkPainter.editLink(oldSource, oldTarget, newSource, newTarget);
    }

    public MappingObject getSelectedLink() {
        return this.mLinkPainter.getSelectedLink();
    }

    public void addSelectionListener(MappingSelectionListener selectionListener) {
        this.mSelectionListener.setExternalSelectionListener(selectionListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener, int use) {
        if (use == 16384) {
            this.mSourceTreeViewer.addSelectionChangedListener(listener);
        } else {
            this.mTargetTreeViewer.addSelectionChangedListener(listener);
        }
    }

    public void addTreeListener(ITreeViewerListener listener, int use) {
        if (use == 16384) {
            this.mSourceTreeViewer.addTreeListener(listener);
        } else {
            this.mTargetTreeViewer.addTreeListener(listener);
        }
    }

    public void addMappingListener(TreeMappingListener mappingListener) {
        this.mLinkPainter.setMappingListener(mappingListener);
    }

    public void addDragDropListener(DragDropListener dragDropListener) {
        this.mDragAdapter.addDragDropListener(dragDropListener);
        this.mDropAdapter.addDragDropListener(dragDropListener);
        this.mDragAdapterReverse.addDragDropListener(dragDropListener);
        this.mDropAdapterReverse.addDragDropListener(dragDropListener);
    }

    public void setValidator(TreeMappingValidator validator) {
        this.mDropAdapter.setValidator(validator);
        this.mDropAdapterReverse.setValidator(validator);
        this.mLinkPainter.setValidator(validator);
    }

    public void setFilter(TreeMappingFilter left, TreeMappingFilter right) {
        TreeViewerFilter filter;
        if (null != left) {
            filter = new TreeViewerFilter();
            filter.setExternalFilter(left);
            this.mSourceTreeViewer.addFilter((ViewerFilter)filter);
        }
        if (null != right) {
            filter = new TreeViewerFilter();
            filter.setExternalFilter(right);
            this.mTargetTreeViewer.addFilter((ViewerFilter)filter);
        }
    }

    public void setDragDropValidator(DragDropValidator validator) {
        if (null == this.mDropAdapter) {
            return;
        }
        this.mDropAdapter.setDragDropValidator(validator);
    }

    public void setDragDropValidator(int direction, DragDropValidator validator) {
        switch (direction) {
            case 0x2000000: {
                this.setDragDropValidator(validator);
                break;
            }
            case 0x4000000: {
                this.setReverseDragDropValidator(validator);
                break;
            }
            case 0x6000000: {
                this.setDragDropValidator(validator);
                this.setReverseDragDropValidator(validator);
            }
        }
    }

    private void setReverseDragDropValidator(DragDropValidator validator) {
        if (null == this.mDropAdapterReverse) {
            return;
        }
        this.mDropAdapterReverse.setDragDropValidator(validator);
    }

    public void setEnableMappingContextMenu(boolean value) {
        this.mLinkPainter.setEnableMappingContextMenu(value);
    }

    public void setLeftTreeHeader(String text, int alignment) {
        this.mLeftTreeHeader.setText(" " + text);
        this.mLeftTreeHeader.setAlignment(alignment);
    }

    public void setRightTreeHeader(String text, int alignment) {
        this.mRightTreeHeader.setText(" " + text);
        this.mRightTreeHeader.setAlignment(alignment);
    }

    public void setDrawingAreaHeader(String text, int alignment) {
        this.mDrawingAreaHeader.setText(" " + text);
        this.mDrawingAreaHeader.setAlignment(alignment);
    }

    public void expand(int tree, Object data) {
        if (tree == 16384) {
            this.expand(this.mSourceTreeViewer, data);
        } else if (tree == 131072) {
            this.expand(this.mTargetTreeViewer, data);
        } else {
            return;
        }
    }

    public Object[] getMappings(Object source) {
        return this.mLinkPainter.getMappings(source);
    }

    public MappingObject[] getNewMappings() {
        return this.mLinkPainter.getNewMappings();
    }

    private void expand(TreeViewer treeViewer, Object data) {
        this.mLinkPainter.expand(treeViewer, data);
    }

    public ILabelProvider getLabelProvider(int tree) {
        switch (tree) {
            case 16384: {
                return this.mInternalLabelProviderSource.getExternalLabelProvider();
            }
            case 131072: {
                return this.mInternalLabelProviderTarget.getExternalLabelProvider();
            }
        }
        return null;
    }

    public Object[] getExpandedElements(int tree) {
        TreeViewer viewer = null;
        switch (tree) {
            case 16384: {
                viewer = this.mSourceTreeViewer;
                break;
            }
            case 131072: {
                viewer = this.mTargetTreeViewer;
                break;
            }
            default: {
                return new Object[1];
            }
        }
        Object[] selectedObjects = viewer.getExpandedElements();
        Vector<Object> selectedData = new Vector<Object>();
        int i = 0;
        while (i < selectedObjects.length) {
            if (selectedObjects[i] instanceof TreeNode) {
                TreeNode node = (TreeNode)selectedObjects[i];
                selectedData.add(node.getData());
            }
            ++i;
        }
        return selectedData.toArray();
    }

    public void setExpandedState(Object item, boolean expanded, int tree) {
        this.mLinkPainter.setExpandedState(item, expanded, tree);
    }

    public void setExpandedElements(Object[] items, int tree) {
        this.mLinkPainter.setExpandedElements(items, tree);
    }

    private void attachDNDAdapter() {
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.mSourceTreeViewer.addDragSupport(this.mLeftDragType, transfers, (DragSourceListener)this.mDragAdapter);
        this.mTargetTreeViewer.addDropSupport(this.mLeftDragType, transfers, (DropTargetListener)this.mDropAdapter);
    }

    Object getDraggedItem() {
        return this.mDraggedItem;
    }

    void setDraggedItem(Object mDraggedItem) {
        this.mDraggedItem = mDraggedItem;
    }

    public void setHeaderVisible(boolean visible) {
        this.mLeftTreeHeader.setVisible(visible);
        this.mRightTreeHeader.setVisible(visible);
        this.mDrawingAreaHeader.setVisible(visible);
        if (visible == this.mHeaderVisible) {
            return;
        }
        this.mHeaderVisible = visible;
        if (!visible) {
            this.mSourceTreeViewer.getControl().setBounds(0, 0, this.mSourceTreeViewer.getControl().getBounds().width, this.mSourceTreeViewer.getControl().getBounds().height + this.mLeftTreeHeader.getBounds().height);
            this.mTargetTreeViewer.getControl().setBounds(this.mTargetTreeViewer.getControl().getBounds().x, 0, this.mTargetTreeViewer.getControl().getBounds().width, this.mTargetTreeViewer.getControl().getBounds().height + this.mRightTreeHeader.getBounds().height);
            this.mDrawingArea.setBounds(this.mDrawingArea.getBounds().x, 0, this.mDrawingArea.getBounds().width, this.mDrawingArea.getBounds().height + this.mRightTreeHeader.getBounds().height);
        } else {
            this.mSourceTreeViewer.getControl().setBounds(0, this.mLeftTreeHeader.getBounds().height, this.mSourceTreeViewer.getControl().getBounds().width, 350);
            this.mTargetTreeViewer.getControl().setBounds(this.mTargetTreeViewer.getControl().getBounds().x, this.mRightTreeHeader.getBounds().height, this.mTargetTreeViewer.getControl().getBounds().width, 350);
            this.mDrawingArea.setBounds(this.mDrawingArea.getBounds().x, this.mDrawingAreaHeader.getBounds().height, this.mDrawingArea.getBounds().width, 350);
        }
    }

    public void setSorter(ViewerSorter left, ViewerSorter right) {
        if (null != this.mSourceTreeViewer && null != left) {
            this.mSourceTreeViewer.setSorter(left);
        }
        if (null != this.mTargetTreeViewer && null != right) {
            this.mTargetTreeViewer.setSorter(right);
        }
    }

    public void setLinkDecorator(LinkDecorator decorator) {
        this.mLinkPainter.setLinkDecorator(decorator);
    }

    public void setDrawingAreaFilter(DrawingAreaFilter filter) {
        this.mLinkPainter.setDrawingAreaFilter(filter);
    }

    public void reloadTree(int tree) {
        switch (tree) {
            case 16384: {
                this.mSourceTreeViewer.refresh();
                this.mSourceTreeViewer.expandToLevel(this.mLeftExpandLevel);
                break;
            }
            case 131072: {
                this.mTargetTreeViewer.refresh();
                this.mTargetTreeViewer.expandToLevel(this.mRightExpandLevel);
                break;
            }
            case 7: {
                this.mSourceTreeViewer.refresh();
                this.mSourceTreeViewer.expandToLevel(this.mLeftExpandLevel);
                this.mTargetTreeViewer.refresh();
                this.mTargetTreeViewer.expandToLevel(this.mRightExpandLevel);
            }
        }
        this.mLinkPainter.refresh();
    }

    public void reloadTree(int tree, boolean preserveExpandedState) {
        if (!preserveExpandedState) {
            this.reloadTree(tree);
        }
        if (tree == 16384 || tree == 131072) {
            this.restoreTreeState(tree);
        } else if (tree == 7) {
            this.restoreTreeState(16384);
            this.restoreTreeState(131072);
        }
    }

    private void restoreTreeState(int tree) {
        Object[] expandedElements = this.getExpandedElements(tree);
        ShapeInfo[] shapes = this.mLinkPainter.getAllShapeInfoObjects(tree);
        Object[] selectedElements = this.getSelectedItems(tree);
        this.reloadTree(tree);
        this.setExpandedElements(expandedElements, tree);
        this.restoreIndependentShapes(shapes);
        this.mLinkPainter.setSelection(selectedElements, tree, true);
    }

    public void setDragType(int mDirection) {
        this.mDragType = mDirection;
    }

    private void restoreIndependentShapes(ShapeInfo[] shapes) {
        int i = 0;
        while (i < shapes.length) {
            this.createShape(shapes[i].getData(), shapes[i].getShape().getEnframeStyle(), shapes[i].getShape().IncludeChildren, shapes[i].getTree());
            ++i;
        }
    }

    public int getDragType() {
        return this.mDragType;
    }

    public Object[] getAllIndependentFrames(int tree) {
        return this.mLinkPainter.getAllIndependentFrames(tree);
    }

    public void setVisibleExtensionLine(boolean visible) {
        this.mLinkPainter.setVisibleExtensionLine(visible);
    }

    public void addMenuListener(IMenuListener menuListener, int tree) {
        int both = 147456;
        switch (tree) {
            case 16384: {
                this.mSrcMenuListener = menuListener;
                break;
            }
            case 131072: {
                this.mTargetMenuListener = menuListener;
                break;
            }
            case 147456: {
                this.mSrcMenuListener = menuListener;
                this.mTargetMenuListener = menuListener;
                break;
            }
            case 11: {
                this.mCanvasMenuListener = menuListener;
            }
        }
    }

    public Object[] getSelectedItems(int tree) {
        switch (tree) {
            case 16384: {
                return this.getSelectedItems(this.mSourceTreeViewer);
            }
            case 131072: {
                return this.getSelectedItems(this.mTargetTreeViewer);
            }
        }
        return null;
    }

    private Object[] getSelectedItems(TreeViewer viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        Iterator iterator = selection.iterator();
        Vector<Object> selectedItems = new Vector<Object>();
        while (iterator.hasNext()) {
            TreeNode element = (TreeNode)iterator.next();
            selectedItems.add(element.getData());
        }
        return selectedItems.toArray();
    }

    public void deleteShape(Object node, int tree) {
        this.mLinkPainter.deleteShape(node, tree);
    }

    public void createShape(Object node, int shape, boolean includeChildren, int tree) {
        this.mLinkPainter.createShape(shape, node, includeChildren, tree);
    }

    public Object[] getSelectedFrames(int tree, int filter) {
        return this.mLinkPainter.getSelectedFrames(tree, filter);
    }

    public Object[] getInternalSelectedItems(int tree) {
        TreeViewer viewer;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        } else {
            return new Object[0];
        }
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        Iterator iterator = selection.iterator();
        Vector<Object> selectedItems = new Vector<Object>();
        while (iterator.hasNext()) {
            TreeNode element = (TreeNode)iterator.next();
            selectedItems.add(element.getData());
        }
        return selectedItems.toArray();
    }

    public void setDragCursorType(int direction, int type) {
        switch (direction) {
            case 0x2000000: {
                this.mLeftDragType = type;
                break;
            }
            case 0x4000000: {
                this.mRightDragType = type;
            }
        }
    }

    public int getDragCursorType(int direction) {
        int type = 2;
        switch (direction) {
            case 0x2000000: {
                type = this.mLeftDragType;
                break;
            }
            case 0x4000000: {
                type = this.mRightDragType;
            }
        }
        return type;
    }

    public void setSelection(Object node, int tree) {
        this.mLinkPainter.setSelection(node, tree, false);
    }

    public void setSelection(Object node, int tree, boolean reveal) {
        this.mLinkPainter.setSelection(node, tree, reveal);
    }

    public void clearAllSelection(int tree) {
        TreeViewer viewer = null;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        } else {
            return;
        }
        viewer.getTree().deselectAll();
        this.mLinkPainter.clearAllSelection();
    }

    public void clearAllSelection() {
        this.clearAllSelection(16384);
        this.clearAllSelection(131072);
    }

    public void setDrawShapesOfHiddenNodes(boolean isVisible) {
        this.mLinkPainter.setDrawShapesOfHiddenNodes(isVisible);
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        TreeNode lastSelectedItem;

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            TreeViewer viewer = (TreeViewer)event.getSource();
            if (this.lastSelectedItem == null || selection.size() == 1) {
                this.lastSelectedItem = (TreeNode)selection.getFirstElement();
                return;
            }
            if (selection.size() > 1) {
                Iterator iter = selection.iterator();
                TreeItem[] selectedItems = new TreeItem[1];
                while (iter.hasNext()) {
                    TreeItem item;
                    Object element = iter.next();
                    if (element.equals(this.lastSelectedItem) || null == (item = (TreeItem)viewer.testFindItem(element))) continue;
                    selectedItems[0] = item;
                    viewer.getTree().setSelection(selectedItems);
                    this.lastSelectedItem = (TreeNode)element;
                    break;
                }
            }
        }
    }
}

