/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent.provider;

import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeMappingContentProvider
implements ITreeContentProvider {
    private Object mInput = null;
    private ITreeContentProvider mExternalContentProvider;
    private int tree;

    public TreeMappingContentProvider(int tree) {
        this.tree = tree;
    }

    public Object[] getChildren(Object parentElement) {
        TreeNode node = (TreeNode)parentElement;
        Vector<TreeNode> children = new Vector<TreeNode>();
        if (null != this.mExternalContentProvider) {
            Object[] externalChildren = this.mExternalContentProvider.getChildren(node.getData());
            int i = 0;
            while (i < externalChildren.length) {
                Object externalChild = externalChildren[i];
                TreeNode childNode = new TreeNode(externalChild, externalChild, node, this.tree);
                children.add(childNode);
                ++i;
            }
            return children.toArray();
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        TreeNode node = (TreeNode)element;
        return node.getParent();
    }

    public boolean hasChildren(Object element) {
        TreeNode node = (TreeNode)element;
        if (null != this.mExternalContentProvider) {
            return this.mExternalContentProvider.hasChildren(node.getData());
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (null != this.mExternalContentProvider) {
            Object[] externalElements = this.mExternalContentProvider.getElements(inputElement);
            Object[] elements = new Object[externalElements.length];
            int i = 0;
            while (i < externalElements.length) {
                TreeNode node = new TreeNode(externalElements[i], externalElements[i], null, this.tree);
                elements[i] = node;
                ++i;
            }
            return elements;
        }
        if (null != this.mInput) {
            return this.getChildren(inputElement);
        }
        this.mInput = inputElement;
        Object[] children = new Object[]{};
        if (inputElement instanceof Collection) {
            Collection col = (Collection)inputElement;
            Object[] elements = new Object[col.size()];
            int i = 0;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                TreeNode node = null;
                node = new TreeNode(element, element, null, this.tree);
                elements[i++] = node;
            }
            return elements;
        }
        if (inputElement instanceof Object[]) {
            Object[] objs = (Object[])inputElement;
            Object[] elements = new Object[objs.length];
            int i = 0;
            while (i < objs.length) {
                Object element = objs[i];
                TreeNode node = null;
                node = new TreeNode(element, element, null, this.tree);
                elements[i] = node;
                ++i;
            }
            return elements;
        }
        children = new Object[1];
        TreeNode node = new TreeNode(this.mInput, this.mInput, null, this.tree);
        children[0] = node;
        return children;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (null != this.mExternalContentProvider) {
            this.mExternalContentProvider.inputChanged(viewer, oldInput, newInput);
        }
    }

    public ITreeContentProvider getExternalContentProvider() {
        return this.mExternalContentProvider;
    }

    public void setExternalContentProvider(ITreeContentProvider mExternalContentProvider) {
        this.mExternalContentProvider = mExternalContentProvider;
    }

    public int getTree() {
        return this.tree;
    }

    public void setTree(int tree) {
        this.tree = tree;
    }
}

