/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent.listener;

import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.listener.LinkSelectionListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.MappingSelectionListener;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;

public class CompositeSelectionListener
implements ISelectionChangedListener,
LinkSelectionListener {
    private TreeViewer mSourceTreeViewer;
    private TreeViewer mTargetTreeViewer;
    private MappingSelectionListener mExternalSelectionListener;

    public CompositeSelectionListener(TreeViewer sourceTreeViewer, TreeViewer targetTreeViewer) {
        this.mSourceTreeViewer = sourceTreeViewer;
        this.mTargetTreeViewer = targetTreeViewer;
    }

    public MappingSelectionListener getExternalSelectionListener() {
        return this.mExternalSelectionListener;
    }

    public void setExternalSelectionListener(MappingSelectionListener selectionListener) {
        this.mExternalSelectionListener = selectionListener;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        TreeNode node = (TreeNode)selection.getFirstElement();
        if (null != this.mExternalSelectionListener) {
            this.mExternalSelectionListener.nodeSelected(node);
        }
    }

    public void linkSelected(MappingObject mappingObject) {
        if (null != this.mExternalSelectionListener) {
            this.mExternalSelectionListener.linkSelected(mappingObject);
        }
    }
}

