/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent;

import com.sap.ide.tools.core.treemappingcomponent.ImageRegistry;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TreeMappingPlugin
extends AbstractUIPlugin {
    private static TreeMappingPlugin plugin;
    private ResourceBundle resourceBundle;
    private static ImageRegistry mImageRegistry;

    public TreeMappingPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("tree_mapping_service.TreeMappingPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static TreeMappingPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = TreeMappingPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static Image getImage(String imageName) {
        Image img = mImageRegistry.get(imageName);
        if (null != img) {
            return img;
        }
        ImageDescriptor imageDesc = null;
        Object imageDes = null;
        IPluginDescriptor pluginDescriptor = null;
        pluginDescriptor = TreeMappingPlugin.getDefault().getDescriptor();
        URL pluginUrl = pluginDescriptor.getInstallURL();
        URL imageUrl = null;
        try {
            imageUrl = new URL(pluginUrl, imageName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        imageDesc = ImageDescriptor.createFromURL((URL)imageUrl);
        img = imageDesc.createImage();
        mImageRegistry.put(imageName, img);
        return img;
    }

    static {
        mImageRegistry = new ImageRegistry();
    }
}

