/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent;

import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import java.util.Vector;
import org.eclipse.swt.widgets.TreeItem;

class MappingContainer {
    private Vector mMappingObjects = new Vector();
    private TreeMappingListener mMappingListener;
    private TreeMappingValidator mValidator;

    public void add(MappingObject mappingObj, boolean fireEvent, boolean internalRepaint) {
        if (this.mappingExists(mappingObj)) {
            return;
        }
        this.mMappingObjects.add(mappingObj);
        if (null != this.mMappingListener && fireEvent && !internalRepaint) {
            this.mMappingListener.mappingCreated(mappingObj);
        }
    }

    public boolean mappingExists(MappingObject mappingObj) {
        return this.mappingExists(mappingObj.getSourceNode().getData(), mappingObj.getTargetNode().getData());
    }

    public void replace(MappingObject oldMappingObj, MappingObject newMappingObj) {
        int i = 0;
        while (i < this.mMappingObjects.size()) {
            MappingObject mapObj = (MappingObject)this.mMappingObjects.get(i);
            if (mapObj.equals(oldMappingObj)) {
                boolean allowModify = true;
                if (null != this.mValidator) {
                    allowModify = this.mValidator.allowModify(oldMappingObj.getSourceNode().getData(), oldMappingObj.getTargetNode().getData(), newMappingObj.getSourceNode().getData(), newMappingObj.getTargetNode().getData());
                }
                if (allowModify) {
                    this.mMappingObjects.set(i, newMappingObj);
                }
                if (null == this.mMappingListener) break;
                this.mMappingListener.mappingModified(oldMappingObj, newMappingObj);
                break;
            }
            ++i;
        }
    }

    public void remove(MappingObject mappingObj, boolean firePostDeleteEvent) {
        int deleteIndex = -1;
        int i = 0;
        while (i < this.mMappingObjects.size()) {
            MappingObject mapObj = (MappingObject)this.mMappingObjects.get(i);
            if (mapObj.equals(mappingObj)) {
                deleteIndex = i;
                break;
            }
            ++i;
        }
        if (null != this.mValidator && deleteIndex > -1 && !this.mValidator.allowDelete((MappingObject)this.mMappingObjects.get(deleteIndex))) {
            return;
        }
        if (deleteIndex > -1) {
            this.mMappingObjects.remove(deleteIndex);
            if (null != this.mMappingListener && firePostDeleteEvent) {
                this.mMappingListener.mappingDeleted(mappingObj);
            }
        }
    }

    public boolean mappingExists(Object source, Object target) {
        if (null == source || null == target) {
            return false;
        }
        int i = 0;
        while (i < this.mMappingObjects.size()) {
            MappingObject mapObj = (MappingObject)this.mMappingObjects.get(i);
            try {
                if (mapObj.getSourceNode().getData().equals(source) && mapObj.getTargetNode().getData().equals(target)) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public int size() {
        return this.mMappingObjects.size();
    }

    public MappingObject get(int index) {
        MappingObject mapObj = (MappingObject)this.mMappingObjects.get(index);
        if (null != mapObj) {
            return mapObj;
        }
        return null;
    }

    public MappingObject[] getMappings() {
        MappingObject[] mappingObjs = new MappingObject[this.size()];
        int i = 0;
        while (i < this.mMappingObjects.size()) {
            mappingObjs[i] = (MappingObject)this.mMappingObjects.get(i);
            ++i;
        }
        return mappingObjs;
    }

    public void clearAllSelection() {
        int i = 0;
        while (i < this.mMappingObjects.size()) {
            MappingObject mapObj = (MappingObject)this.mMappingObjects.get(i);
            mapObj.setIsSelected(false);
            ++i;
        }
    }

    public void setMappingListener(TreeMappingListener mappingListener) {
        this.mMappingListener = mappingListener;
    }

    public void setValidator(TreeMappingValidator mValidator) {
        this.mValidator = mValidator;
    }

    class TreeItemInfo {
        TreeItem treeItem;
        int level = 0;

        public TreeItemInfo(TreeItem item, int level) {
            this.treeItem = item;
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public TreeItem getTreeItem() {
            return this.treeItem;
        }

        public void setLevel(int i) {
            this.level = i;
        }

        public void setTreeItem(TreeItem item) {
            this.treeItem = item;
        }
    }
}

