/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.treemappingcomponent;

import com.sap.ide.tools.core.treemappingcomponent.MappingContainer;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingPlugin;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.tools.core.treemappingcomponent.cache.CompositeLinkCache;
import com.sap.ide.tools.core.treemappingcomponent.cache.LinkCache;
import com.sap.ide.tools.core.treemappingcomponent.cache.ShapeCache;
import com.sap.ide.tools.core.treemappingcomponent.decorator.ExtendedLinkDecorator;
import com.sap.ide.tools.core.treemappingcomponent.decorator.LinkDecorator;
import com.sap.ide.tools.core.treemappingcomponent.drawing.CompositePaintableLink;
import com.sap.ide.tools.core.treemappingcomponent.drawing.PaintableLink;
import com.sap.ide.tools.core.treemappingcomponent.drawing.PaintableObject;
import com.sap.ide.tools.core.treemappingcomponent.drawing.PaintableShape;
import com.sap.ide.tools.core.treemappingcomponent.drawing.ShapeInfo;
import com.sap.ide.tools.core.treemappingcomponent.filter.DrawingAreaFilter;
import com.sap.ide.tools.core.treemappingcomponent.listener.LinkSelectionListener;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import com.sap.ide.tools.core.treemappingcomponent.provider.TreeMappingContentProvider;
import com.sap.ide.tools.core.treemappingcomponent.tree.EnframeStyles;
import com.sap.ide.tools.core.treemappingcomponent.tree.TreeNode;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LinkPainter
extends SelectionAdapter
implements PaintListener,
ITreeViewerListener {
    private boolean mAllowDrawingInvisibleNodes = false;
    private boolean mShowEntensionLine;
    private Vector mMatchedNodes;
    private DrawingAreaFilter mDrawingAreaFilter;
    private boolean mFireDeleteEvent = true;
    private boolean mTopFound;
    private TreeNode mTopData;
    private MappingObject mSelectedObject;
    private LinkDecorator mLinkDecorator;
    private Canvas mDrawingArea;
    private TreeViewer mSourceTreeViewer;
    private TreeViewer mTargetTreeViewer;
    private MappingContainer mLinks;
    private Vector mCachedLinks;
    private Vector mCachedShapes;
    private Vector mShapes = new Vector();
    private GC mGC;
    private TreeMappingListener mMappingListener;
    private Display mDisplay;
    private LinkSelectionListener mLinkSelectionListener;
    private CanvasMouseListener mMouseListener;
    private CanvasKeyListener mKeyListener;
    private boolean mSelectionDrawn = false;
    private boolean mFound;
    private boolean mEnableContextMenu = true;
    private int leftVerticalScrollCorrection = 0;
    private int rightVerticalScrollCorrection = 0;
    private int leftScrollCount = 0;
    private int rightScrollCount = 0;
    private boolean isLeftExpanded = false;
    private boolean isRightExpanded = false;
    private int leftVerticalSelection = 0;
    private int rightVerticalSelection = 0;
    private boolean mFireEvent = true;
    private boolean mInternalRepaint = true;
    private int mParents = 0;
    private Vector mPoints = new Vector();
    private int mDeltaY = 9;
    private Color mDefaultForeGroundColor = Display.getDefault().getSystemColor(2);
    private Color mDefaultSelectedForeGroundColor = Display.getDefault().getSystemColor(3);
    private boolean mCanvasSelected = false;

    public LinkPainter(Canvas drawingArea, TreeViewer source, TreeViewer target) {
        this.mDrawingArea = drawingArea;
        this.mSourceTreeViewer = source;
        this.mTargetTreeViewer = target;
        this.mLinks = new MappingContainer();
        this.mCachedLinks = new Vector();
        this.mCachedShapes = new Vector();
        this.mMouseListener = new CanvasMouseListener();
        this.mKeyListener = new CanvasKeyListener();
        this.mDrawingArea.addPaintListener((PaintListener)this);
        this.mDrawingArea.addMouseListener((MouseListener)this.mMouseListener);
        this.mDrawingArea.addKeyListener((KeyListener)this.mKeyListener);
        this.mSourceTreeViewer.addTreeListener((ITreeViewerListener)this);
        this.mTargetTreeViewer.addTreeListener((ITreeViewerListener)this);
        this.mSourceTreeViewer.getTree().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!LinkPainter.this.mShowEntensionLine) {
                    return;
                }
                GC gc = e.gc;
                gc.setLineStyle(3);
                int i = 0;
                while (i < LinkPainter.this.mPoints.size()) {
                    CompositePaintableLink cpLink;
                    PaintableObject obj = (PaintableObject)LinkPainter.this.mPoints.get(i);
                    if (obj instanceof PaintableLink) {
                        LinkPainter.this.paintLineOnTree(LinkPainter.this.mDeltaY, LinkPainter.this.mSourceTreeViewer, 16384, gc, (PaintableLink)obj);
                    } else if (obj instanceof CompositePaintableLink && null != (cpLink = (CompositePaintableLink)obj).getSourceShape() && cpLink.getSourceShape().getEnframeStyle() == EnframeStyles.RECTANGLE && null != cpLink.getSourceShape() && !cpLink.getSourceShape().TreeNode.isDisposed() && null != cpLink.getTargetShape() && !cpLink.getTargetShape().TreeNode.isDisposed()) {
                        int bkStyle = gc.getLineStyle();
                        Color bkColor = gc.getForeground();
                        gc.setLineStyle(1);
                        gc.setForeground(cpLink.getLink().LineColor);
                        Rectangle rect = LinkPainter.this.getEnclosedRectangle(cpLink.getSourceShape());
                        gc.drawRectangle(rect);
                        cpLink.getSourceShape().EnclosingRectangle = rect;
                        int x2 = ((LinkPainter)LinkPainter.this).mSourceTreeViewer.getTree().getBounds().x + ((LinkPainter)LinkPainter.this).mSourceTreeViewer.getTree().getBounds().width;
                        int y2 = rect.y + rect.height / 2;
                        gc.drawLine(rect.x + rect.width, y2, x2, y2);
                        gc.setForeground(bkColor);
                        gc.setLineStyle(bkStyle);
                    }
                    ++i;
                }
                LinkPainter.this.drawIndependentShapes(16384, LinkPainter.this.mSourceTreeViewer, gc);
            }
        });
        this.mTargetTreeViewer.getTree().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!LinkPainter.this.mShowEntensionLine) {
                    return;
                }
                Image imgArrow = TreeMappingPlugin.getImage("resources/images/links/arrow.gif");
                GC gc = e.gc;
                gc.setLineStyle(3);
                int i = 0;
                while (i < LinkPainter.this.mPoints.size()) {
                    CompositePaintableLink cpLink;
                    PaintableObject obj = (PaintableObject)LinkPainter.this.mPoints.get(i);
                    if (obj instanceof PaintableLink) {
                        TreeItem item;
                        PaintableLink link = (PaintableLink)obj;
                        gc.setForeground(link.LineColor);
                        if (LinkPainter.this.setLineProperties(gc, link, 131072) && !(item = link.Target).isDisposed()) {
                            int targetX = item.getBounds().x - 33;
                            if (item.getItemCount() > 0) {
                                targetX -= 5;
                            }
                            gc.drawLine(((LinkPainter)LinkPainter.this).mSourceTreeViewer.getTree().getBounds().x, item.getBounds().y + LinkPainter.this.mDeltaY - 1, targetX, item.getBounds().y + LinkPainter.this.mDeltaY - 1);
                        }
                    } else if (obj instanceof CompositePaintableLink && null != (cpLink = (CompositePaintableLink)obj).getTargetShape() && cpLink.getTargetShape().getEnframeStyle() == EnframeStyles.RECTANGLE && null != cpLink.getSourceShape() && !cpLink.getSourceShape().TreeNode.isDisposed() && null != cpLink.getTargetShape() && !cpLink.getTargetShape().TreeNode.isDisposed()) {
                        Rectangle rect;
                        int bkLineStyle = gc.getLineStyle();
                        Color bkColor = gc.getForeground();
                        gc.setLineStyle(1);
                        gc.setForeground(cpLink.getLink().LineColor);
                        cpLink.getTargetShape().EnclosingRectangle = rect = LinkPainter.this.getEnclosedRectangle(cpLink.getTargetShape());
                        gc.drawRectangle(rect);
                        int x1 = rect.x;
                        int x2 = ((LinkPainter)LinkPainter.this).mSourceTreeViewer.getTree().getBounds().x;
                        int y2 = rect.y + rect.height / 2 + 1;
                        if (!cpLink.getTargetShape().TreeNode.getExpanded()) {
                            x1 -= 14;
                        } else if (!cpLink.getTargetShape().IncludeChildren) {
                            x1 -= 14;
                        }
                        gc.drawLine(x1, y2, x2, y2);
                        gc.setForeground(bkColor);
                        gc.setLineStyle(bkLineStyle);
                    }
                    ++i;
                }
                LinkPainter.this.drawIndependentShapes(131072, LinkPainter.this.mTargetTreeViewer, gc);
            }
        });
        this.mTargetTreeViewer.getTree().getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int thumb = LinkPainter.this.mTargetTreeViewer.getTree().getVerticalBar().getThumb();
                if (e.detail == 0x1000002) {
                    if (thumb + LinkPainter.this.rightScrollCount < LinkPainter.this.mTargetTreeViewer.getTree().getVerticalBar().getMaximum()) {
                        LinkPainter.this.rightScrollCount++;
                        LinkPainter.this.rightVerticalScrollCorrection--;
                    }
                } else if (e.detail == 0x1000001) {
                    if (LinkPainter.this.rightScrollCount > LinkPainter.this.mTargetTreeViewer.getTree().getVerticalBar().getMinimum()) {
                        LinkPainter.this.rightScrollCount--;
                        LinkPainter.this.rightVerticalScrollCorrection++;
                    }
                } else if (e.detail == 1) {
                    int sel = LinkPainter.this.mTargetTreeViewer.getTree().getVerticalBar().getSelection();
                    if (sel > LinkPainter.this.rightVerticalSelection) {
                        if (thumb + LinkPainter.this.rightScrollCount < LinkPainter.this.mTargetTreeViewer.getTree().getVerticalBar().getMaximum()) {
                            LinkPainter.this.rightScrollCount++;
                            LinkPainter.this.rightVerticalScrollCorrection--;
                        }
                    } else if (sel < LinkPainter.this.rightVerticalSelection && LinkPainter.this.rightScrollCount > LinkPainter.this.mTargetTreeViewer.getTree().getVerticalBar().getMinimum()) {
                        LinkPainter.this.rightScrollCount--;
                        LinkPainter.this.rightVerticalScrollCorrection++;
                    }
                    LinkPainter.this.rightVerticalSelection = sel;
                }
                LinkPainter.this.mDrawingArea.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.mSourceTreeViewer.getTree().getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinkPainter.this.mDrawingArea.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.mTargetTreeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LinkPainter.this.mMouseListener.reset();
                LinkPainter.this.updateMappingObjectSelection(131072, e.x, e.y);
                LinkPainter.this.mDrawingArea.redraw();
            }
        });
        this.mSourceTreeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                LinkPainter.this.mMouseListener.reset();
                LinkPainter.this.updateMappingObjectSelection(16384, e.x, e.y);
                LinkPainter.this.mDrawingArea.redraw();
            }
        });
    }

    protected void drawIndependentShapes(int tree, TreeViewer treeViewer, GC gc) {
        Vector<ShapeCache> toBeRemovedItems = new Vector<ShapeCache>();
        int i = 0;
        while (i < this.mCachedShapes.size()) {
            TreeItem[] items;
            ShapeCache shapeCache = (ShapeCache)this.mCachedShapes.get(i);
            if (null != shapeCache.getSource() && shapeCache.getTree() == tree && null != (items = this.getAllTreeItemsFromData(treeViewer, shapeCache.getSource())) && items.length >= 1) {
                PaintableShape paintableShape = new PaintableShape(shapeCache.getShape());
                paintableShape.IncludeChildren = shapeCache.isIncludeChildren();
                paintableShape.TreeNode = items[0];
                paintableShape.setSelected(shapeCache.isSelected());
                this.mShapes.add(paintableShape);
                toBeRemovedItems.add(shapeCache);
            }
            ++i;
        }
        this.mCachedShapes.removeAll(toBeRemovedItems);
        int i2 = 0;
        while (i2 < this.mShapes.size()) {
            PaintableShape shape = (PaintableShape)this.mShapes.get(i2);
            if (null != shape.TreeNode && !shape.TreeNode.isDisposed() && shape.TreeNode.getParent().equals(treeViewer.getTree())) {
                int bkLineStyle = gc.getLineStyle();
                Color bkColor = gc.getForeground();
                gc.setLineStyle(1);
                Object content = null;
                if (shape != null && shape.TreeNode != null && shape.TreeNode.getData() != null && shape.TreeNode.getData() instanceof TreeNode) {
                    content = ((TreeNode)shape.TreeNode.getData()).getData();
                }
                if (shape.isSelected()) {
                    if (this.mLinkDecorator != null) {
                        gc.setForeground(this.mLinkDecorator.getSelectedLinkColor(content, null));
                    } else {
                        gc.setForeground(this.mDefaultSelectedForeGroundColor);
                    }
                } else if (this.mLinkDecorator != null) {
                    gc.setForeground(this.mLinkDecorator.getLinkColor(content, null));
                } else {
                    gc.setForeground(this.mDefaultForeGroundColor);
                }
                Rectangle rectangle = this.getEnclosedRectangle(shape);
                gc.drawRectangle(rectangle);
                shape.EnclosingRectangle = rectangle;
                gc.setLineStyle(bkLineStyle);
                gc.setForeground(bkColor);
            }
            ++i2;
        }
    }

    protected Rectangle getEnclosedRectangle(PaintableShape shape) {
        int x = shape.TreeNode.getBounds().x;
        int y = shape.TreeNode.getBounds().y;
        int width = shape.TreeNode.getBounds().width;
        boolean hasImage = false;
        if (shape.TreeNode.getImage() != null) {
            hasImage = true;
            x -= shape.TreeNode.getImage().getBounds().width + 5;
        }
        if (!shape.IncludeChildren) {
            if (hasImage) {
                width += shape.TreeNode.getImage().getBounds().width + 5;
            }
            return new Rectangle(x, y, width, shape.TreeNode.getBounds().height - 2);
        }
        TreeItem lastChild = this.getLastChildItem(shape.TreeNode);
        TreeItem deepestChild = this.getEnclosingRectangleWidth(shape.TreeNode, shape.TreeNode);
        width = deepestChild.getBounds().x + deepestChild.getBounds().width - x;
        int height = lastChild.getBounds().y + lastChild.getBounds().height - y - 2;
        return new Rectangle(x, y, width, height);
    }

    private boolean setLineProperties(GC gc, PaintableLink obj, int tree) {
        TreeItem item = obj.Source;
        if (obj.Source.isDisposed() || obj.Target.isDisposed()) {
            return false;
        }
        Color col = obj.LineColor;
        TreeNode srcNode = (TreeNode)obj.Source.getData();
        TreeNode tgtNode = (TreeNode)obj.Target.getData();
        if (null == srcNode || null == tgtNode) {
            return false;
        }
        if (null != this.mLinkDecorator) {
            if (this.mLinkDecorator instanceof ExtendedLinkDecorator) {
                ExtendedLinkDecorator exLinkDecorator = (ExtendedLinkDecorator)this.mLinkDecorator;
                col = exLinkDecorator.getExtendedLinkColor(srcNode.getData(), tgtNode.getData(), obj.isSelected(), tree);
                int style = exLinkDecorator.getExtendedLinkType(srcNode.getData(), tgtNode.getData(), obj.isSelected(), tree);
                gc.setLineStyle(style);
            }
            if (null == col) {
                col = obj.isSelected() ? this.mLinkDecorator.getSelectedLinkColor(srcNode.getData(), tgtNode.getData()) : this.mLinkDecorator.getLinkColor(srcNode.getData(), tgtNode.getData());
            }
        }
        gc.setForeground(col);
        return true;
    }

    private void paintLineOnTree(int deltaY, TreeViewer treeViewer, int tree, GC gc, PaintableLink obj) {
        Color bkColor = gc.getForeground();
        TreeItem item = obj.Source;
        if (!this.setLineProperties(gc, obj, tree)) {
            return;
        }
        int lineX1 = item.getBounds().x + item.getBounds().width;
        int lineY1 = item.getBounds().y + deltaY - 1;
        int lineX2 = this.mSourceTreeViewer.getTree().getBounds().x + this.mSourceTreeViewer.getTree().getBounds().width;
        int lineY2 = item.getBounds().y + deltaY - 1;
        gc.drawLine(lineX1, lineY1, lineX2, lineY2);
        gc.setForeground(bkColor);
    }

    protected void updateMappingObjectSelection(int tree, int x, int y) {
        Iterator iter = ((AbstractList)this.mPoints).iterator();
        boolean refreshrequired = false;
        this.mLinks.clearAllSelection();
        this.mSelectionDrawn = false;
        PaintableObject selectedObj = null;
        while (iter.hasNext()) {
            PaintableObject element = (PaintableObject)iter.next();
            if (!(element instanceof CompositePaintableLink)) continue;
            CompositePaintableLink cpLink = (CompositePaintableLink)element;
            PaintableShape shape = null;
            if (tree == 16384) {
                shape = cpLink.getSourceShape();
            } else if (tree == 131072) {
                shape = cpLink.getTargetShape();
            }
            if (null == shape.EnclosingRectangle || shape.getEnframeStyle() != EnframeStyles.RECTANGLE || shape.TreeNode.isDisposed()) continue;
            if (!this.getEnclosedRectangle(shape).contains(x, y)) {
                cpLink.setSelected(false);
                continue;
            }
            cpLink.setSelected(true);
            selectedObj = element;
            break;
        }
        if (null != selectedObj) {
            this.mPoints.remove(selectedObj);
            this.mPoints.add(selectedObj);
        }
        int i = 0;
        while (i < this.mShapes.size()) {
            PaintableShape shape = (PaintableShape)this.mShapes.get(i);
            if (!shape.TreeNode.isDisposed()) {
                if (tree == 16384 && shape.TreeNode.getParent().equals(this.mSourceTreeViewer.getTree()) || tree == 131072 && shape.TreeNode.getParent().equals(this.mTargetTreeViewer.getTree())) {
                    shape.setSelected(this.getEnclosedRectangle(shape).contains(x, y));
                } else {
                    shape.setSelected(false);
                }
            }
            ++i;
        }
    }

    private TreeItem getLastChildItem(TreeItem item) {
        if (item.isDisposed()) {
            return null;
        }
        if (item.getItemCount() == 0 || !item.getExpanded()) {
            return item;
        }
        TreeItem[] treeItems = item.getItems();
        TreeItem lastChild = treeItems[treeItems.length - 1];
        return this.getLastChildItem(lastChild);
    }

    private TreeItem getEnclosingRectangleWidth(TreeItem item, TreeItem deepestChild) {
        TreeItem currentItem = item;
        if (!item.getExpanded()) {
            return currentItem;
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            currentItem = items[i];
            if (currentItem.getBounds().x + currentItem.getBounds().width > deepestChild.getBounds().x + deepestChild.getBounds().width) {
                deepestChild = currentItem;
            }
            if (currentItem.getExpanded()) {
                deepestChild = this.getEnclosingRectangleWidth(currentItem, deepestChild);
            }
            ++i;
        }
        return deepestChild;
    }

    public MappingObject[] getMappings() {
        return this.mLinks.getMappings();
    }

    public void createLink(Object source, Object target) {
        MappingObject mappingObj = this.getExistingMapping(source, target);
        if (null == mappingObj) {
            TreeNode srcNode = this.getNodeFromData(this.mSourceTreeViewer, source);
            TreeNode targetNode = this.getNodeFromData(this.mTargetTreeViewer, target);
            if (null != srcNode && null != targetNode) {
                MappingObject newMapObj = new MappingObject(srcNode, targetNode);
                newMapObj.createLink();
                this.mLinks.add(newMapObj, this.mFireEvent, this.mInternalRepaint);
                this.mDrawingArea.redraw();
            } else if (!this.linkCached(source, target)) {
                LinkCache cache = new LinkCache();
                cache.setSource(source);
                cache.setTarget(target);
                this.mCachedLinks.add(cache);
                if (null != this.mMappingListener && this.mFireEvent && !this.mInternalRepaint) {
                    this.mMappingListener.mappingCreated(mappingObj);
                }
            }
        }
    }

    private boolean linkCached(Object source, Object target) {
        int i = 0;
        while (i < this.mCachedLinks.size()) {
            LinkCache cache = (LinkCache)this.mCachedLinks.get(i);
            if (null != source && null != target && source.equals(cache.getSource()) && target.equals(cache.getTarget())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private MappingObject getExistingMapping(Object source, Object target) {
        int i = 0;
        while (i < this.mLinks.size()) {
            MappingObject mapObj = this.mLinks.get(i);
            if (mapObj.getSourceNode().getData().equals(source) && mapObj.getTargetNode().getData().equals(target)) {
                return mapObj;
            }
            ++i;
        }
        return null;
    }

    private boolean drawLink(MappingObject mappingObject) {
        boolean painted = false;
        try {
            TreeItem[] srcNodes = this.getAllTreeItemsFromData(this.mSourceTreeViewer, mappingObject.getSourceNode().getData());
            TreeItem[] targetNodes = this.getAllTreeItemsFromData(this.mTargetTreeViewer, mappingObject.getTargetNode().getData());
            int srcNodePos = 0;
            int targetNodePos = 0;
            int i = 0;
            while (i < srcNodes.length) {
                block12: {
                    if (null != srcNodes[i].getParentItem() && !this.isParentExpanded(srcNodes[i])) break block12;
                    int j = 0;
                    while (j < targetNodes.length) {
                        block13: {
                            block14: {
                                if (null != targetNodes[i].getParentItem() && !this.isParentExpanded(targetNodes[i])) break block13;
                                try {
                                    if (!this.allowDrawing((TreeNode)srcNodes[i].getData(), (TreeNode)targetNodes[j].getData())) {
                                    }
                                }
                                catch (Exception ex) {}
                                break block13;
                                srcNodePos = srcNodes[i].getBounds().y;
                                targetNodePos = targetNodes[j].getBounds().y;
                                if (this.allowDrawingInvisibleNodes()) break block14;
                                Point ptSrc = new Point(srcNodes[i].getBounds().x, srcNodes[i].getBounds().y);
                                TreeItem checkItem = this.mSourceTreeViewer.getTree().getItem(ptSrc);
                                if (!srcNodes[i].equals(checkItem)) break block13;
                                Point ptTarget = new Point(targetNodes[j].getBounds().x, targetNodes[j].getBounds().y);
                                checkItem = this.mTargetTreeViewer.getTree().getItem(ptTarget);
                                if (!targetNodes[j].equals(checkItem) || srcNodePos < 0 || targetNodePos < 0) break block13;
                            }
                            this.paintLink(srcNodePos, targetNodePos, mappingObject, srcNodes[i], targetNodes[j]);
                            if (mappingObject.isSelected() && null != this.mLinkSelectionListener && this.mCanvasSelected) {
                                this.mLinkSelectionListener.linkSelected(mappingObject);
                                this.mCanvasSelected = false;
                            }
                            painted = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            painted = false;
        }
        return painted;
    }

    private boolean isParentExpanded(TreeItem item) {
        if (null == item.getParentItem()) {
            return item.getExpanded();
        }
        if (!item.getParentItem().getExpanded()) {
            return false;
        }
        return this.isParentExpanded(item.getParentItem());
    }

    private boolean allowDrawingInvisibleNodes() {
        return this.mAllowDrawingInvisibleNodes;
    }

    private void updateTreeSelection(MappingObject mappingObject) {
        TreeItem[] itemsSrc = new TreeItem[]{this.getTreeItemFromNode(this.mSourceTreeViewer.getTree().getItems(), mappingObject.getSourceNode())};
        this.mSourceTreeViewer.getTree().setSelection(itemsSrc);
        this.mSourceTreeViewer.getTree().showSelection();
        TreeItem[] itemsTarget = new TreeItem[]{this.getTreeItemFromNode(this.mTargetTreeViewer.getTree().getItems(), mappingObject.getTargetNode())};
        this.mTargetTreeViewer.getTree().setSelection(itemsTarget);
        this.mTargetTreeViewer.getTree().showSelection();
    }

    private void paintLink(int srcNodePos, int targetNodePos, MappingObject mappingObject, TreeItem srcNode, TreeItem targetNode) {
        int selectedX = this.mMouseListener.getSelectedX();
        int selectedY = this.mMouseListener.getSelectedY();
        int targetY = 0;
        int targetX = 0;
        int sourceY = 0;
        int sourceX = 0;
        boolean updteTreeItemRequired = false;
        Rectangle rect = this.mDrawingArea.getClientArea();
        sourceX = rect.x;
        sourceY = srcNodePos--;
        targetY = targetNodePos;
        targetX = rect.width;
        targetY += this.mDeltaY;
        Color drawColor = null;
        Image imgArrow = TreeMappingPlugin.getImage("resources/images/links/arrow.gif");
        Image imgSelection = TreeMappingPlugin.getImage("resources/images/links/selected.gif");
        Image imgLeftArrow = TreeMappingPlugin.getImage("resources/images/links/leftarrow.gif");
        --targetNodePos;
        PaintableObject paintableObject = mappingObject.getPaintableObject();
        PaintableLink paintableLink = null;
        if (paintableObject instanceof PaintableLink) {
            paintableLink = (PaintableLink)mappingObject.getPaintableObject();
            updteTreeItemRequired = true;
        } else if (paintableObject instanceof CompositePaintableLink) {
            CompositePaintableLink compPaintableLink = (CompositePaintableLink)paintableObject;
            paintableLink = compPaintableLink.getLink();
            compPaintableLink.getSourceShape().TreeNode = srcNode;
            compPaintableLink.getTargetShape().TreeNode = targetNode;
            Rectangle encRect = this.getEnclosedRectangle(compPaintableLink.getSourceShape());
            sourceY = encRect.y + encRect.height / 2 - srcNode.getBounds().height / 2;
            encRect = this.getEnclosedRectangle(compPaintableLink.getTargetShape());
            targetY = encRect.y + encRect.height / 2 + 1;
        }
        paintableLink.Source = srcNode;
        paintableLink.Target = targetNode;
        paintableLink.LineColor = this.mGC.getForeground();
        paintableLink.Style = 1;
        boolean isSelected = paintableObject.isSelected();
        if (selectedY <= sourceY + this.mDeltaY + 2 && selectedY >= sourceY + this.mDeltaY - 2 && selectedX >= sourceX && selectedX <= sourceX + 10) {
            isSelected = true;
        }
        if (!isSelected && selectedY <= targetY + 2 && selectedY >= targetY - 2 && selectedX >= targetX - 14 - 2 && selectedX <= targetX + 2) {
            isSelected = true;
        }
        float slopeValue = (float)(targetY - (sourceY + this.mDeltaY)) / (float)(targetX - 15 - sourceX);
        int offset = (int)((float)targetY - slopeValue * (float)(targetX - 15));
        if (selectedX > 0) {
            int i = -3;
            while (i < 4) {
                if (selectedY == (int)(slopeValue * (float)selectedX + (float)offset + (float)i)) {
                    isSelected = true;
                }
                if (isSelected) break;
                ++i;
            }
        }
        if (isSelected) {
            if (!this.mSelectionDrawn) {
                drawColor = null != this.mLinkDecorator ? this.mLinkDecorator.getSelectedLinkColor(mappingObject.getSourceNode().getData(), mappingObject.getTargetNode().getData()) : Display.getDefault().getSystemColor(3);
                this.mGC.setForeground(drawColor);
            }
            mappingObject.setIsSelected(true);
            if (updteTreeItemRequired) {
                this.updateTreeSelection(srcNode, targetNode);
            }
            this.mSelectionDrawn = true;
        }
        if (!isSelected && null != this.mLinkDecorator) {
            drawColor = this.mLinkDecorator.getLinkColor(mappingObject.getSourceNode().getData(), mappingObject.getTargetNode().getData());
            this.mGC.setForeground(drawColor);
        }
        this.mGC.drawLine(sourceX, sourceY + this.mDeltaY, sourceX + 10, sourceY + this.mDeltaY);
        this.mGC.drawLine(sourceX + 10, sourceY + this.mDeltaY, targetX - 15, targetY);
        this.mGC.drawLine(targetX - 14, targetY, targetX, targetY);
        paintableLink.LineColor = this.mGC.getForeground();
        int style = 3;
        if (null != this.mLinkDecorator) {
            int linkType;
            style = linkType = this.mLinkDecorator.getLinkType(mappingObject.getSourceNode().getData(), mappingObject.getTargetNode().getData(), isSelected);
            switch (linkType) {
                case 1: {
                    this.mGC.drawImage(imgArrow, targetX - 5, targetY - 3);
                    break;
                }
                case 2: {
                    this.mGC.drawImage(imgLeftArrow, 0, sourceY + this.mDeltaY - 3);
                    break;
                }
                case 4: {
                    this.mGC.drawImage(imgArrow, targetX - 5, targetY - 3);
                    this.mGC.drawImage(imgLeftArrow, 0, sourceY + this.mDeltaY - 3);
                    break;
                }
            }
        } else {
            this.mGC.drawImage(imgArrow, targetX - 5, targetY - 3);
        }
        if (paintableObject.isSelected()) {
            this.mPoints.add(paintableObject);
        } else {
            this.mPoints.insertElementAt(paintableObject, 0);
        }
        this.mGC.setForeground(new Color((Device)this.mDisplay, 0, 0, 0));
    }

    private void updateTreeSelection(TreeItem srcNode, TreeItem targetNode) {
        TreeItem[] itemsSrc = new TreeItem[]{srcNode};
        this.mSourceTreeViewer.getTree().setSelection(itemsSrc);
        this.mSourceTreeViewer.getTree().showSelection();
        TreeItem[] itemsTarget = new TreeItem[]{targetNode};
        this.mTargetTreeViewer.getTree().setSelection(itemsTarget);
        this.mTargetTreeViewer.getTree().showSelection();
    }

    private int getNodePos(TreeItem[] nodes, Object source, int pos) {
        int tempPos = 0;
        Object topData = this.mTopData.getData();
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeNode treeNode = (TreeNode)item.getData();
            if (source.equals(treeNode.getData())) {
                this.mFound = true;
            }
            if (treeNode.getData().equals(this.mTopData.getData())) {
                this.mTopFound = true;
            }
            if (this.mTopFound) {
                ++tempPos;
            }
            if (this.mFound) break;
            if (item.getExpanded()) {
                ++this.mParents;
                int retVal = this.getNodePos(item.getItems(), source, pos);
                if (this.mFound) {
                    tempPos += retVal;
                    break;
                }
                tempPos += retVal;
            }
            ++i;
        }
        return tempPos;
    }

    private int[] getNodeY(TreeViewer viewer, Object source) {
        TreeItem[] items = this.getAllTreeItemsFromData(viewer, source);
        TreeItem item = items[0];
        int[] positions = new int[items.length];
        int i = 0;
        while (i < items.length) {
            positions[i] = items[i].getBounds().y;
            ++i;
        }
        return positions;
    }

    private int getSelectedNodePos(TreeItem parentNode, Object source) {
        boolean tempPos = false;
        TreeItem[] items = parentNode.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            TreeNode treeNode = (TreeNode)item.getData();
            if (source.equals(treeNode.getData())) {
                this.mFound = true;
                return i + 1;
            }
            ++i;
        }
        if (items != null) {
            return items.length;
        }
        return -1;
    }

    public void deleteLink(MappingObject mapping) {
        this.mLinks.remove(mapping, this.mFireDeleteEvent);
        TreeItem[] items = this.mTargetTreeViewer.getTree().getSelection();
        this.mDrawingArea.redraw();
    }

    public void editLink(Object oldSource, Object oldTarget, Object newSource, Object newTarget) {
        MappingObject mappingObj = this.getExistingMapping(oldSource, oldTarget);
        if (null == mappingObj) {
            return;
        }
        TreeNode srcNode = this.getNodeFromData(this.mSourceTreeViewer, newSource);
        TreeNode targetNode = this.getNodeFromData(this.mTargetTreeViewer, newTarget);
        if (null != srcNode && null != targetNode) {
            MappingObject newMapObj = new MappingObject(srcNode, targetNode);
            newMapObj.createLink();
            this.mLinks.replace(mappingObj, newMapObj);
            this.mDrawingArea.redraw();
        }
    }

    public void addLinkSelectionListener(LinkSelectionListener listener) {
        this.mLinkSelectionListener = listener;
    }

    private TreeNode getNodeFromData(TreeViewer viewer, Object data) {
        Tree tree = viewer.getTree();
        TreeItem[] roots = tree.getItems();
        return this.getNodeFromData(roots, data);
    }

    private TreeItem[] getAllTreeItemsFromData(TreeViewer viewer, Object data) {
        Tree tree = viewer.getTree();
        TreeItem[] roots = tree.getItems();
        this.mMatchedNodes = new Vector();
        this.getAllTreeItemsFromData(roots, data);
        TreeItem[] items = new TreeItem[this.mMatchedNodes.size()];
        int i = 0;
        while (i < items.length) {
            items[i] = (TreeItem)this.mMatchedNodes.get(i);
            ++i;
        }
        this.mMatchedNodes.clear();
        this.mMatchedNodes = null;
        return items;
    }

    private void getAllTreeItemsFromData(TreeItem[] nodes, Object data) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeNode treeNode = (TreeNode)item.getData();
            if (null != treeNode) {
                if (data.equals(treeNode.getData())) {
                    this.mMatchedNodes.add(item);
                }
                if (item.getItemCount() > 0) {
                    this.getAllTreeItemsFromData(item.getItems(), data);
                }
            }
            ++i;
        }
    }

    private TreeItem getTreeItemFromNode(TreeItem[] items, TreeNode node) {
        int i = 0;
        while (i < items.length) {
            try {
                TreeItem item = items[i];
                TreeNode treeNode = (TreeNode)item.getData();
                if (null != treeNode) {
                    TreeItem retItem;
                    if (node.getData().equals(treeNode.getData())) {
                        return item;
                    }
                    if (item.getItemCount() > 0 && null != (retItem = this.getTreeItemFromNode(item.getItems(), node))) {
                        return retItem;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    private TreeNode getNodeFromData(TreeItem[] nodes, Object data) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeNode treeNode = (TreeNode)item.getData();
            if (null != treeNode) {
                TreeNode childTreeNode;
                if (data.equals(treeNode.getData())) {
                    return treeNode;
                }
                if (item.getItemCount() > 0 && null != (childTreeNode = this.getNodeFromData(item.getItems(), data))) {
                    return childTreeNode;
                }
            }
            ++i;
        }
        return null;
    }

    public void refresh() {
        this.mDrawingArea.redraw();
    }

    public void paintControl(PaintEvent e) {
        this.mGC = e.gc;
        this.mDisplay = e.display;
        this.mSelectionDrawn = false;
        this.mPoints.clear();
        this.drawMappings();
        this.mSourceTreeViewer.getTree().redraw();
        this.mTargetTreeViewer.getTree().redraw();
    }

    private void drawMappings() {
        int i = 0;
        while (i < this.mLinks.size()) {
            MappingObject mapObj = this.mLinks.get(i);
            this.drawLink(mapObj);
            ++i;
        }
        Vector<LinkCache> toDelete = new Vector<LinkCache>();
        int i2 = 0;
        while (i2 < this.mCachedLinks.size()) {
            LinkCache cache = (LinkCache)this.mCachedLinks.get(i2);
            TreeNode srcNode = this.getNodeFromData(this.mSourceTreeViewer, cache.getSource());
            TreeNode targetNode = this.getNodeFromData(this.mTargetTreeViewer, cache.getTarget());
            if (null != srcNode && null != targetNode) {
                MappingObject newMapObj = new MappingObject(srcNode, targetNode);
                if (cache instanceof CompositeLinkCache) {
                    CompositeLinkCache compCache = (CompositeLinkCache)cache;
                    newMapObj.createCompositeLink(compCache.getSourceEnframeStyle(), compCache.getTargetEnframeStyle(), compCache.isSourceIncludeChildren(), compCache.isTargetIncludeChildren());
                } else {
                    newMapObj.createLink();
                }
                newMapObj.setIsSelected(cache.isSelected());
                if (this.drawLink(newMapObj)) {
                    toDelete.add(cache);
                    this.mLinks.add(newMapObj, this.mFireEvent, true);
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < toDelete.size()) {
            boolean removed = this.mCachedLinks.remove(toDelete.get(i3));
            removed = true;
            ++i3;
        }
    }

    private boolean allowDrawing(TreeNode source, TreeNode target) {
        if (null == this.mDrawingAreaFilter) {
            return true;
        }
        return this.mDrawingAreaFilter.allowDrawing(source, target);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.mMouseListener.reset();
        this.mDrawingArea.redraw();
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.mMouseListener.reset();
        this.mDrawingArea.redraw();
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
    }

    public void setMappingListener(TreeMappingListener mappingListener) {
        this.mMappingListener = mappingListener;
        this.mLinks.setMappingListener(mappingListener);
    }

    public void setValidator(TreeMappingValidator validator) {
        this.mLinks.setValidator(validator);
    }

    public MappingObject getSelectedLink() {
        int i = 0;
        while (i < this.mLinks.size()) {
            MappingObject mapObj = this.mLinks.get(i);
            if (mapObj.isSelected()) {
                return mapObj;
            }
            ++i;
        }
        return null;
    }

    public void setEnableMappingContextMenu(boolean value) {
        this.mEnableContextMenu = value;
    }

    public void createLink(Object source, Object target, boolean fireEvent) {
        this.mInternalRepaint = false;
        this.mFireEvent = fireEvent;
        this.createLink(source, target);
        this.mFireEvent = true;
        this.mInternalRepaint = true;
    }

    public void expand(TreeViewer treeViewer, Object data) {
        if (null == treeViewer || null == data) {
            return;
        }
        TreeNode node = this.getNodeFromData(treeViewer, data);
        if (null == node) {
            return;
        }
        TreeItem item = (TreeItem)treeViewer.testFindItem((Object)node);
        if (null == item) {
            return;
        }
        item.setExpanded(true);
        treeViewer.refresh((Object)node);
    }

    public Object[] getMappings(Object source) {
        Vector<Object> dataLinks = new Vector<Object>();
        int i = 0;
        while (i < this.mLinks.size()) {
            MappingObject mappingObject = this.mLinks.get(i);
            Object srcToCompare = null;
            Object targetToCompare = null;
            srcToCompare = source;
            targetToCompare = mappingObject.getSourceNode().getData();
            if (targetToCompare.equals(srcToCompare)) {
                dataLinks.add(mappingObject.getTargetNode().getData());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.mCachedLinks.size()) {
            LinkCache mappingObject = (LinkCache)this.mCachedLinks.get(i2);
            Object srcToCompare = null;
            Object targetToCompare = null;
            srcToCompare = source;
            targetToCompare = mappingObject.getSource();
            if (srcToCompare.equals(targetToCompare)) {
                dataLinks.add(mappingObject.getTarget());
            }
            ++i2;
        }
        Object[] foundMappings = new Object[dataLinks.size()];
        int i3 = 0;
        while (i3 < dataLinks.size()) {
            foundMappings[i3] = dataLinks.get(i3);
            ++i3;
        }
        return foundMappings;
    }

    public void setLinkDecorator(LinkDecorator decorator) {
        this.mLinkDecorator = decorator;
    }

    public void createNewLink(Object source, Object target) {
        MappingObject mappingObj = this.getExistingMapping(source, target);
        if (null == mappingObj) {
            TreeNode srcNode = this.getNodeFromData(this.mSourceTreeViewer, source);
            TreeNode targetNode = this.getNodeFromData(this.mTargetTreeViewer, target);
            if (null != srcNode && null != targetNode) {
                MappingObject newMapObj = new MappingObject(srcNode, targetNode);
                newMapObj.createLink();
                newMapObj.setIsNew(true);
                this.mLinks.add(newMapObj, this.mFireEvent, false);
                this.mDrawingArea.redraw();
            }
        }
    }

    public MappingObject[] getNewMappings() {
        try {
            Vector<MappingObject> newObjs = new Vector<MappingObject>();
            MappingObject[] mappingObjs = this.mLinks.getMappings();
            int i = 0;
            while (i < mappingObjs.length) {
                if (mappingObjs[i].isNew()) {
                    newObjs.add(mappingObjs[i]);
                }
                ++i;
            }
            MappingObject[] newMappingObjs = new MappingObject[newObjs.size()];
            int i2 = 0;
            while (i2 < newObjs.size()) {
                newMappingObjs[i2] = (MappingObject)newObjs.get(i2);
                ++i2;
            }
            return newMappingObjs;
        }
        catch (Exception ex) {
            return new MappingObject[0];
        }
    }

    public void deleteLink(Object source, Object target) {
        MappingObject mappingObj = this.getExistingMapping(source, target);
        if (null == mappingObj) {
            return;
        }
        this.deleteLink(mappingObj);
    }

    public void deleteLink(MappingObject mapping, boolean fireEvent) {
        this.mFireDeleteEvent = fireEvent;
        this.deleteLink(mapping);
        this.mFireDeleteEvent = true;
    }

    public void deleteLink(Object source, Object target, boolean firePostDeleteEvent) {
        this.mFireDeleteEvent = firePostDeleteEvent;
        this.deleteLink(source, target);
        this.mFireDeleteEvent = true;
    }

    public void setDrawingAreaFilter(DrawingAreaFilter filter) {
        this.mDrawingAreaFilter = filter;
    }

    public void setVisibleExtensionLine(boolean visible) {
        this.mShowEntensionLine = visible;
    }

    public void createLink(Object source, Object target, int sourceEnframeStyle, int targetEnframeStyle, boolean includeSourceChildren, boolean includeTargetChildren) {
        MappingObject mappingObj = this.getExistingMapping(source, target);
        if (null == mappingObj) {
            TreeNode srcNode = this.getNodeFromData(this.mSourceTreeViewer, source);
            TreeNode targetNode = this.getNodeFromData(this.mTargetTreeViewer, target);
            if (null != srcNode && null != targetNode) {
                MappingObject newMapObj = new MappingObject(srcNode, targetNode);
                newMapObj.createCompositeLink(sourceEnframeStyle, targetEnframeStyle, includeSourceChildren, includeTargetChildren);
                this.mLinks.add(newMapObj, true, this.mInternalRepaint);
                this.mDrawingArea.redraw();
            } else if (!this.linkCached(source, target)) {
                CompositeLinkCache cache = new CompositeLinkCache(source, target, sourceEnframeStyle, targetEnframeStyle, includeSourceChildren, includeTargetChildren);
                this.mCachedLinks.add(cache);
                if (null != this.mMappingListener && this.mFireEvent && !this.mInternalRepaint) {
                    this.mMappingListener.mappingCreated(mappingObj);
                }
            }
        }
    }

    public Object[] getSelectedFrames(int tree, int filter) {
        int i;
        MappingObject[] mappings = this.getMappings();
        Vector<Object> selectedFrames = new Vector<Object>();
        if (filter == 8 || filter == 10) {
            i = 0;
            while (i < mappings.length) {
                MappingObject mo = mappings[i];
                if (mo.getPaintableObject().isSelected() && mo.getPaintableObject() instanceof CompositePaintableLink) {
                    CompositePaintableLink cpLink = (CompositePaintableLink)mo.getPaintableObject();
                    PaintableShape shape = null;
                    if (tree == 16384) {
                        shape = cpLink.getSourceShape();
                    } else if (tree == 131072) {
                        shape = cpLink.getTargetShape();
                    }
                    TreeNode node = (TreeNode)shape.TreeNode.getData();
                    selectedFrames.add(node.getData());
                }
                ++i;
            }
        }
        if (filter == 9 || filter == 10) {
            i = 0;
            while (i < this.mShapes.size()) {
                PaintableShape shape = (PaintableShape)this.mShapes.get(i);
                if (shape.isSelected()) {
                    boolean found = false;
                    if (tree == 16384 && shape.TreeNode.getParent().equals(this.mSourceTreeViewer.getTree())) {
                        found = true;
                    } else if (tree == 131072 && shape.TreeNode.getParent().equals(this.mTargetTreeViewer.getTree())) {
                        found = true;
                    }
                    if (found) {
                        TreeNode node = (TreeNode)shape.TreeNode.getData();
                        selectedFrames.add(node.getData());
                    }
                }
                ++i;
            }
        }
        return selectedFrames.toArray();
    }

    public void deleteShape(Object node, int tree) {
        TreeViewer viewer = null;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        }
        TreeNode srcNode = this.getNodeFromData(viewer, node);
        if (null != srcNode) {
            PaintableShape shape = this.getShapeFromNode(srcNode);
            this.mShapes.remove(shape);
            this.refresh();
            return;
        }
        ShapeCache cache = this.getShapeFromCache(node, tree);
        if (null != cache) {
            this.mCachedShapes.remove(cache);
        }
    }

    private ShapeCache getShapeFromCache(Object node, int tree) {
        int i = 0;
        while (i < this.mCachedShapes.size()) {
            ShapeCache sc = (ShapeCache)this.mCachedShapes.elementAt(i);
            if (sc.getTree() == tree && node.equals(sc.getSource())) {
                return sc;
            }
            ++i;
        }
        return null;
    }

    private PaintableShape getShapeFromNode(TreeNode srcNode) {
        int i = 0;
        while (i < this.mShapes.size()) {
            PaintableShape shape = (PaintableShape)this.mShapes.elementAt(i);
            if (shape.TreeNode != null && !shape.TreeNode.isDisposed() && srcNode.equals(shape.TreeNode.getData())) {
                return shape;
            }
            ++i;
        }
        return null;
    }

    public void createShape(int shape, Object node, boolean includeChildren, int tree) {
        TreeViewer viewer = null;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        }
        TreeNode srcNode = this.getNodeFromData(viewer, node);
        TreeItem treeItem = this.getTreeItemFromNode(viewer.getTree().getItems(), srcNode);
        if (null != srcNode) {
            PaintableShape pShape = new PaintableShape(shape);
            pShape.TreeNode = treeItem;
            pShape.IncludeChildren = includeChildren;
            this.mShapes.add(pShape);
            this.mDrawingArea.redraw();
        } else {
            this.mCachedShapes.add(new ShapeCache(shape, node, includeChildren, tree));
        }
    }

    public void setSelection(Object node, int tree, boolean reveal) {
        TreeViewer viewer = null;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        }
        TreeNode treeNode = this.getNodeFromData(viewer, node);
        if (null == treeNode && reveal) {
            TreeMappingContentProvider contentProvider = (TreeMappingContentProvider)viewer.getContentProvider();
            ITreeContentProvider externalContentProvider = contentProvider.getExternalContentProvider();
            treeNode = this.getExpandedNode(node, viewer, externalContentProvider);
        }
        if (null == treeNode) {
            return;
        }
        TreeItem[] items = new TreeItem[]{this.getTreeItemFromNode(viewer.getTree().getItems(), treeNode)};
        viewer.setSelection((ISelection)new StructuredSelection((Object)treeNode), true);
        this.updateMappingObjectSelection(tree, items[0].getBounds().x, items[0].getBounds().y);
        this.updateSelectionInCache(tree, node);
        this.mDrawingArea.redraw();
    }

    private void updateSelectionInCache(int tree, Object node) {
        Iterator iter = ((AbstractList)this.mCachedLinks).iterator();
        while (iter.hasNext()) {
            Object obj;
            LinkCache linkCache = (LinkCache)iter.next();
            if (tree == 16384) {
                obj = linkCache.getSource();
            } else {
                if (tree != 131072) continue;
                obj = linkCache.getTarget();
            }
            if (!node.equals(obj)) continue;
            linkCache.setSelected(true);
            break;
        }
        iter = ((AbstractList)this.mCachedShapes).iterator();
        while (iter.hasNext()) {
            ShapeCache shapeCache = (ShapeCache)iter.next();
            if (shapeCache.getTree() != tree || shapeCache.getSource() == null || !shapeCache.getSource().equals(node)) continue;
            shapeCache.setSelected(true);
            break;
        }
    }

    private void internalExpand(Object node, TreeViewer viewer, ITreeContentProvider externalContentProvider) {
        Object parentObj = externalContentProvider.getParent(node);
        if (null == parentObj) {
            return;
        }
        TreeNode parentNode = this.getNodeFromData(viewer, parentObj);
        if (null == parentNode) {
            this.internalExpand(parentObj, viewer, externalContentProvider);
            if (null == this.getNodeFromData(viewer, parentObj)) {
                return;
            }
            parentNode = this.getNodeFromData(viewer, parentObj);
        }
        viewer.expandToLevel((Object)parentNode, 1);
    }

    private TreeNode getExpandedNode(Object node, TreeViewer viewer, ITreeContentProvider provider) {
        this.internalExpand(node, viewer, provider);
        return this.getNodeFromData(viewer, node);
    }

    public void setExpandedState(Object item, boolean expanded, int tree) {
        TreeViewer viewer = null;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        } else {
            return;
        }
        TreeNode node = this.getNodeFromData(viewer, item);
        if (null == node) {
            TreeMappingContentProvider contentProvider = (TreeMappingContentProvider)viewer.getContentProvider();
            ITreeContentProvider externalContentProvider = contentProvider.getExternalContentProvider();
            node = this.getExpandedNode(item, viewer, externalContentProvider);
        }
        if (null != node) {
            viewer.setExpandedState((Object)node, expanded);
        }
        this.refresh();
    }

    public void setExpandedElements(Object[] items, int tree) {
        TreeViewer viewer = null;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        } else {
            return;
        }
        Vector<TreeNode> elements = new Vector<TreeNode>();
        TreeMappingContentProvider contentProvider = (TreeMappingContentProvider)viewer.getContentProvider();
        ITreeContentProvider externalContentProvider = contentProvider.getExternalContentProvider();
        int i = 0;
        while (i < items.length) {
            TreeNode node = this.getNodeFromData(viewer, items[i]);
            if (null != node) {
                elements.add(node);
            } else {
                node = this.getExpandedNode(items[i], viewer, externalContentProvider);
                if (null != node) {
                    elements.add(node);
                }
            }
            ++i;
        }
        viewer.setExpandedElements(elements.toArray());
    }

    public void setDrawShapesOfHiddenNodes(boolean isVisible) {
        this.mAllowDrawingInvisibleNodes = isVisible;
    }

    public void setSelection(Object[] selectedElements, int tree) {
        TreeViewer viewer;
        if (tree == 16384) {
            viewer = this.mSourceTreeViewer;
        } else if (tree == 131072) {
            viewer = this.mTargetTreeViewer;
        } else {
            return;
        }
        Vector<TreeNode> elements = new Vector<TreeNode>();
        int i = 0;
        while (i < selectedElements.length) {
            TreeNode node = this.getNodeFromData(viewer, selectedElements[i]);
            if (null != node) {
                elements.add(node);
            }
            ++i;
        }
        if (elements.size() > 0) {
            viewer.setSelection((ISelection)new StructuredSelection(elements.toArray()));
        }
    }

    public Object[] getAllIndependentFrames(int tree) {
        Vector<Object> frames = new Vector<Object>();
        int i = 0;
        while (i < this.mShapes.size()) {
            TreeNode node;
            PaintableShape shape = (PaintableShape)this.mShapes.get(i);
            TreeItem item = shape.TreeNode;
            if (!item.isDisposed() && (node = (TreeNode)item.getData()) != null) {
                if (tree == 16384 && item.getParent().equals(this.mSourceTreeViewer.getTree())) {
                    frames.add(node.getData());
                } else if (tree == 131072 && item.getParent().equals(this.mTargetTreeViewer.getTree())) {
                    frames.add(node.getData());
                }
            }
            ++i;
        }
        return frames.toArray();
    }

    public ShapeInfo[] getAllShapeInfoObjects(int tree) {
        Vector<ShapeInfo> frames = new Vector<ShapeInfo>();
        int i = 0;
        while (i < this.mShapes.size()) {
            TreeNode node;
            PaintableShape shape = (PaintableShape)this.mShapes.get(i);
            TreeItem item = shape.TreeNode;
            if (!item.isDisposed() && (node = (TreeNode)item.getData()) != null) {
                if (tree == 16384 && item.getParent().equals(this.mSourceTreeViewer.getTree())) {
                    frames.add(new ShapeInfo(node.getData(), tree, shape));
                } else if (tree == 131072 && item.getParent().equals(this.mTargetTreeViewer.getTree())) {
                    frames.add(new ShapeInfo(node.getData(), tree, shape));
                }
            }
            ++i;
        }
        return frames.toArray(new ShapeInfo[frames.size()]);
    }

    public void setCanvasMenu(MenuManager canvasMenuManager) {
        canvasMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (null == LinkPainter.this.getSelectedLink() || !LinkPainter.this.mEnableContextMenu) {
                    return;
                }
                manager.add((IAction)new Action(this, "Delete"){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (null != 7.access$1600(this.this$1).getSelectedLink()) {
                            7.access$1600(this.this$1).deleteLink(7.access$1600(this.this$1).getSelectedLink());
                        }
                    }
                });
            }

            static /* synthetic */ LinkPainter access$1600(7 x0) {
                return x0.LinkPainter.this;
            }
        });
    }

    public void clearAllSelection() {
        this.mLinks.clearAllSelection();
        Iterator iter = ((AbstractList)this.mShapes).iterator();
        while (iter.hasNext()) {
            PaintableShape shape = (PaintableShape)iter.next();
            shape.setSelected(false);
        }
        this.refresh();
    }

    class CanvasKeyListener
    extends KeyAdapter {
        CanvasKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            MappingObject mapObj;
            if (e.character == '\u007f' && null != (mapObj = LinkPainter.this.getSelectedLink())) {
                LinkPainter.this.deleteLink(mapObj);
            }
        }
    }

    class CanvasMouseListener
    extends MouseAdapter {
        private int mSelectedX = -1;
        private int mSelectedY = -1;

        public void mouseDown(MouseEvent e) {
            this.mSelectedX = e.x;
            this.mSelectedY = e.y;
            if (e.button == 1) {
                LinkPainter.this.mCanvasSelected = true;
                LinkPainter.this.mLinks.clearAllSelection();
                LinkPainter.this.mDrawingArea.redraw();
                LinkPainter.this.mSelectionDrawn = false;
            }
        }

        public int getSelectedX() {
            return this.mSelectedX;
        }

        public int getSelectedY() {
            return this.mSelectedY;
        }

        public void reset() {
            this.mSelectedX = -1;
            this.mSelectedY = -1;
        }
    }
}

