/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm.j2ee;

import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.MonitorFactory;
import com.sap.util.monitor.jarm.ComponentOverview;
import com.sap.util.monitor.jarm.OverviewMonitor;
import com.sap.util.monitor.jarm.RequestOverview;
import com.sap.util.monitor.jarm.RequestSummary;
import com.sap.util.monitor.jarm.UserOverview;
import com.sap.util.monitor.jarm.j2ee.PerfProperties;
import com.sap.util.monitor.jarm.j2ee.ReportConfiguration;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ReportThread
implements Runnable {
    private static ReportConfiguration prop = new ReportConfiguration();
    static final int MAX_RESULTS = 20;
    static boolean firstTime = true;
    static String[] nodeNamesS = new String[]{"Accumulated outbound data", "Accumulated response time", "Average outbound data", "Average time of a request", "Requests per second", "Number of requests", "Requests providing outbound data", "Req. providing correct monitor data", "Req. with not correctly closed component", "Req. closed due to too many components", "Comp. calls made for all requests", "Avg. comp. calls made per request", "Users making requests", "Users making requests (since last reset)", "Req. running with level 0", "Req. running with level 1", "Req. running with level 2"};
    static String[] nodeNamesR = new String[]{"Top request ", "Request name", "User", "Request time", "Request timestamp", "Request out data", "Status", "Nb of Components", "Component (Max Time)", "Max Time", "Component (Max Data)", "Max Data", "Description", "Level"};
    static String[] loopReq = new String[]{"req time", "out"};
    static String[] nodeNamesC = new String[]{"Top component ", "Component name", "Gross time", "Avg. gross time", "Net time", "Avg. net time", "Out data", "Avg. out data", "Calls", "Comp gross time provided", "Comp net time provided", "Comp data provided", "Description", "Properties calls", "Properties"};
    static String[] loopComp = new String[]{"avg gross", "avg net", "out", "calls"};
    static String[] nodeNamesU = new String[]{"Top user ", "User name", "Num Request", "Total time", "Avg time", "First Request", "Last Request"};
    static String[] loopUser = new String[]{"avg", "total", "calls"};
    static IMonitorNode root;
    static IMonitorNode requestOvManager;
    static IMonitorNode msgReqTimeObject;
    static IMonitorNode msgReqOutObject;
    static IMonitorNode componentTextManager;
    static IMonitorNode msgCompGtObject;
    static IMonitorNode msgCompNtObject;
    static IMonitorNode msgCompOutObject;
    static IMonitorNode msgCompCallObject;
    static IMonitorNode userTextManager;
    static IMonitorNode msgUserGtObject;
    static IMonitorNode msgUserAccObject;
    static IMonitorNode msgUserCallObject;
    static ITableMonitorNode requestSummaryManager;
    static IMonitorObjectFactory monitorFactory;
    static PerfProperties perfProperties;
    static Vector vectCompGt;
    static Vector vectCompNt;
    static Vector vectCompOut;
    static Vector vectCompCall;
    static Vector vectUserGt;
    static Vector vectUserAcc;
    static Vector vectUserCall;
    static Vector vectReqTime;
    static Vector vectReqOut;

    public void run() {
        try {
            while (this.writeData()) {
                Thread.sleep(ReportConfiguration.getSleepTime());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void createStatusLineAttribute(IMonitorNode parent, String textName) throws InvalidNameException {
        monitorFactory.createStringMonitorNode(textName, parent);
    }

    public void createPerfValueAttribute(IMonitorNode parent, String textName, IThresholds thresholds) throws InvalidNameException {
        monitorFactory.createIntegerMonitorNode(textName, parent, thresholds);
    }

    public void setStatusLineAttribute(IStringMonitorNode node, String textContent) throws InvalidNameException {
        if (textContent == null) {
            textContent = "";
        }
        node.setText(textContent);
        node.setDescription(textContent);
    }

    public void setPerfValueAttribute(IIntegerMonitorNode node, int value) throws InvalidNameException {
        node.setValue(value);
    }

    public void createPropertiesAt(IMonitorNode parent, String text) throws InvalidNameException {
        boolean i = false;
        String[] header = new String[]{"Name", "Value"};
        ITableMonitorNode tableNode = monitorFactory.createTableMonitorNode(text, parent);
        tableNode.setHeader(header);
    }

    public void setPropertiesAt(ITableMonitorNode tableNode, Properties props) throws InvalidNameException {
        int i = 0;
        if (props != null) {
            Serializable[][] entries = new Serializable[props.size()][2];
            tableNode.setEntries(entries);
            i = 0;
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                tableNode.changeEntry(i, 0, (Serializable)((Object)name));
                tableNode.changeEntry(i, 1, (Serializable)((Object)value));
                ++i;
            }
        }
    }

    public long getPercent(long a, long b, boolean treatZeroAsHundred) {
        if (b == 0L) {
            if (treatZeroAsHundred) {
                return 100L;
            }
            return 0L;
        }
        if (a != 0L && 100L * a < b) {
            return 1L;
        }
        long round = Math.round((double)(a * 100L) / (double)b);
        if (round == 100L && a != b) {
            return 99L;
        }
        return round;
    }

    public String getDateString(long time) {
        if (time == 0L) {
            return "";
        }
        return new Date(time).toString();
    }

    public boolean writeData() {
        try {
            if (firstTime) {
                ReportConfiguration.setProperties();
                monitorFactory = MonitorFactory.createMonitorObjectFactory();
                perfProperties = new PerfProperties(monitorFactory);
                if (monitorFactory == null) {
                    System.out.println("Unable to connect to the monitoring tree");
                    return false;
                }
                String rootName = "Application Requests - " + ReportConfiguration.getServerName();
                root = monitorFactory.createSimpleMonitorNode(rootName, monitorFactory.getApplicationsRootNode());
                requestOvManager = monitorFactory.createSimpleMonitorNode("Request Overview", root);
                msgReqTimeObject = monitorFactory.createSimpleMonitorNode("Top list (request time)", requestOvManager);
                msgReqOutObject = monitorFactory.createSimpleMonitorNode("Top list (outbound data)", requestOvManager);
                componentTextManager = monitorFactory.createSimpleMonitorNode("Component Overview", root);
                msgCompGtObject = monitorFactory.createSimpleMonitorNode("Top list (avg gross time)", componentTextManager);
                msgCompNtObject = monitorFactory.createSimpleMonitorNode("Top list (avg net time)", componentTextManager);
                msgCompOutObject = monitorFactory.createSimpleMonitorNode("Top list (outbound data)", componentTextManager);
                msgCompCallObject = monitorFactory.createSimpleMonitorNode("Top list (call num)", componentTextManager);
                userTextManager = monitorFactory.createSimpleMonitorNode("User Overview", root);
                msgUserGtObject = monitorFactory.createSimpleMonitorNode("Top list (avg time)", userTextManager);
                msgUserAccObject = monitorFactory.createSimpleMonitorNode("Top list (total time)", userTextManager);
                msgUserCallObject = monitorFactory.createSimpleMonitorNode("Top list (calls num)", userTextManager);
                requestSummaryManager = monitorFactory.createTableMonitorNode("Request Summary", root);
                this.initReqSummaryTable(requestSummaryManager);
                firstTime = false;
            }
            this.setReqSummaryAttributeValues(requestSummaryManager);
            this.setTopComponentsValues(msgCompGtObject, msgCompNtObject, msgCompOutObject, msgCompCallObject);
            this.setTopUsersValues(msgUserGtObject, msgUserAccObject, msgUserCallObject);
            this.setTopRequestsValues(msgReqTimeObject, msgReqOutObject);
            return true;
        }
        catch (Exception e) {
            System.out.println("InstrumentationTest: main: Error!" + e);
            return false;
        }
    }

    public void initReqSummaryTable(ITableMonitorNode table) {
        String[] header = new String[]{"Property", "Value"};
        Serializable[][] entries = new Serializable[21][2];
        int j = 0;
        entries[j++][0] = nodeNamesS[5];
        entries[j++][0] = nodeNamesS[3];
        entries[j++][0] = nodeNamesS[4];
        entries[j++][0] = nodeNamesS[2];
        entries[j++][0] = nodeNamesS[1];
        entries[j++][0] = nodeNamesS[6];
        entries[j++][0] = nodeNamesS[0];
        entries[j++][0] = nodeNamesS[10];
        entries[j++][0] = nodeNamesS[11];
        entries[j++][0] = nodeNamesS[7];
        entries[j++][0] = nodeNamesS[8];
        entries[j++][0] = nodeNamesS[9];
        entries[j++][0] = nodeNamesS[12];
        entries[j++][0] = nodeNamesS[13];
        entries[j++][0] = nodeNamesS[14];
        entries[j++][0] = nodeNamesS[15];
        entries[j++][0] = nodeNamesS[16];
        entries[j++][0] = "Timestamp first request";
        entries[j++][0] = "Timestamp of last request reset";
        entries[j++][0] = "Timestamp of last component reset";
        entries[j++][0] = "Timestamp of last user reset";
        table.setHeader(header);
        table.setEntries(entries);
    }

    private void setReqSummaryAttributeValues(ITableMonitorNode parent) {
        try {
            int i = 0;
            RequestSummary summary = OverviewMonitor.getSummaryOfRequests();
            if (summary == null) {
                return;
            }
            Serializable[][] entries = parent.getEntries();
            entries[i++][1] = new Integer((int)summary.reqAccNr);
            entries[i++][1] = new Integer((int)summary.reqAvgTime);
            entries[i++][1] = new Integer((int)summary.reqPerSec);
            entries[i++][1] = new Integer((int)summary.reqAvgOutData);
            entries[i++][1] = new Integer((int)summary.reqAccTime);
            entries[i++][1] = new Integer((int)summary.reqAccOutDataFilled);
            entries[i++][1] = new Integer((int)summary.reqAccOutData);
            entries[i++][1] = new Integer((int)summary.reqAccComp);
            entries[i++][1] = new Integer((int)summary.reqAvgComp);
            entries[i++][1] = new Integer((int)this.getPercent(summary.reqAccStatusOk, summary.reqAccNr, true));
            entries[i++][1] = new Integer((int)this.getPercent(summary.reqAccStatusCompNotClosed, summary.reqAccNr, false));
            entries[i++][1] = new Integer((int)this.getPercent(summary.reqAccStatusEndForced, summary.reqAccNr, false));
            entries[i++][1] = new Integer((int)summary.reqStartAccUserNr);
            entries[i++][1] = new Integer((int)summary.reqAccUserNr);
            entries[i++][1] = new Integer((int)summary.reqCompLevelBasic);
            entries[i++][1] = new Integer((int)summary.reqCompLevelMedium);
            entries[i++][1] = new Integer((int)summary.reqCompLevelDetail);
            entries[i++][1] = this.getDateString(summary.reqFirstTS);
            entries[i++][1] = this.getDateString(summary.resetReqTS);
            entries[i++][1] = this.getDateString(summary.resetCompTS);
            entries[i++][1] = this.getDateString(summary.resetUserTS);
        }
        catch (Exception e) {
            System.out.println("Error occured in method setReqSummaryAttribute:");
            e.printStackTrace();
        }
    }

    private void setTopComponentsValues(IMonitorNode parent, IMonitorNode parent2, IMonitorNode parent3, IMonitorNode parent4) {
        try {
            int ia = 0;
            while (ia < loopComp.length) {
                IMonitorNode parentNr;
                Vector vect;
                IMonitorNode parentSub;
                ComponentOverview[] components;
                switch (ia) {
                    case 0: {
                        components = OverviewMonitor.getTopComponents((int)0, (String)"*", (int)20);
                        parentSub = parent;
                        vect = vectCompGt;
                        break;
                    }
                    case 1: {
                        components = OverviewMonitor.getTopComponents((int)1, (String)"*", (int)20);
                        parentSub = parent2;
                        vect = vectCompNt;
                        break;
                    }
                    case 2: {
                        components = OverviewMonitor.getTopComponents((int)2, (String)"*", (int)20);
                        parentSub = parent3;
                        vect = vectCompOut;
                        break;
                    }
                    default: {
                        components = OverviewMonitor.getTopComponents((int)3, (String)"*", (int)20);
                        parentSub = parent4;
                        vect = vectCompCall;
                    }
                }
                if (components == null) {
                    components = new ComponentOverview[]{};
                }
                int iz = vect.size();
                while (iz < components.length) {
                    String textName = nodeNamesC[0] + loopComp[ia] + " #" + (iz + 1);
                    parentNr = monitorFactory.createSimpleMonitorNode(textName, parentSub);
                    this.createStatusLineAttribute(parentNr, nodeNamesC[1]);
                    this.createPerfValueAttribute(parentNr, nodeNamesC[2], perfProperties.getDefaultPerfPropTime());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[3], perfProperties.getPerfPropCmpGrossTime());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[4], perfProperties.getDefaultPerfPropTime());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[5], perfProperties.getPerfPropCmpNetTime());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[6], perfProperties.getDefaultPerfPropData());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[7], perfProperties.getPerfPropCmpOutData());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[8], perfProperties.getDefaultPerfPropNumber());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[9], perfProperties.getPerfPropCmpGrossTimeProvided());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[10], perfProperties.getPerfPropCmpNetTimeProvided());
                    this.createPerfValueAttribute(parentNr, nodeNamesC[11], perfProperties.getDefaultPerfPropData());
                    this.createStatusLineAttribute(parentNr, nodeNamesC[12]);
                    this.createPerfValueAttribute(parentNr, nodeNamesC[13], perfProperties.getDefaultPerfPropNumber());
                    this.createPropertiesAt(parentNr, nodeNamesC[14]);
                    vect.add(iz, parentNr);
                    ++iz;
                }
                int iz2 = 0;
                while (iz2 < components.length) {
                    parentNr = (IMonitorNode)vect.elementAt(iz2);
                    IMonitorNode[] subNodes = parentNr.getSubNodes();
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[0], components[iz2].compName);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[1], (int)components[iz2].compAccGrossTime);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[2], (int)components[iz2].compAvgGrossTime);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[3], (int)components[iz2].compAccNetTime);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[4], (int)components[iz2].compAvgNetTime);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[5], (int)components[iz2].compAccOutData);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[6], (int)components[iz2].compAvgOutData);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[7], (int)components[iz2].compAccNr);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[8], (int)this.getPercent(components[iz2].compAccGrossTimeFilled, components[iz2].compAccNr, true));
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[9], (int)this.getPercent(components[iz2].compAccNetTimeFilled, components[iz2].compAccNr, true));
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[10], (int)components[iz2].compAccOutDataFilled);
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[11], components[iz2].compDescr);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[12], (int)components[iz2].compAccPropsNr);
                    this.setPropertiesAt((ITableMonitorNode)subNodes[13], components[iz2].compAccProps);
                    ++iz2;
                }
                this.updateTreeVector(components.length, vect, parentSub);
                ++ia;
            }
        }
        catch (Exception e) {
            System.out.println("Error occured in method setTopComponentsValues: ");
            e.printStackTrace();
        }
    }

    private void setTopUsersValues(IMonitorNode parent, IMonitorNode parent2, IMonitorNode parent3) {
        try {
            int ia = 0;
            while (ia < loopUser.length) {
                IMonitorNode parentNr;
                Vector vect;
                IMonitorNode parentSub;
                UserOverview[] users;
                switch (ia) {
                    case 0: {
                        users = OverviewMonitor.getTopUsers((int)0, (String)"*", (int)20);
                        parentSub = parent;
                        vect = vectUserGt;
                        break;
                    }
                    case 1: {
                        users = OverviewMonitor.getTopUsers((int)4, (String)"*", (int)20);
                        parentSub = parent2;
                        vect = vectUserAcc;
                        break;
                    }
                    default: {
                        users = OverviewMonitor.getTopUsers((int)3, (String)"*", (int)20);
                        parentSub = parent3;
                        vect = vectUserCall;
                    }
                }
                if (users == null) {
                    users = new UserOverview[]{};
                }
                int iz = vect.size();
                while (iz < users.length) {
                    String textName = nodeNamesU[0] + loopUser[ia] + " #" + (iz + 1);
                    parentNr = monitorFactory.createSimpleMonitorNode(textName, parentSub);
                    this.createStatusLineAttribute(parentNr, nodeNamesU[1]);
                    this.createPerfValueAttribute(parentNr, nodeNamesU[2], perfProperties.getDefaultPerfPropNumber());
                    this.createPerfValueAttribute(parentNr, nodeNamesU[3], perfProperties.getDefaultPerfPropTime());
                    this.createPerfValueAttribute(parentNr, nodeNamesU[4], perfProperties.getPerfPropUserAvgTime());
                    this.createStatusLineAttribute(parentNr, nodeNamesU[5]);
                    this.createStatusLineAttribute(parentNr, nodeNamesU[6]);
                    vect.add(iz, parentNr);
                    ++iz;
                }
                int iz2 = 0;
                while (iz2 < users.length) {
                    parentNr = (IMonitorNode)vect.elementAt(iz2);
                    IMonitorNode[] subNodes = parentNr.getSubNodes();
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[0], users[iz2].userName);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[1], (int)users[iz2].userAccNr);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[2], (int)users[iz2].userAccTime);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[3], (int)users[iz2].userAvgTime);
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[4], this.getDateString(users[iz2].userFirstTS));
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[5], this.getDateString(users[iz2].userLastTS));
                    ++iz2;
                }
                this.updateTreeVector(users.length, vect, parentSub);
                ++ia;
            }
        }
        catch (Exception e) {
            System.out.println("Error occured in method setTopUsersValues:");
            e.printStackTrace();
        }
    }

    private void setTopRequestsValues(IMonitorNode parent, IMonitorNode parent2) {
        try {
            int ia = 0;
            while (ia < loopReq.length) {
                IMonitorNode parentNr;
                Vector vect;
                IMonitorNode parentSub;
                RequestOverview[] topRequests;
                switch (ia) {
                    case 0: {
                        topRequests = OverviewMonitor.getTopRequests((int)2, (int)0, (String)"*", (int)20);
                        parentSub = parent;
                        vect = vectReqTime;
                        break;
                    }
                    default: {
                        topRequests = OverviewMonitor.getTopRequests((int)2, (int)2, (String)"*", (int)20);
                        parentSub = parent2;
                        vect = vectReqOut;
                    }
                }
                if (topRequests == null) {
                    topRequests = new RequestOverview[]{};
                }
                int iz = vect.size();
                while (iz < topRequests.length) {
                    String textName = nodeNamesR[0] + loopReq[ia] + " #" + (iz + 1);
                    parentNr = monitorFactory.createSimpleMonitorNode(textName, parentSub);
                    this.createStatusLineAttribute(parentNr, nodeNamesR[1]);
                    this.createPerfValueAttribute(parentNr, nodeNamesR[3], perfProperties.getPerfPropReqTime());
                    this.createPerfValueAttribute(parentNr, nodeNamesR[5], perfProperties.getPerfPropReqOutData());
                    this.createPerfValueAttribute(parentNr, nodeNamesR[7], perfProperties.getPerfPropReqNbComp());
                    this.createStatusLineAttribute(parentNr, nodeNamesR[8]);
                    this.createPerfValueAttribute(parentNr, nodeNamesR[9], perfProperties.getPerfPropReqMaxTime());
                    this.createStatusLineAttribute(parentNr, nodeNamesR[10]);
                    this.createPerfValueAttribute(parentNr, nodeNamesR[11], perfProperties.getPerfPropReqMaxData());
                    this.createPerfValueAttribute(parentNr, nodeNamesR[6], perfProperties.getPerfPropReqStatus());
                    this.createStatusLineAttribute(parentNr, nodeNamesR[4]);
                    this.createStatusLineAttribute(parentNr, nodeNamesR[2]);
                    this.createStatusLineAttribute(parentNr, nodeNamesR[12]);
                    this.createStatusLineAttribute(parentNr, nodeNamesR[13]);
                    vect.add(iz, parentNr);
                    ++iz;
                }
                int iz2 = 0;
                while (iz2 < topRequests.length) {
                    parentNr = (IMonitorNode)vect.elementAt(iz2);
                    IMonitorNode[] subNodes = parentNr.getSubNodes();
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[0], topRequests[iz2].reqName);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[1], (int)topRequests[iz2].reqTime);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[2], topRequests[iz2].reqOutData);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[3], topRequests[iz2].reqComp);
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[4], topRequests[iz2].compNetTimeName);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[5], (int)topRequests[iz2].compNetTime);
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[6], topRequests[iz2].compOutDataName);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[7], (int)topRequests[iz2].compOutData);
                    this.setPerfValueAttribute((IIntegerMonitorNode)subNodes[8], topRequests[iz2].reqStatus);
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[9], this.getDateString(topRequests[iz2].reqTS));
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[10], topRequests[iz2].userName);
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[11], this.getStringNotNull(topRequests[iz2].reqDescr));
                    this.setStatusLineAttribute((IStringMonitorNode)subNodes[12], Integer.toString(topRequests[iz2].reqCompLevel));
                    ++iz2;
                }
                this.updateTreeVector(topRequests.length, vect, parentSub);
                ++ia;
            }
        }
        catch (Exception e) {
            System.out.println("Error occured in method setTopRequestsValues:");
            e.printStackTrace();
        }
    }

    public String getStringNotNull(String s) {
        return s != null ? s : "";
    }

    public void deleteAllSubNodes(IMonitorNode node) {
        IMonitorNode[] subnodes = node.getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            IMonitorNode current = subnodes[i];
            this.deleteAllSubNodes(current);
            node.removeSubNode(current);
            ++i;
        }
    }

    public void updateTreeVector(int newSize, Vector vect, IMonitorNode parent) {
        int size = vect.size();
        if (newSize < size) {
            IMonitorNode[] subNodes = parent.getSubNodes();
            int i = size - 1;
            while (i >= newSize) {
                vect.removeElementAt(i);
                this.deleteAllSubNodes(subNodes[i]);
                parent.removeSubNode(subNodes[i]);
                --i;
            }
        }
    }

    public static void main(String[] arguments) {
        new Thread(new ReportThread()).start();
    }

    static {
        vectCompGt = new Vector();
        vectCompNt = new Vector();
        vectCompOut = new Vector();
        vectCompCall = new Vector();
        vectUserGt = new Vector();
        vectUserAcc = new Vector();
        vectUserCall = new Vector();
        vectReqTime = new Vector();
        vectReqOut = new Vector();
    }
}

