/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class ReportConfiguration {
    private static final String DEFAULTPROFILE = "profile" + File.separator + "jarm_ccms.properties";
    public static final int MIN_SLEEP_TIME = 60000;
    private static final String APPLSERVERNAME = "ApplicationServer";
    private static String initApplServerName = "Unknown host";
    private static final String THREADSLEEP = "ThreadSleepTime";
    public static int initThreadSleep = 300000;

    protected static void setPropertiesInternal(Properties props) {
        try {
            InputStream inStream = ClassLoader.getSystemResourceAsStream(DEFAULTPROFILE);
            if (inStream != null) {
                props.load(inStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setProperties() {
        Properties props = new Properties();
        try {
            initApplServerName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        ReportConfiguration.setPropertiesInternal(props);
        if (props == null) {
            return;
        }
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = props.getProperty(key);
            if (key.compareToIgnoreCase(APPLSERVERNAME) == 0) {
                ReportConfiguration.setServerName(value);
                continue;
            }
            if (key.compareToIgnoreCase(THREADSLEEP) != 0) continue;
            try {
                int sleeptime = Integer.parseInt(value);
                if (sleeptime < 60000) {
                    ReportConfiguration.setSleepTime(60000);
                    System.out.println("Warning! Sleeptime set to mininal value (minimum: 60000)");
                    System.out.println("Warning! <" + key + "> = <" + value + ">");
                    continue;
                }
                ReportConfiguration.setSleepTime(sleeptime);
            }
            catch (NumberFormatException exc) {
                System.out.println("Warning! Please use int values for parameter:<" + key + "> " + exc);
            }
        }
    }

    public static void setServerName(String name) {
        initApplServerName = name;
    }

    public static String getServerName() {
        return initApplServerName;
    }

    public static void setSleepTime(int sleeptime) {
        initThreadSleep = sleeptime;
    }

    public static int getSleepTime() {
        return initThreadSleep;
    }
}

