/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.metainfo;

import com.togethersoft.selena.patterns.metainfo.ElementMetaInfo;
import com.togethersoft.selena.patterns.metainfo.MetaInfoVisitor;
import com.togethersoft.selena.patterns.metainfo.PatternConfigProperty$Choices;
import java.util.ArrayList;

public final class PatternConfigProperty
implements ElementMetaInfo {
    public static final int SINGLE_CHOICE = 1;
    public static final int STRING_VALUE = 3;
    public static final int BOOLEAN_VALUE = 4;
    private String myID;
    private String myName;
    private int myType;
    private String myValue;
    private PatternConfigProperty$Choices myChoices;
    private boolean myBooleanValue;
    private ArrayList myIDsArray;
    private ArrayList myDescArray;
    private int myDefaultIndex;

    private PatternConfigProperty(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException("Wrong type value: " + n2);
        }
        this.myID = string;
        this.myName = string2;
        this.myType = n2;
    }

    public String getID() {
        return this.myID;
    }

    public int getType() {
        return this.myType;
    }

    public String getName() {
        return this.myName;
    }

    public PatternConfigProperty$Choices getChoices() {
        if (this.getType() != 1) {
            throw new IllegalStateException("getType() != SINGLE_CHOICE");
        }
        if (this.myChoices == null) {
            this.myChoices = new PatternConfigProperty$Choices(this.myIDsArray.toArray(new String[this.myIDsArray.size()]), this.myDescArray.toArray(new String[this.myDescArray.size()]), this.myDefaultIndex, null);
            this.myIDsArray = null;
            this.myDescArray = null;
        }
        return this.myChoices;
    }

    public String getValue() {
        if (this.myType == 1) {
            return this.getChoices().getID(this.myDefaultIndex);
        }
        if (this.myType == 4) {
            return this.myBooleanValue ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        }
        return this.myValue;
    }

    public boolean getBooleanValue() {
        return this.myBooleanValue;
    }

    public void accept(MetaInfoVisitor metaInfoVisitor) {
        metaInfoVisitor.visitConfigProperty(this);
    }

    public void addChoice(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (this.getType() != 1) {
            throw new IllegalStateException("getType() != SINGLE_CHOICE");
        }
        if (bl) {
            this.myDefaultIndex = this.myIDsArray.size();
        }
        this.myIDsArray.add(string);
        this.myDescArray.add(string2);
    }

    public static PatternConfigProperty createChoiceProperty(String string, String string2) {
        PatternConfigProperty patternConfigProperty = new PatternConfigProperty(string, string2, 1);
        patternConfigProperty.myIDsArray = new ArrayList();
        patternConfigProperty.myDescArray = new ArrayList();
        return patternConfigProperty;
    }

    public static PatternConfigProperty createStringProperty(String string, String string2, String string3) {
        PatternConfigProperty patternConfigProperty = new PatternConfigProperty(string, string2, 3);
        patternConfigProperty.myValue = string3;
        return patternConfigProperty;
    }

    public static PatternConfigProperty createBooleanProperty(String string, String string2, boolean bl) {
        PatternConfigProperty patternConfigProperty = new PatternConfigProperty(string, string2, 4);
        patternConfigProperty.myBooleanValue = bl;
        return patternConfigProperty;
    }
}

