/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.handlers.helper;

import com.togethersoft.selena.patterns.c.a.a;
import com.togethersoft.selena.patterns.c.a.b;
import com.togethersoft.selena.patterns.c.a.f;
import com.togethersoft.selena.patterns.c.a.g;
import com.togethersoft.selena.patterns.c.a.i;
import com.togethersoft.selena.patterns.c.d.c;
import com.togethersoft.selena.patterns.c.h;
import com.togethersoft.selena.patterns.handlers.MissedPropertyResolver;
import com.togethersoft.selena.patterns.handlers.PatternPropertyAccessor;
import com.togethersoft.selena.patterns.handlers.helper.AccessorHelper;
import com.togethersoft.selena.patterns.handlers.helper.BasicSnippetContext;
import com.togethersoft.selena.patterns.handlers.helper.DefaultMissedPropertyResolver;
import com.togethersoft.selena.patterns.handlers.helper.SnippetContext;
import com.togethersoft.selena.patterns.metainfo.FieldMetaInfo;
import com.togethersoft.selena.patterns.metainfo.MethodArgument;
import com.togethersoft.selena.patterns.metainfo.MethodMetaInfo;
import com.togethersoft.selena.patterns.metainfo.ParticipantMetaInfo;
import com.togethersoft.selena.patterns.metainfo.ParticipantReference;
import com.togethersoft.selena.patterns.metainfo.ParticipantType;
import com.togethersoft.selena.patterns.metainfo.PatternLink;
import com.togethersoft.selena.patterns.metainfo.PatternMetaInfo;
import com.togethersoft.selena.patterns.metainfo.Requisite;
import com.tssap.selena.cmf.templates.ISnippet;
import com.tssap.selena.cmf.templates.ISnippetContext;
import com.tssap.selena.cmf.templates.Templates;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMMethod;

public final class ParticipantHelper {
    public static final String VAR_CONTEXT = "context";
    public static final String VAR_CLASSNAME = "className";
    private static final IProgressMonitor nullProgress = new NullProgressMonitor();
    private ParticipantMetaInfo myParticipantMetaInfo;
    private PatternPropertyAccessor myPatternAccessor;
    private a myTargetClass;
    private SnippetContext mySnippetContext;
    private AccessorHelper myAccessorHelper;

    public ParticipantHelper(ParticipantMetaInfo participantMetaInfo, PatternPropertyAccessor patternPropertyAccessor) {
        this.myParticipantMetaInfo = participantMetaInfo;
        this.myPatternAccessor = patternPropertyAccessor;
        this.myPatternAccessor.setResolver(new DefaultMissedPropertyResolver(this));
    }

    public ParticipantHelper(ParticipantMetaInfo participantMetaInfo, PatternPropertyAccessor patternPropertyAccessor, IType iType) {
        this(participantMetaInfo, patternPropertyAccessor);
        this.initWithParticipant(iType);
    }

    public ParticipantMetaInfo getParticipantMetaInfo() {
        return this.myParticipantMetaInfo;
    }

    public PatternPropertyAccessor getPatternAccessor() {
        return this.myPatternAccessor;
    }

    public boolean isAppropriateType(IType iType) {
        if (iType == null) {
            return false;
        }
        try {
            if (this.myParticipantMetaInfo.getAllowedType() == ParticipantType.CLASS) {
                return iType.isClass();
            }
            if (this.myParticipantMetaInfo.getAllowedType() == ParticipantType.INTERFACE) {
                return iType.isInterface();
            }
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean canCreateFrom(Object object) {
        if (object instanceof IType) {
            return this.isAppropriateType((IType)object);
        }
        if (object instanceof IPackageFragment) {
            return true;
        }
        if (object instanceof Object[]) {
            IPackageFragment[] iPackageFragmentArray = new IPackageFragment[1];
            String[] stringArray = new String[1];
            if (!this.getParametersFrom((Object[])object, iPackageFragmentArray, stringArray)) {
                return false;
            }
            ICompilationUnit iCompilationUnit = iPackageFragmentArray[0].getCompilationUnit(stringArray[0] + ".java");
            if (iCompilationUnit.exists()) {
                return this.isAppropriateType(iCompilationUnit.getType(stringArray[0]));
            }
            return true;
        }
        if (object == null) {
            return this.getPackageFragmentFromAnotherParticipants() != null;
        }
        return false;
    }

    public void createAppropriateType(Object object) {
        object = this.getCreationValue(object);
        try {
            if (object instanceof IType) {
                this.myTargetClass = new a((IType)object);
            } else if (object instanceof IPackageFragment) {
                IPackageFragment iPackageFragment = (IPackageFragment)object;
                this.initTargetClass(iPackageFragment, c.a(iPackageFragment, this.myParticipantMetaInfo.getBaseName()));
            } else if (object instanceof Object[]) {
                IPackageFragment[] iPackageFragmentArray = new IPackageFragment[1];
                String[] stringArray = new String[1];
                this.getParametersFrom((Object[])object, iPackageFragmentArray, stringArray);
                this.initTargetClass(iPackageFragmentArray[0], stringArray[0]);
            } else {
                h.b();
                throw new IllegalArgumentException(h.b("ParticipantHelper.ValidParameterTypes"));
            }
            if (this.myParticipantMetaInfo.getCardinality() == 1) {
                this.myPatternAccessor.setParticipant(this.myParticipantMetaInfo.getID(), this.myTargetClass.b());
            } else {
                this.myPatternAccessor.addParticipant(this.myParticipantMetaInfo.getID(), this.myTargetClass.b());
            }
            this.myTargetClass.a(this.mergeTemplate(this.myParticipantMetaInfo.getComment()));
            this.addRole();
            this.ensureAbstract();
            this.ensureGeneralization();
            this.createRequiredImports();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public void ensureGeneralization(IType iType) {
        this.myTargetClass.c(iType);
    }

    public void addImport(IType iType) {
        this.myTargetClass.b(iType);
    }

    public boolean importCausesAmbiguity(IType iType) {
        IPackageFragment iPackageFragment = this.myTargetClass.b().getPackageFragment();
        if (iPackageFragment.equals(iType.getPackageFragment())) {
            return false;
        }
        ICompilationUnit iCompilationUnit = iPackageFragment.getCompilationUnit(iType.getElementName() + ".java");
        return iCompilationUnit.exists();
    }

    public IType getUnderlyingType() {
        return this.myTargetClass.b();
    }

    public boolean participantIsClass() {
        return this.myTargetClass.e();
    }

    public IField createField(String string) {
        FieldMetaInfo fieldMetaInfo = this.myParticipantMetaInfo.getField(string);
        String string2 = this.mergeTemplate(new b(fieldMetaInfo, this.myPatternAccessor).b());
        IField iField = this.myTargetClass.f(string2);
        if (iField != null) {
            this.myPatternAccessor.setFieldName(string, iField.getElementName());
        } else {
            h.a((Exception)((Object)this.myTargetClass.d()));
        }
        return iField;
    }

    public IMethod createMethod(String string) {
        return this.createMethod(this.myParticipantMetaInfo.getMethod(string));
    }

    public IMethod createMethod(MethodMetaInfo methodMetaInfo) {
        String string = this.getMethodTemplate(methodMetaInfo);
        String string2 = this.mergeTemplate(string);
        IMethod iMethod = this.doCreateMethod(methodMetaInfo, this.resolveMethodNameCollision(methodMetaInfo.getID(), string2));
        if (iMethod != null) {
            this.myPatternAccessor.setMethodName(methodMetaInfo.getID(), iMethod.getElementName());
            return iMethod;
        }
        if (this.myTargetClass.d() != null) {
            h.a((Exception)((Object)this.myTargetClass.d()));
        }
        return null;
    }

    public void implementAbstractMethods(String string, String string2) {
        this.checkCanImplement();
        this.myTargetClass.a(this.myPatternAccessor.getParticipant(string), string2);
    }

    public void implementPublicMethods(IType iType, g g2) {
        try {
            this.checkCanImplement();
            IMethod[] iMethodArray = iType.getMethods();
            int n2 = 0;
            while (n2 < iMethodArray.length) {
                if (Flags.isPublic((int)iMethodArray[n2].getFlags()) && !Flags.isStatic((int)iMethodArray[n2].getFlags())) {
                    this.myTargetClass.a(iMethodArray[n2], g2.a(iMethodArray[n2]));
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            h.b().getLog().log(javaModelException.getStatus());
        }
    }

    public void implementMethod(IMethod iMethod, g g2) {
        this.myTargetClass.a(iMethod, g2.a(iMethod));
    }

    public void reimplementMethod(String string, g g2) {
        this.checkCanImplement();
        IMethod iMethod = this.findMethod(string);
        if (iMethod == null) {
            iMethod = this.createMethod(string);
        }
        if (iMethod == null) {
            h.a("Unable nor to find, nor to implement method requested for reimplementation:" + string);
            return;
        }
        String string2 = g2.a(iMethod);
        this.myTargetClass.b(iMethod, this.mergeTemplate(string2));
        if (this.myTargetClass.d() != null) {
            h.a((Exception)((Object)this.myTargetClass.d()));
        }
    }

    public void setSnippetContext(SnippetContext snippetContext) {
        this.mySnippetContext = snippetContext;
    }

    public boolean isRequisitesSatisfied() {
        Requisite[] requisiteArray = this.myParticipantMetaInfo.getRequisites();
        PatternMetaInfo patternMetaInfo = this.myParticipantMetaInfo.getParent();
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < requisiteArray.length) {
            boolean bl2;
            ParticipantMetaInfo participantMetaInfo = patternMetaInfo.getParticipant(requisiteArray[n2].getParticipantID());
            boolean bl3 = bl2 = participantMetaInfo.getCardinality() == 1 ? this.hasParticipant(requisiteArray[n2].getParticipantID()) : this.hasParticipants(requisiteArray[n2].getParticipantID());
            bl = requisiteArray[n2].shouldPresent() ? bl2 : !bl2;
            ++n2;
        }
        return bl;
    }

    public void createPatternLinks() {
        PatternLink[] patternLinkArray = this.myParticipantMetaInfo.getLinksFrom();
        int n2 = 0;
        while (n2 < patternLinkArray.length) {
            this.doCreatePatternLink(this.getAccessorHelper().getHelpersFor(patternLinkArray[n2].getTarget().getID()), patternLinkArray[n2]);
            ++n2;
        }
        patternLinkArray = this.myParticipantMetaInfo.getLinksTo();
        List<ParticipantHelper> list = Collections.singletonList(this);
        int n3 = 0;
        while (n3 < patternLinkArray.length) {
            Iterator iterator = this.getAccessorHelper().getHelpersFor(patternLinkArray[n3].getSource().getID());
            while (iterator.hasNext()) {
                ((ParticipantHelper)iterator.next()).doCreatePatternLink(list.iterator(), patternLinkArray[n3]);
            }
            ++n3;
        }
    }

    public void createPatternLink(ParticipantHelper participantHelper) {
        PatternLink[] patternLinkArray = this.myParticipantMetaInfo.getLinksFrom();
        int n2 = 0;
        while (n2 < patternLinkArray.length) {
            if (patternLinkArray[n2].getTarget() == participantHelper.getParticipantMetaInfo()) {
                this.doCreatePatternLink(Collections.singletonList(participantHelper).iterator(), patternLinkArray[n2]);
                return;
            }
            ++n2;
        }
    }

    protected boolean hasParticipant(String string) {
        return this.myPatternAccessor.getParticipant(string) != null;
    }

    protected boolean hasParticipants(String string) {
        return this.myPatternAccessor.getParticipants(string).length > 0;
    }

    private IPackageFragment getPackageFragmentFromAnotherParticipants() {
        ParticipantReference[] participantReferenceArray = this.myParticipantMetaInfo.getParticipantWithSamePackage();
        int n2 = 0;
        while (n2 < participantReferenceArray.length) {
            IType[] iTypeArray = this.myPatternAccessor.getParticipants(participantReferenceArray[n2].getParticipantRef());
            if (iTypeArray.length > 0) {
                return iTypeArray[0].getPackageFragment();
            }
            ++n2;
        }
        return null;
    }

    private boolean getParametersFrom(Object[] objectArray, IPackageFragment[] iPackageFragmentArray, String[] stringArray) {
        if (objectArray.length != 2) {
            return false;
        }
        if (!(objectArray[1] instanceof String)) {
            return false;
        }
        stringArray[0] = (String)objectArray[1];
        if (objectArray[0] instanceof IPackageFragment) {
            iPackageFragmentArray[0] = (IPackageFragment)objectArray[0];
            return true;
        }
        if (objectArray[0] == null) {
            IPackageFragment iPackageFragment = this.getPackageFragmentFromAnotherParticipants();
            if (iPackageFragment == null) {
                return false;
            }
            iPackageFragmentArray[0] = iPackageFragment;
            return true;
        }
        return false;
    }

    private String getMethodTemplate(MethodMetaInfo methodMetaInfo) {
        this.createImportsForParameters(methodMetaInfo);
        return new i(methodMetaInfo, this.myPatternAccessor, this.participantIsClass()).b();
    }

    private void createImportsForParameters(MethodMetaInfo methodMetaInfo) {
        MethodArgument[] methodArgumentArray = methodMetaInfo.isOverriding() ? this.myParticipantMetaInfo.getParent().getMethod(methodMetaInfo.getOverridedMethodID()).getArguments() : methodMetaInfo.getArguments();
        int n2 = 0;
        while (n2 < methodArgumentArray.length) {
            if (!methodArgumentArray[n2].isUnstructured() && methodArgumentArray[n2].getType().isSubjectToResolve()) {
                this.addImport(methodArgumentArray[n2].getType().getValue());
            }
            ++n2;
        }
    }

    private IMethod doCreateMethod(MethodMetaInfo methodMetaInfo, String string) {
        if (methodMetaInfo.isAbstract()) {
            this.myTargetClass.f();
            return this.myTargetClass.d(string);
        }
        return this.myTargetClass.e(string);
    }

    private String createTypeContents(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myParticipantMetaInfo.getCreationType() == ParticipantType.CLASS) {
            stringBuffer.append("public class ");
        } else {
            stringBuffer.append("public interface ");
        }
        stringBuffer.append(string);
        stringBuffer.append(" {" + h.c + "}");
        return stringBuffer.toString();
    }

    private String mergeTemplate(String string) {
        try {
            ISnippetContext iSnippetContext = Templates.createSnippetContext();
            iSnippetContext.addVariable(VAR_CONTEXT, (Object)this.getSnippetContext());
            iSnippetContext.addVariable(VAR_CLASSNAME, (Object)this.getUnderlyingType().getElementName());
            ISnippet iSnippet = Templates.createSnippet((String)string);
            return iSnippet.render(iSnippetContext);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return "Exception occured:" + coreException.getMessage();
        }
    }

    private SnippetContext getSnippetContext() {
        if (this.mySnippetContext != null) {
            return this.mySnippetContext;
        }
        return new BasicSnippetContext(this.myPatternAccessor);
    }

    private void initWithParticipant(IType iType) {
        if (iType == null) {
            h.b();
            throw new NullPointerException(h.b("ParticipantHelper.CouldNotInitWithParticipant"));
        }
        this.myTargetClass = new a(iType);
    }

    private void checkCanImplement() {
        try {
            if (this.myTargetClass.b().isInterface()) {
                StringBuffer stringBuffer = new StringBuffer();
                h.b();
                throw new IllegalStateException(stringBuffer.append(h.b("ParticipantHelper.ImplementInInterfaceRequested")).append(this.myTargetClass).toString());
            }
        }
        catch (JavaModelException javaModelException) {
            h.b().getLog().log(javaModelException.getStatus());
        }
    }

    private void ensureGeneralization() {
        if (this.myParticipantMetaInfo.hasGeneralization()) {
            this.ensureGeneralization(this.addImport(this.myParticipantMetaInfo.getGeneralizationRef()));
        }
    }

    private void ensureAbstract() {
        if (this.myParticipantMetaInfo.isAbstract()) {
            this.myTargetClass.f();
        }
    }

    private void addRole() {
        if (this.myParticipantMetaInfo.hasRole()) {
            this.myTargetClass.c(this.myParticipantMetaInfo.getRole());
        }
    }

    private void createRequiredImports() {
        ParticipantReference[] participantReferenceArray = this.myParticipantMetaInfo.getReferences();
        int n2 = 0;
        while (n2 < participantReferenceArray.length) {
            if (participantReferenceArray[n2].isSimpleImport()) {
                this.myTargetClass.b(participantReferenceArray[n2].getSimpleImport());
            } else if (participantReferenceArray[n2].isParticipantRef()) {
                this.addImport(participantReferenceArray[n2].getParticipantRef());
            }
            ++n2;
        }
    }

    private String resolveMethodNameCollision(String string, String string2) {
        DOMFactory dOMFactory = new DOMFactory();
        IDOMMethod iDOMMethod = dOMFactory.createMethod(string2);
        if (iDOMMethod == null) {
            h.b();
            String string3 = h.a("ParticipantHelper.BadMethodCode", new Object[]{string});
            h.a(string3 + ":" + string2);
            throw new IllegalStateException(string3);
        }
        if (!iDOMMethod.isConstructor()) {
            String string4 = this.myTargetClass.a(iDOMMethod.getName(), iDOMMethod.getParameterTypes());
            iDOMMethod.setName(string4);
        }
        return iDOMMethod.getContents();
    }

    private String resolveFieldNameCollision(String string) {
        DOMFactory dOMFactory = new DOMFactory();
        IDOMField iDOMField = dOMFactory.createField(string);
        if (iDOMField == null) {
            h.b();
            throw new IllegalStateException(h.a("ParticipantHelper.BadFieldCode", new Object[]{string}));
        }
        iDOMField.setName(this.myTargetClass.h(iDOMField.getName()));
        return iDOMField.getContents();
    }

    private void initTargetClass(IPackageFragment iPackageFragment, String string) throws JavaModelException {
        IPackageFragmentRoot iPackageFragmentRoot;
        if (iPackageFragment.getKind() != 1) {
            h.b();
            throw new IllegalArgumentException(h.b("ParticipantHelper.SourcePackageExpected"));
        }
        if (!iPackageFragment.exists()) {
            iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getAncestor(3);
            iPackageFragmentRoot.createPackageFragment(iPackageFragment.getElementName(), true, nullProgress);
        }
        if (!(iPackageFragmentRoot = iPackageFragment.getCompilationUnit(string + ".java")).exists()) {
            String string2 = this.createTypeContents(string);
            iPackageFragmentRoot = iPackageFragment.createCompilationUnit(iPackageFragmentRoot.getElementName(), string2, true, nullProgress);
            if (!iPackageFragment.isDefaultPackage()) {
                iPackageFragmentRoot.createPackageDeclaration(iPackageFragment.getElementName(), nullProgress);
            }
        }
        this.myTargetClass = new a(iPackageFragmentRoot.getType(string));
    }

    private IType addImport(String string) {
        IType iType = this.myPatternAccessor.getParticipant(string);
        if (iType != null) {
            this.myTargetClass.b(iType);
        } else {
            h.a("Description for participant '" + this.myParticipantMetaInfo.getID() + "' in the pattern '" + this.myParticipantMetaInfo.getParent().getID() + "' has import reference to '" + string + "' which is not set right now. This may indicade a problem in metainfo.");
        }
        return iType;
    }

    private Object getCreationValue(Object object) {
        if (object == null) {
            IPackageFragment iPackageFragment = this.getPackageFragmentFromAnotherParticipants();
            if (iPackageFragment == null) {
                h.b();
                throw new IllegalStateException(h.b("ParticipantHelper.InvalidCreationValue"));
            }
            return iPackageFragment;
        }
        return object;
    }

    private void doCreatePatternLink(Iterator iterator, PatternLink patternLink) {
        while (iterator.hasNext()) {
            ParticipantHelper participantHelper = (ParticipantHelper)iterator.next();
            String string = MessageFormat.format("@link" + h.c + "@shapeType PatternLink" + h.c + "@pattern {0}" + h.c + "@supplierRole {1}", this.myParticipantMetaInfo.getParent().getID(), participantHelper.getParticipantMetaInfo().getName());
            this.myTargetClass.a(string, participantHelper.getUnderlyingType());
        }
    }

    private AccessorHelper getAccessorHelper() {
        if (this.myAccessorHelper == null) {
            this.myAccessorHelper = new AccessorHelper(this.myParticipantMetaInfo.getParent(), this.myPatternAccessor);
        }
        return this.myAccessorHelper;
    }

    private IMethod findMethod(String string) {
        MissedPropertyResolver missedPropertyResolver = this.myPatternAccessor.setResolver(null);
        String string2 = this.myPatternAccessor.getMethodName(string);
        this.myPatternAccessor.setResolver(missedPropertyResolver);
        f f2 = new f(this.myParticipantMetaInfo.getMethod(string), this.myPatternAccessor);
        try {
            if (string2 == null) {
                return f2.c(this.getUnderlyingType());
            }
            return f2.b(this.getUnderlyingType(), string2);
        }
        catch (JavaModelException javaModelException) {
            h.a((Exception)((Object)javaModelException));
            return null;
        }
    }
}

