/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.handlers;

import com.togethersoft.selena.patterns.c.h;
import com.togethersoft.selena.patterns.handlers.MissedPropertyResolver;
import com.tssap.selena.cmf.patterns.IPattern;
import com.tssap.selena.cmf.patterns.IPatternProperty;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class PatternPropertyAccessor {
    private IPattern myPattern;
    private MissedPropertyResolver myResolver;

    public PatternPropertyAccessor(IPattern iPattern) {
        this.myPattern = iPattern;
    }

    public IType getParticipant(String string) {
        this.checkExists(string);
        this.checkIsParticipant(string);
        IType iType = this.getTypeValue(string);
        if (iType == null && this.myResolver != null) {
            iType = this.myResolver.resolveMissedParticipant(string);
        }
        return iType;
    }

    public IType[] getParticipants(String string) {
        this.checkExists(string);
        this.checkIsParticipant(string);
        return this.getTypeArrayValue(string);
    }

    public void setParticipant(String string, IType iType) {
        this.checkExists(string);
        this.checkIsParticipant(string);
        this.setValue(string, iType);
    }

    public void addParticipant(String string, IType iType) {
        if (iType == null) {
            h.b();
            throw new IllegalArgumentException(h.b("PatternPropertyAccessor.InvalidParticipantParameter"));
        }
        IType[] iTypeArray = this.getParticipants(string);
        IType[] iTypeArray2 = new IType[iTypeArray.length + 1];
        System.arraycopy(iTypeArray, 0, iTypeArray2, 0, iTypeArray.length);
        iTypeArray2[iTypeArray.length] = iType;
        this.setValue(string, iTypeArray2);
    }

    public String getFieldName(String string) {
        IMember iMember;
        this.checkExists(string);
        this.checkNotIsParticipant(string);
        String string2 = this.getStringValue(string);
        if (string2 == null && this.myResolver != null && (iMember = this.myResolver.resolveMissedField(string)) instanceof IField) {
            return iMember.getElementName();
        }
        return string2;
    }

    public String getFieldNameOrGetterCall(String string) {
        this.checkExists(string);
        this.checkNotIsParticipant(string);
        String string2 = this.getStringValue(string);
        if (string2 != null) {
            return string2;
        }
        if (this.myResolver != null) {
            IMember iMember = this.myResolver.resolveMissedField(string);
            if (iMember instanceof IField) {
                return iMember.getElementName();
            }
            if (iMember instanceof IMethod) {
                return ((IMethod)iMember).getElementName() + "()";
            }
        }
        return null;
    }

    public void setFieldName(String string, String string2) {
        this.checkExists(string);
        this.checkNotIsParticipant(string);
        this.setValue(string, string2);
    }

    public String getMethodName(String string) {
        IMethod iMethod;
        this.checkExists(string);
        this.checkNotIsParticipant(string);
        String string2 = this.getStringValue(string);
        if (string2 == null && this.myResolver != null && (iMethod = this.myResolver.resolveMissedMethod(string)) != null) {
            string2 = iMethod.getElementName();
        }
        return string2;
    }

    public void setMethodName(String string, String string2) {
        this.checkExists(string);
        this.checkNotIsParticipant(string);
        this.setValue(string, string2);
    }

    public MissedPropertyResolver setResolver(MissedPropertyResolver missedPropertyResolver) {
        MissedPropertyResolver missedPropertyResolver2 = this.myResolver;
        this.myResolver = missedPropertyResolver;
        return missedPropertyResolver2;
    }

    private IType getTypeValue(String string) {
        IPatternProperty iPatternProperty = this.myPattern.getProperty(string);
        Object object = this.myPattern.getPropertyValue(iPatternProperty);
        if (object instanceof IType) {
            return (IType)object;
        }
        return null;
    }

    private IType[] getTypeArrayValue(String string) {
        IPatternProperty iPatternProperty = this.myPattern.getProperty(string);
        Object object = this.myPattern.getPropertyValue(iPatternProperty);
        if (object instanceof IType[]) {
            return (IType[])object;
        }
        if (object instanceof IType) {
            return new IType[]{(IType)object};
        }
        return new IType[0];
    }

    private String getStringValue(String string) {
        IPatternProperty iPatternProperty = this.myPattern.getProperty(string);
        Object object = this.myPattern.getPropertyValue(iPatternProperty);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private void setValue(String string, Object object) {
        IPatternProperty iPatternProperty = this.myPattern.getProperty(string);
        if (iPatternProperty != null) {
            this.myPattern.setPropertyValue(iPatternProperty, object);
        }
    }

    private void checkExists(String string) {
        IPatternProperty iPatternProperty = this.myPattern.getProperty(string);
        if (iPatternProperty == null) {
            h.b();
            throw new IllegalArgumentException(h.a("PatternPropertyAccessor.UnknownPropertyRequested", new Object[]{string}));
        }
    }

    private void checkIsParticipant(String string) {
        IPatternProperty iPatternProperty = this.myPattern.getProperty(string);
        if (iPatternProperty != null && !iPatternProperty.isParticipant()) {
            h.b();
            throw new IllegalArgumentException(h.a("PatternPropertyAccessor.ParticipantExpected", new Object[]{string}));
        }
    }

    private void checkNotIsParticipant(String string) {
        IPatternProperty iPatternProperty = this.myPattern.getProperty(string);
        if (iPatternProperty != null && iPatternProperty.isParticipant()) {
            h.b();
            throw new IllegalArgumentException(h.a("PatternPropertyAccessor.NotParticipantExpected", new Object[]{string}));
        }
    }
}

