/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.handlers;

import com.togethersoft.selena.patterns.handlers.ParticipantHandler;
import com.togethersoft.selena.patterns.handlers.PatternPropertyAccessor;
import com.togethersoft.selena.patterns.handlers.helper.ParticipantHelper;

public abstract class AbstractParticipantHandler
implements ParticipantHandler {
    protected ParticipantHelper myHelper;
    private PatternPropertyAccessor myPatternAccessor;
    private boolean myIsParticipantSingle;

    protected AbstractParticipantHandler(ParticipantHelper participantHelper) {
        if (participantHelper == null) {
            throw new NullPointerException("Participant helper couldn't be null.");
        }
        this.myHelper = participantHelper;
        this.myPatternAccessor = this.myHelper.getPatternAccessor();
        this.myIsParticipantSingle = this.myHelper.getParticipantMetaInfo().getCardinality() == 1;
    }

    public boolean canSet(Object object) {
        if (this.myIsParticipantSingle) {
            return this.myHelper.isRequisitesSatisfied() && this.myHelper.canCreateFrom(object);
        }
        return false;
    }

    public void set(Object object) {
    }

    public boolean canAdd(Object object) {
        if (!this.myIsParticipantSingle) {
            return this.myHelper.isRequisitesSatisfied() && this.myHelper.canCreateFrom(object);
        }
        return false;
    }

    public void add(Object object) {
    }

    public final String getParticipantID() {
        return this.myHelper.getParticipantMetaInfo().getID();
    }
}

