/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.generate;

import com.togethersoft.selena.patterns.c.h;
import com.togethersoft.selena.patterns.generate.PatternCategory;
import com.togethersoft.selena.patterns.generate.PatternDescription;
import com.togethersoft.selena.patterns.generate.PatternDescriptionScope;
import com.togethersoft.selena.patterns.generate.PatternDescriptionSource;
import com.togethersoft.selena.patterns.generate.PatternDescriptionSourceListener;
import com.togethersoft.selena.patterns.generate.PatternDescriptionsAccess$1;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;

public final class PatternDescriptionsAccess {
    public static final String PT_PATTERN2GENERATE = "patterns2generate";
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_SOURCE = "descriptionSource";
    public static final String ATTR_CATEGORY_ID = "id";
    public static final String ATTR_CATEGORY_PATH = "path";
    public static final String ATTR_CATEGORY_NAME = "name";
    public static final String ATTR_PATTERN_CLASS = "class";
    public static final String ATTR_SOURCE_CLASS = "class";
    private static final PatternDescription[] EMPTY_DESCRIPTION = new PatternDescription[0];
    private static PatternDescriptionsAccess myInstance;
    private PatternDescription[] myPlugged;
    private ArrayList myRegistered;
    private Map myKnownPatternsCache;
    private Map myScopeToDescSet;
    private final PatternDescriptionSourceListener mySourceListener = new PatternDescriptionsAccess$1(this);

    private PatternDescriptionsAccess() {
    }

    public static PatternDescriptionsAccess getInstance() {
        if (myInstance == null) {
            myInstance = new PatternDescriptionsAccess();
        }
        return myInstance;
    }

    public PatternDescription[] getKnownPatterns() {
        if (this.myPlugged == null) {
            this.initPlugged();
        }
        PatternDescription[] patternDescriptionArray = this.myRegistered != null ? this.myRegistered.toArray(new PatternDescription[this.myRegistered.size()]) : EMPTY_DESCRIPTION;
        PatternDescription[] patternDescriptionArray2 = new PatternDescription[this.myPlugged.length + patternDescriptionArray.length];
        System.arraycopy(this.myPlugged, 0, patternDescriptionArray2, 0, this.myPlugged.length);
        System.arraycopy(patternDescriptionArray, 0, patternDescriptionArray2, this.myPlugged.length, patternDescriptionArray.length);
        return patternDescriptionArray2;
    }

    public PatternDescription getPatternByID(String string) {
        if (this.myKnownPatternsCache == null) {
            PatternDescription[] patternDescriptionArray = this.getKnownPatterns();
            this.myKnownPatternsCache = new HashMap(patternDescriptionArray.length * 4 / 3);
            int n2 = 0;
            while (n2 < patternDescriptionArray.length) {
                this.cachePattern(patternDescriptionArray[n2]);
                ++n2;
            }
        }
        return (PatternDescription)this.myKnownPatternsCache.get(string);
    }

    public Set getPatternsByScope(PatternDescriptionScope patternDescriptionScope) {
        if (this.myPlugged == null) {
            this.initPlugged();
        }
        if (this.myScopeToDescSet.containsKey(patternDescriptionScope)) {
            return Collections.unmodifiableSet((Set)this.myScopeToDescSet.get(patternDescriptionScope));
        }
        h.a("Unknown scope:" + patternDescriptionScope);
        return Collections.EMPTY_SET;
    }

    public PatternCategory getRootCategory() {
        if (this.myPlugged == null) {
            this.initPlugged();
        }
        return PatternCategory.getRootCategory();
    }

    public void registerDescription(PatternDescription patternDescription) {
        if (patternDescription == null) {
            throw new NullPointerException();
        }
        if (this.myRegistered == null) {
            this.myRegistered = new ArrayList();
        }
        this.myRegistered.add(patternDescription);
        if (this.myKnownPatternsCache != null) {
            this.cachePattern(patternDescription);
        }
        patternDescription.getCategory().registerPattern(patternDescription);
        this.getScopedPatterns(patternDescription.getScope()).add(patternDescription);
    }

    public void unregisterDescription(PatternDescription patternDescription) {
        if (patternDescription == null) {
            throw new NullPointerException();
        }
        if (this.myRegistered != null) {
            ((AbstractCollection)this.myRegistered).remove(patternDescription);
            if (this.myKnownPatternsCache != null) {
                this.myKnownPatternsCache.remove(patternDescription.getPatternID());
            }
        }
        this.getScopedPatterns(patternDescription.getScope()).remove(patternDescription);
    }

    private void initPlugged() {
        IExtensionPoint iExtensionPoint = h.b().getDescriptor().getExtensionPoint(PT_PATTERN2GENERATE);
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        this.myScopeToDescSet = new HashMap();
        ArrayList arrayList = new ArrayList(iConfigurationElementArray.length);
        int n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            try {
                Object object;
                if (TAG_CATEGORY.equals(iConfigurationElementArray[n2].getName())) {
                    PatternDescriptionsAccess.initCategory(iConfigurationElementArray[n2]);
                } else if (TAG_PATTERN.equals(iConfigurationElementArray[n2].getName())) {
                    object = (PatternDescription)iConfigurationElementArray[n2].createExecutableExtension("class");
                    this.addPatternDesc(arrayList, (PatternDescription)object);
                } else if (TAG_SOURCE.equals(iConfigurationElementArray[n2].getName())) {
                    object = (PatternDescriptionSource)iConfigurationElementArray[n2].createExecutableExtension("class");
                    object.addSourceListener(this.mySourceListener);
                    this.addPatternDesc(arrayList, object.getDescriptions());
                }
            }
            catch (Exception exception) {
                h.a(exception);
            }
            ++n2;
        }
        this.myPlugged = arrayList.toArray(new PatternDescription[arrayList.size()]);
    }

    private static void initCategory(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(ATTR_CATEGORY_ID);
        String string2 = iConfigurationElement.getAttribute(ATTR_CATEGORY_NAME);
        String string3 = iConfigurationElement.getAttribute(ATTR_CATEGORY_PATH);
        if (string == null || string2 == null || string3 == null) {
            h.a("Skipping configuration element for category:" + iConfigurationElement + ", id=" + string + ", name=" + string2 + ", path=" + string3);
            return;
        }
        if (PatternCategory.getPatternCategory(string3, string, string2) == null) {
            throw new IllegalStateException(iConfigurationElement.toString());
        }
    }

    private void addPatternDesc(List list, PatternDescription patternDescription) {
        patternDescription.getCategory().registerPattern(patternDescription);
        list.add(patternDescription);
        if (h.b().isDebugging()) {
            System.out.println("Registering pattern description:" + patternDescription.getPatternID() + " into " + patternDescription.getCategory().getID());
        }
        this.getScopedPatterns(patternDescription.getScope()).add(patternDescription);
    }

    private void addPatternDesc(List list, PatternDescription[] patternDescriptionArray) {
        int n2 = 0;
        while (n2 < patternDescriptionArray.length) {
            this.addPatternDesc(list, patternDescriptionArray[n2]);
            ++n2;
        }
    }

    private Set getScopedPatterns(PatternDescriptionScope patternDescriptionScope) {
        Set set;
        if (this.myScopeToDescSet.containsKey(patternDescriptionScope)) {
            set = (Set)this.myScopeToDescSet.get(patternDescriptionScope);
        } else {
            set = new HashSet();
            this.myScopeToDescSet.put(patternDescriptionScope, set);
        }
        return set;
    }

    private void cachePattern(PatternDescription patternDescription) {
        this.myKnownPatternsCache.put(patternDescription.getPatternID(), patternDescription);
    }
}

