/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.generate;

import com.togethersoft.selena.patterns.generate.AbstractPropertyDescription;
import com.togethersoft.selena.patterns.generate.MetaInfoPatternDescription;
import com.togethersoft.selena.patterns.generate.PatternConfigPropertyPD$DefaultListener;
import com.togethersoft.selena.patterns.metainfo.PatternConfigProperty;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PatternConfigPropertyPD
extends AbstractPropertyDescription {
    protected MetaInfoPatternDescription myPatternDesc;
    protected PatternConfigProperty myPCP;
    private Control myControl;

    public PatternConfigPropertyPD(MetaInfoPatternDescription metaInfoPatternDescription, PatternConfigProperty patternConfigProperty) {
        super(patternConfigProperty.getName());
        this.myPatternDesc = metaInfoPatternDescription;
        this.myPCP = patternConfigProperty;
    }

    public Control createRenderingEditor(Composite composite) {
        this.myControl = this.myPCP.getType() == 4 ? this.createBooleanControl(composite) : (this.myPCP.getType() == 1 ? this.createChoiceControl(composite) : this.createTextControl(composite));
        return this.myControl;
    }

    protected Control createBooleanControl(Composite composite) {
        Button button = new Button(composite, 32);
        Boolean bl = (Boolean)this.myPatternDesc.getGenValue(this.myPCP.getID());
        button.setSelection(bl.booleanValue());
        button.addSelectionListener(this.createSelectionListener());
        return button;
    }

    protected Control createChoiceControl(Composite composite) {
        Combo combo = new Combo(composite, 12);
        combo.setItems(this.myPCP.getChoices().getDescriptions());
        String string = (String)this.myPatternDesc.getGenValue(this.myPCP.getID());
        combo.select(this.myPCP.getChoices().getIndexOf(string));
        combo.addSelectionListener(this.createSelectionListener());
        return combo;
    }

    protected Control createTextControl(Composite composite) {
        Text text = new Text(composite, 4);
        text.setText((String)this.myPatternDesc.getGenValue(this.myPCP.getID()));
        text.addModifyListener(this.createModifyListener());
        return text;
    }

    protected void propertyChanged() {
        this.myPatternDesc.firePropertyChanged(this);
    }

    protected ModifyListener createModifyListener() {
        return new PatternConfigPropertyPD$DefaultListener(this);
    }

    protected SelectionListener createSelectionListener() {
        return new PatternConfigPropertyPD$DefaultListener(this);
    }
}

