/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.generate;

import com.togethersoft.selena.patterns.c.h;
import com.togethersoft.selena.patterns.generate.PatternCategoryVisitor;
import com.togethersoft.selena.patterns.generate.PatternDescription;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class PatternCategory {
    private PatternCategory myParent;
    private String myID;
    private String myDisplayName;
    private ArrayList myChildren;
    private ArrayList myPatterns;
    private static PatternCategory ROOT;
    private static final PatternCategory[] EMPTY_CAT;
    private static final PatternDescription[] EMPTY_PATTERNS;

    private PatternCategory() {
        this.myParent = this;
        this.myID = "";
        this.myDisplayName = "";
    }

    private PatternCategory(PatternCategory patternCategory, String string) {
        if (patternCategory == null || string == null) {
            throw new NullPointerException();
        }
        this.myParent = patternCategory;
        this.myID = string;
        patternCategory.registerChild(this);
    }

    public String getID() {
        return this.myID;
    }

    public String getDisplayName() {
        if (this.myDisplayName == null) {
            return "";
        }
        return this.myDisplayName;
    }

    public PatternCategory getParent() {
        return this.myParent;
    }

    public PatternCategory[] getChildren() {
        if (this.myChildren == null) {
            return EMPTY_CAT;
        }
        return this.myChildren.toArray(new PatternCategory[this.myChildren.size()]);
    }

    public PatternDescription[] getPatterns() {
        if (this.myPatterns == null) {
            return EMPTY_PATTERNS;
        }
        return this.myPatterns.toArray(new PatternDescription[this.myPatterns.size()]);
    }

    public void accept(PatternCategoryVisitor patternCategoryVisitor) {
        Iterator iterator;
        boolean bl = true;
        if (this.myPatterns != null) {
            iterator = ((AbstractList)this.myPatterns).iterator();
            while (bl && iterator.hasNext()) {
                bl = patternCategoryVisitor.visit((PatternDescription)iterator.next());
            }
        }
        if (this.myChildren == null) {
            return;
        }
        iterator = ((AbstractList)this.myChildren).iterator();
        while (iterator.hasNext()) {
            PatternCategory patternCategory = (PatternCategory)iterator.next();
            if (!patternCategoryVisitor.visit(patternCategory)) continue;
            patternCategory.accept(patternCategoryVisitor);
        }
    }

    void registerPattern(PatternDescription patternDescription) {
        if (patternDescription.getCategory() != this) {
            h.b();
            throw new IllegalArgumentException(h.b("PatternCategory.WrongCategory"));
        }
        if (this.myPatterns == null) {
            this.myPatterns = new ArrayList();
        }
        this.myPatterns.add(patternDescription);
    }

    private void registerChild(PatternCategory patternCategory) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList(3);
        }
        this.myChildren.add(patternCategory);
    }

    private void setDisplayName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.myDisplayName = string;
    }

    static PatternCategory getRootCategory() {
        if (ROOT == null) {
            ROOT = new PatternCategory();
        }
        return ROOT;
    }

    public static PatternCategory getPatternCategory(String string, String string2, String string3) {
        if (string == null) {
            string = "";
        }
        return PatternCategory.getPatternCategory(PatternCategory.getPatternCategory(string), string2, string3);
    }

    public static PatternCategory getPatternCategory(PatternCategory patternCategory, String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        PatternCategory patternCategory2 = PatternCategory.findOrCreateChild(patternCategory, string);
        patternCategory2.setDisplayName(string2);
        return patternCategory2;
    }

    public static PatternCategory getPatternCategory(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        PatternCategory patternCategory = PatternCategory.getRootCategory();
        while (stringTokenizer.hasMoreTokens()) {
            patternCategory = PatternCategory.findOrCreateChild(patternCategory, stringTokenizer.nextToken());
        }
        return patternCategory;
    }

    private static PatternCategory findOrCreateChild(PatternCategory patternCategory, String string) {
        PatternCategory[] patternCategoryArray = patternCategory.getChildren();
        int n2 = 0;
        while (n2 < patternCategoryArray.length) {
            if (patternCategoryArray[n2].getID().equals(string)) {
                return patternCategoryArray[n2];
            }
            ++n2;
        }
        PatternCategory patternCategory2 = new PatternCategory(patternCategory, string);
        h.b();
        patternCategory2.setDisplayName(h.a("PatternCategory.DeclarationNotFound", new Object[]{string}));
        return patternCategory2;
    }

    static {
        EMPTY_CAT = new PatternCategory[0];
        EMPTY_PATTERNS = new PatternDescription[0];
    }
}

