/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.generate;

import com.togethersoft.selena.patterns.c.h;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaSelectionExtractor {
    private final Object[] myWholeSelection;
    private final Set myJavaElements;
    private Set myPackages;
    private Set myITypes;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public JavaSelectionExtractor(Object[] objectArray) {
        this.myWholeSelection = objectArray;
        this.myJavaElements = this.extractJavaElements();
    }

    public boolean hasPackage() {
        if (this.myJavaElements.isEmpty()) {
            return false;
        }
        this.findPackages();
        return !this.myPackages.isEmpty();
    }

    public IPackageFragment getFirstPackage() {
        if (this.hasPackage()) {
            return (IPackageFragment)this.myPackages.iterator().next();
        }
        throw new IllegalStateException();
    }

    public boolean hasType() {
        if (this.myJavaElements.isEmpty()) {
            return false;
        }
        this.findITypes();
        return !this.myITypes.isEmpty();
    }

    public IType getFirstType() {
        if (this.hasType()) {
            return (IType)this.myITypes.iterator().next();
        }
        throw new IllegalStateException();
    }

    public static IPackageFragment getDefaultSourcePackage(IJavaProject iJavaProject) {
        IPackageFragment iPackageFragment = JavaSelectionExtractor.getSourcePackage(iJavaProject, "");
        if (iPackageFragment != null) {
            return iPackageFragment;
        }
        throw new IllegalStateException("Failed to find default package");
    }

    private static IPackageFragment getSourcePackage(IJavaProject iJavaProject, String string) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            int n2 = 0;
            while (n2 < iPackageFragmentRootArray.length) {
                if (iPackageFragmentRootArray[n2].getKind() == 1) {
                    return iPackageFragmentRootArray[n2].getPackageFragment(string);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private void findPackages() {
        if (this.myPackages != null) {
            return;
        }
        this.myPackages = new HashSet();
        Iterator iterator = this.myJavaElements.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof IPackageFragment)) continue;
            this.myPackages.add(e2);
        }
    }

    private void findITypes() {
        if (this.myITypes != null) {
            return;
        }
        this.myITypes = new HashSet();
        Iterator iterator = this.myJavaElements.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof IType) {
                this.myITypes.add(e2);
                continue;
            }
            try {
                if (!(e2 instanceof ICompilationUnit) || ((ICompilationUnit)e2).getTypes().length != 1) continue;
                this.myITypes.add(((ICompilationUnit)e2).getTypes()[0]);
            }
            catch (JavaModelException javaModelException) {
                h.a((Exception)((Object)javaModelException));
            }
        }
    }

    private Set extractJavaElements() {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n2 = 0;
        while (n2 < this.myWholeSelection.length) {
            Object object;
            if (this.myWholeSelection[n2] instanceof IJavaElement) {
                hashSet.add(this.myWholeSelection[n2]);
            } else if (this.myWholeSelection[n2] instanceof IAdaptable && (object = Platform.getAdapterManager().getAdapter(this.myWholeSelection[n2], class$org$eclipse$jdt$core$IJavaElement == null ? JavaSelectionExtractor.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement)) != null) {
                hashSet.add(object);
            }
            ++n2;
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

