/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.patterns.generate;

import com.togethersoft.selena.patterns.generate.PropertyDescription;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractPropertyDescription
implements PropertyDescription {
    private String myDisplayName;
    private boolean myIsEnabled = true;
    private int myValidState = 0;
    private String myValidMessage;

    protected AbstractPropertyDescription(String string) {
        this.myDisplayName = string;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public Image getImage() {
        return null;
    }

    public boolean isEnabled() {
        return this.myIsEnabled;
    }

    public boolean checkValidState(int n2) {
        return this.myValidState == n2 || (this.myValidState & n2) != 0;
    }

    public String getMessage(int n2) {
        return this.myValidMessage;
    }

    public void clearErrors() {
        this.myValidState = 0;
        this.myValidMessage = null;
    }

    protected void setError(String string) {
        if (string == null) {
            this.clearAll();
            return;
        }
        if (this.checkValidState(2) && this.myValidMessage == string) {
            return;
        }
        this.myValidState = 2;
        this.myValidMessage = string;
        this.propertyChanged();
    }

    protected void clearAll() {
        if (!this.checkValidState(0)) {
            this.clearErrors();
            this.propertyChanged();
        }
    }

    protected void setEnabled(boolean bl) {
        if (this.myIsEnabled != bl) {
            this.myIsEnabled = bl;
            this.propertyChanged();
        }
    }

    protected abstract void propertyChanged();

    public abstract Control createRenderingEditor(Composite var1);
}

