/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.webapp;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class WebAppPlugin
extends Plugin {
    public static final String ID = "com.tssap.j2ee.core.webapp";
    private boolean myTracing;
    private static WebAppPlugin ourInstance;

    public WebAppPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
    }

    public static WebAppPlugin getDefault() {
        return ourInstance;
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public static void logInfo(String text) {
        WebAppPlugin instance = WebAppPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        WebAppPlugin.log(1, text);
    }

    public static void logError(String text) {
        WebAppPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        WebAppPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        WebAppPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        WebAppPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        WebAppPlugin instance = WebAppPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            WebAppPlugin.log(type, text, new Throwable());
        } else {
            WebAppPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        WebAppPlugin instance = WebAppPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

