/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.webapp;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.core.web.IFilter;
import com.tssap.j2ee.core.web.IHttpSessionActivationListener;
import com.tssap.j2ee.core.web.IHttpSessionAttributeListener;
import com.tssap.j2ee.core.web.IHttpSessionBindingListener;
import com.tssap.j2ee.core.web.IHttpSessionListener;
import com.tssap.j2ee.core.web.IJSP;
import com.tssap.j2ee.core.web.IServlet;
import com.tssap.j2ee.core.web.IServletContextAttributeListener;
import com.tssap.j2ee.core.web.IServletContextListener;
import com.tssap.j2ee.core.web.IWebElement;
import com.tssap.j2ee.core.web.IWebElementAcceptor;
import com.tssap.j2ee.core.web.IWebListener;
import com.tssap.j2ee.core.web.IWebMethod;
import com.tssap.j2ee.core.web.WebProject;
import com.tssap.j2ee.core.webapp.Filter;
import com.tssap.j2ee.core.webapp.Listener;
import com.tssap.j2ee.core.webapp.Servlet;
import com.tssap.j2ee.core.webapp.WebApp;
import com.tssap.j2ee.core.webapp.WebAppProject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class AssembledInfoFinder {
    private AssembledInfoFinder() {
    }

    public static WebAppProject[] findDependentAssemblyProjects(WebProject webProject) {
        ArrayList<WebAppProject> result = new ArrayList<WebAppProject>();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(webProject.getProject());
        if (possibleReferencers != null) {
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                WebAppProject project = WebAppProject.getInstance((IProject)it.next());
                if (project == null) continue;
                result.add(project);
            }
        }
        return result.toArray(new WebAppProject[result.size()]);
    }

    public static Servlet[] findAssembledServlets(IServlet servlet) {
        return AssembledInfoFinder.findAssembledServlets(servlet, false);
    }

    public static Servlet[] findAssembledServlets(IServlet servlet, boolean excludeReadOnly) {
        ArrayList<Servlet> result = new ArrayList<Servlet>();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(servlet.getWebProject().getProject());
        if (possibleReferencers != null) {
            String expectedClass = servlet.getTypeName();
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                WebApp[] dds;
                WebAppProject project = WebAppProject.getInstance((IProject)it.next());
                if (project == null || (dds = project.getWebApps()) == null) continue;
                int i = 0;
                while (i < dds.length) {
                    Servlet[] servlets;
                    if (!(excludeReadOnly && dds[i].getFile().isReadOnly() || (servlets = dds[i].getServlets()) == null)) {
                        int j = 0;
                        while (j < servlets.length) {
                            String servletClass = servlets[j].getClassName();
                            if (servletClass != null && servletClass.equals(expectedClass)) {
                                result.add(servlets[j]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return result.toArray(new Servlet[result.size()]);
    }

    public static Filter[] findAssembledFilters(IFilter filter) {
        return AssembledInfoFinder.findAssembledFilters(filter, false);
    }

    public static Filter[] findAssembledFilters(IFilter filter, boolean excludeReadOnly) {
        ArrayList<Filter> result = new ArrayList<Filter>();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(filter.getWebProject().getProject());
        if (possibleReferencers != null) {
            String expectedClass = filter.getTypeName();
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                WebApp[] dds;
                WebAppProject project = WebAppProject.getInstance((IProject)it.next());
                if (project == null || (dds = project.getWebApps()) == null) continue;
                int i = 0;
                while (i < dds.length) {
                    Filter[] filters;
                    if (!(excludeReadOnly && dds[i].getFile().isReadOnly() || (filters = dds[i].getFilters()) == null)) {
                        int j = 0;
                        while (j < filters.length) {
                            String filterClass = filters[j].getClassName();
                            if (filterClass != null && filterClass.equals(expectedClass)) {
                                result.add(filters[j]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return result.toArray(new Filter[result.size()]);
    }

    public static Servlet[] findAssembledJSPs(IFile jspFiles) {
        return AssembledInfoFinder.findAssembledJSPs(jspFiles, false);
    }

    public static Servlet[] findAssembledJSPs(IFile jspFile, boolean excludeReadOnly) {
        ArrayList<Servlet> result = new ArrayList<Servlet>();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(jspFile.getProject());
        if (possibleReferencers != null) {
            String expectedFile = jspFile.getProjectRelativePath().toString();
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                WebApp[] dds;
                WebAppProject project = WebAppProject.getInstance((IProject)it.next());
                if (project == null || (dds = project.getWebApps()) == null) continue;
                int i = 0;
                while (i < dds.length) {
                    Servlet[] servlets;
                    if (!(excludeReadOnly && dds[i].getFile().isReadOnly() || (servlets = dds[i].getServlets()) == null)) {
                        int j = 0;
                        while (j < servlets.length) {
                            String servletFile = servlets[j].getFileName();
                            if (servletFile != null && servletFile.equals(expectedFile)) {
                                result.add(servlets[j]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return result.toArray(new Servlet[result.size()]);
    }

    public static Listener[] findAssembledListeners(IWebListener listener) {
        return AssembledInfoFinder.findAssembledListeners(listener, false);
    }

    public static Listener[] findAssembledListeners(IWebListener listener, boolean excludeReadOnly) {
        ArrayList<Listener> result = new ArrayList<Listener>();
        Collection possibleReferencers = UtilsPlugin.getDefault().getProjectDependencyCache().getAllReferencingProjects(listener.getWebProject().getProject());
        if (possibleReferencers != null) {
            String expectedClass = listener.getTypeName();
            Iterator it = possibleReferencers.iterator();
            while (it.hasNext()) {
                WebApp[] dds;
                WebAppProject project = WebAppProject.getInstance((IProject)it.next());
                if (project == null || (dds = project.getWebApps()) == null) continue;
                int i = 0;
                while (i < dds.length) {
                    Listener[] listeners;
                    if (!(excludeReadOnly && dds[i].getFile().isReadOnly() || (listeners = dds[i].getListeners()) == null)) {
                        int j = 0;
                        while (j < listeners.length) {
                            String listenerClass = listeners[j].getClassName();
                            if (listenerClass != null && listenerClass.equals(expectedClass)) {
                                result.add(listeners[j]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return result.toArray(new Listener[result.size()]);
    }

    public static DescriptorEntity[] findAssembledWebObjects(IWebElement element) {
        return AssembledInfoFinder.findAssembledWebObjects(element, false);
    }

    public static DescriptorEntity[] findAssembledWebObjects(IWebElement element, boolean excludeReadOnly) {
        Dispatcher dispatcher = new Dispatcher(excludeReadOnly);
        element.dispatch((IWebElementAcceptor)dispatcher);
        return dispatcher.getCollectedEntities();
    }

    private static class Dispatcher
    implements IWebElementAcceptor {
        private DescriptorEntity[] myCollectedEntities;
        private boolean myExcludeReadOnly;

        public Dispatcher(boolean excludeReadOnly) {
            this.myExcludeReadOnly = excludeReadOnly;
        }

        public DescriptorEntity[] getCollectedEntities() {
            return this.myCollectedEntities;
        }

        public void consider(IFilter filter) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledFilters(filter, this.myExcludeReadOnly);
        }

        public void consider(IHttpSessionAttributeListener listener) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledListeners((IWebListener)listener, this.myExcludeReadOnly);
        }

        public void consider(IHttpSessionBindingListener listener) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledListeners((IWebListener)listener, this.myExcludeReadOnly);
        }

        public void consider(IHttpSessionActivationListener listener) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledListeners((IWebListener)listener, this.myExcludeReadOnly);
        }

        public void consider(IHttpSessionListener listener) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledListeners((IWebListener)listener, this.myExcludeReadOnly);
        }

        public void consider(IJSP jsp) {
        }

        public void consider(IServlet servlet) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledServlets(servlet, this.myExcludeReadOnly);
        }

        public void consider(IServletContextAttributeListener listener) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledListeners((IWebListener)listener, this.myExcludeReadOnly);
        }

        public void consider(IServletContextListener listener) {
            this.myCollectedEntities = AssembledInfoFinder.findAssembledListeners((IWebListener)listener, this.myExcludeReadOnly);
        }

        public void consider(IWebMethod method) {
        }

        public void consider(WebProject project) {
        }
    }
}

