/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.vi.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.vi.InterfaceType;
import com.sap.ide.metamodel.vi.implementation.EndpointReferenceState;
import com.sap.ide.metamodel.vi.implementation.FunctionState;
import com.sap.ide.metamodel.vi.implementation.SoapExtensionVIState;
import com.sap.ide.metamodel.vi.implementation.TypeState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class VirtualInterfaceState
extends DevelopmentObjectState
implements MainDevelopmentObjectState {
    private String mMetamodelRelease = null;
    private String mMetamodelVersion = null;
    private String mMetamodelTimestamp = null;
    protected String mPackage = null;
    private String mMasterLanguage = null;
    private boolean mChangeable = true;
    private boolean mHasChangeable = false;
    private String mGuid = null;
    private boolean mHasGuid = false;
    private String mInterfaceType = "ejb";
    private boolean mHasInterfaceType = false;
    private EndpointReferenceState mEndpointReference = null;
    private Vector mFunctions = new Vector();
    private SoapExtensionVIState mSoapExtensionVI = null;
    private HashMap mTypes = new HashMap();

    VirtualInterfaceState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        VirtualInterfaceState lState = (VirtualInterfaceState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            return false;
        }
        if (!String.valueOf(this.mChangeable).equals(String.valueOf(lState.mChangeable))) {
            return false;
        }
        if (!String.valueOf(this.mGuid).equals(String.valueOf(lState.mGuid))) {
            return false;
        }
        return String.valueOf(this.mInterfaceType).equals(String.valueOf(lState.mInterfaceType));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        VirtualInterfaceState lState = (VirtualInterfaceState)object;
        if (!isRootObject && !this.mPackage.equals(lState.mPackage)) {
            compareContext.addPropertyDelta(sourceObject, "package", (Object)lState.mPackage);
        }
        if (!String.valueOf(this.mChangeable).equals(String.valueOf(lState.mChangeable))) {
            compareContext.addPropertyDelta(sourceObject, "changeable", (Object)new Boolean(lState.mChangeable));
        }
        if (!String.valueOf(this.mGuid).equals(String.valueOf(lState.mGuid))) {
            compareContext.addPropertyDelta(sourceObject, "guid", (Object)lState.mGuid);
        }
        if (!String.valueOf(this.mInterfaceType).equals(String.valueOf(lState.mInterfaceType))) {
            compareContext.addPropertyDelta(sourceObject, "interfaceType", (Object)InterfaceType.valueOf(lState.mInterfaceType));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VirtualInterfaceState lState = (VirtualInterfaceState)((Object)super.clone());
        if (this.mEndpointReference != null) {
            lState.mEndpointReference = (EndpointReferenceState)((Object)this.mEndpointReference.clone());
        }
        lState.mFunctions = new Vector();
        int i = 0;
        while (i < this.mFunctions.size()) {
            lState.mFunctions.add(((FunctionState)((Object)this.mFunctions.get(i))).clone());
            ++i;
        }
        if (this.mSoapExtensionVI != null) {
            lState.mSoapExtensionVI = (SoapExtensionVIState)((Object)this.mSoapExtensionVI.clone());
        }
        lState.mTypes = new HashMap();
        Iterator it = this.mTypes.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mTypes.put(lKey, ((TypeState)((Object)this.mTypes.get(lKey))).clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        if (this.mEndpointReference != null) {
            this.mEndpointReference.removeExternalReferences(innerObjectKeys);
        }
        Iterator it = ((AbstractList)this.mFunctions).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        if (this.mSoapExtensionVI != null) {
            this.mSoapExtensionVI.removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mTypes.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.setPackage(clipboardService.getNewPackage(this.mProxyRef));
            this.mProxyRef = null;
        }
        if (this.mEndpointReference != null) {
            if (clipboardService.isExcluded((Reference)this.mEndpointReference.getProxyReference())) {
                this.mEndpointReference = null;
            } else {
                this.mEndpointReference.refactor(clipboardService);
            }
        }
        Iterator it = ((AbstractList)this.mFunctions).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        if (this.mSoapExtensionVI != null) {
            if (clipboardService.isExcluded((Reference)this.mSoapExtensionVI.getProxyReference())) {
                this.mSoapExtensionVI = null;
            } else {
                this.mSoapExtensionVI.refactor(clipboardService);
            }
        }
        Iterator it2 = this.mTypes.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        if (this.mEndpointReference != null) {
            this.mEndpointReference.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it = ((AbstractList)this.mFunctions).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSoapExtensionVI != null) {
            this.mSoapExtensionVI.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = this.mTypes.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String newPackage) {
        this.mPackage = newPackage;
    }

    public String getMasterLanguage() {
        return this.mMasterLanguage;
    }

    public void setMasterLanguage(String language) {
        this.mMasterLanguage = language;
    }

    public String _getMetamodelRelease() {
        return this.mMetamodelRelease;
    }

    public String _getMetamodelVersion() {
        return this.mMetamodelVersion;
    }

    public String _getMetamodelTimestamp() {
        return this.mMetamodelTimestamp;
    }

    void setChangeable(boolean value) {
        this.mChangeable = value;
        this.mHasChangeable = true;
    }

    boolean getChangeable() {
        return this.mChangeable;
    }

    boolean hasChangeable() {
        return this.mHasChangeable;
    }

    void setGuid(String value) {
        if (value == null) {
            this.unsetGuid();
            return;
        }
        this.mGuid = value;
        this.mHasGuid = true;
    }

    String getGuid() {
        return this.mGuid;
    }

    boolean hasGuid() {
        return this.mHasGuid;
    }

    void unsetGuid() {
        this.mGuid = null;
        this.mHasGuid = false;
    }

    void setInterfaceType(String value) {
        this.mInterfaceType = value;
        this.mHasInterfaceType = true;
    }

    String getInterfaceType() {
        return this.mInterfaceType;
    }

    boolean hasInterfaceType() {
        return this.mHasInterfaceType;
    }

    public Reference getParent() {
        return null;
    }

    public void setParent(Reference parentReference) {
    }

    void setEndpointReference(EndpointReferenceState state) {
        this.mEndpointReference = state;
    }

    EndpointReferenceState getEndpointReference() {
        return this.mEndpointReference;
    }

    void setSoapExtensionVI(SoapExtensionVIState state) {
        this.mSoapExtensionVI = state;
    }

    SoapExtensionVIState getSoapExtensionVI() {
        return this.mSoapExtensionVI;
    }

    void addFunction(FunctionState state) {
        this.mFunctions.add(state);
    }

    void addFunction(FunctionState state, int position) {
        this.mFunctions.add(position, state);
    }

    int getFunctionCount() {
        return this.mFunctions.size();
    }

    FunctionState getFunction(String name) {
        int i = 0;
        while (i < this.mFunctions.size()) {
            FunctionState lState = (FunctionState)((Object)this.mFunctions.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getFunctions() {
        return this.mFunctions;
    }

    void removeFunction(FunctionState state) {
        this.mFunctions.remove((Object)state);
    }

    void removeAllFunctions() {
        this.mFunctions.clear();
    }

    void addType(TypeState state) {
        this.mTypes.put(state.getName().toLowerCase(), state);
    }

    int getTypeCount() {
        return this.mTypes.size();
    }

    TypeState getType(String name) {
        return (TypeState)((Object)this.mTypes.get(name.toLowerCase()));
    }

    Vector getTypes() {
        return new Vector(this.mTypes.values());
    }

    void removeType(String aggregationKey) {
        this.mTypes.remove(aggregationKey.toLowerCase());
    }

    void removeType(TypeState state) {
        this.mTypes.remove(state.getName().toLowerCase());
    }

    void removeAllTypes() {
        this.mTypes.clear();
    }

    void moveFunction(int fromPosition, int toPosition) {
        this.mFunctions.add(toPosition, this.mFunctions.remove(fromPosition));
    }

    void reorderFunctions(Vector orderedStates) {
        this.mFunctions = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("mmRelease")) {
            this.mMetamodelRelease = (String)value;
        } else if (propertyName.equals("mmVersion")) {
            this.mMetamodelVersion = (String)value;
        } else if (propertyName.equals("mmTimestamp")) {
            this.mMetamodelTimestamp = (String)value;
        } else if (propertyName.equals("changeable")) {
            this.setChangeable(new Boolean((String)value));
        } else if (propertyName.equals("guid")) {
            this.setGuid((String)value);
        } else if (propertyName.equals("interfaceType")) {
            if (InterfaceType.valueOf((String)value) != null) {
                this.setInterfaceType((String)value);
            }
        } else if (propertyName.equals("name")) {
            this.setName((String)value);
        } else if (propertyName.equals("package")) {
            this.setPackage((String)value);
        } else if (propertyName.equals("masterLanguage")) {
            this.setMasterLanguage((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("EndpointReference")) {
            this.setEndpointReference((EndpointReferenceState)((Object)data));
        } else if (roleName.equals("Functions")) {
            this.addFunction((FunctionState)((Object)data));
        } else if (roleName.equals("SoapExtensionVI")) {
            this.setSoapExtensionVI((SoapExtensionVIState)((Object)data));
        } else if (roleName.equals("Types")) {
            this.addType((TypeState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

