/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.vi.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.vi.implementation.DefaultValueState;
import com.sap.ide.metamodel.vi.implementation.FieldReferenceState;
import com.sap.ide.metamodel.vi.implementation.MappableItemState;
import com.sap.ide.metamodel.vi.implementation.SoapExtensionParameterState;
import com.sap.ide.metamodel.vi.implementation.TypeReferenceState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class ParameterState
extends MappableItemState {
    private boolean mIsExposed = true;
    private boolean mHasIsExposed = false;
    private boolean mIsOptional = false;
    private boolean mHasIsOptional = false;
    private DefaultValueState mDefaultValue = null;
    private HashMap mFieldReferences = new HashMap();
    private TypeReferenceState mMappedTypeReference = null;
    private SoapExtensionParameterState mSoapExtensionParameter = null;

    ParameterState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        ParameterState lState = (ParameterState)object;
        if (!String.valueOf(this.mIsExposed).equals(String.valueOf(lState.mIsExposed))) {
            return false;
        }
        return String.valueOf(this.mIsOptional).equals(String.valueOf(lState.mIsOptional));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        ParameterState lState = (ParameterState)object;
        if (!String.valueOf(this.mIsExposed).equals(String.valueOf(lState.mIsExposed))) {
            compareContext.addPropertyDelta(sourceObject, "isExposed", (Object)new Boolean(lState.mIsExposed));
        }
        if (!String.valueOf(this.mIsOptional).equals(String.valueOf(lState.mIsOptional))) {
            compareContext.addPropertyDelta(sourceObject, "isOptional", (Object)new Boolean(lState.mIsOptional));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ParameterState lState = (ParameterState)((Object)super.clone());
        if (this.mDefaultValue != null) {
            lState.mDefaultValue = (DefaultValueState)((Object)this.mDefaultValue.clone());
        }
        lState.mFieldReferences = new HashMap();
        Iterator it = this.mFieldReferences.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mFieldReferences.put(lKey, ((FieldReferenceState)((Object)this.mFieldReferences.get(lKey))).clone());
        }
        if (this.mMappedTypeReference != null) {
            lState.mMappedTypeReference = (TypeReferenceState)((Object)this.mMappedTypeReference.clone());
        }
        if (this.mSoapExtensionParameter != null) {
            lState.mSoapExtensionParameter = (SoapExtensionParameterState)((Object)this.mSoapExtensionParameter.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        if (this.mDefaultValue != null) {
            this.mDefaultValue.removeExternalReferences(innerObjectKeys);
        }
        Iterator it = this.mFieldReferences.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        if (this.mMappedTypeReference != null) {
            this.mMappedTypeReference.removeExternalReferences(innerObjectKeys);
        }
        if (this.mSoapExtensionParameter != null) {
            this.mSoapExtensionParameter.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.mProxyRef = null;
        }
        super.refactor(clipboardService);
        if (this.mDefaultValue != null) {
            if (clipboardService.isExcluded((Reference)this.mDefaultValue.getProxyReference())) {
                this.mDefaultValue = null;
            } else {
                this.mDefaultValue.refactor(clipboardService);
            }
        }
        Iterator it = this.mFieldReferences.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        if (this.mMappedTypeReference != null) {
            if (clipboardService.isExcluded((Reference)this.mMappedTypeReference.getProxyReference())) {
                this.mMappedTypeReference = null;
            } else {
                this.mMappedTypeReference.refactor(clipboardService);
            }
        }
        if (this.mSoapExtensionParameter != null) {
            if (clipboardService.isExcluded((Reference)this.mSoapExtensionParameter.getProxyReference())) {
                this.mSoapExtensionParameter = null;
            } else {
                this.mSoapExtensionParameter.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        if (this.mDefaultValue != null) {
            this.mDefaultValue.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it = this.mFieldReferences.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mMappedTypeReference != null) {
            this.mMappedTypeReference.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSoapExtensionParameter != null) {
            this.mSoapExtensionParameter.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setIsExposed(boolean value) {
        this.mIsExposed = value;
        this.mHasIsExposed = true;
    }

    boolean getIsExposed() {
        return this.mIsExposed;
    }

    boolean hasIsExposed() {
        return this.mHasIsExposed;
    }

    void setIsOptional(boolean value) {
        this.mIsOptional = value;
        this.mHasIsOptional = true;
    }

    boolean getIsOptional() {
        return this.mIsOptional;
    }

    boolean hasIsOptional() {
        return this.mHasIsOptional;
    }

    void setDefaultValue(DefaultValueState state) {
        this.mDefaultValue = state;
    }

    DefaultValueState getDefaultValue() {
        return this.mDefaultValue;
    }

    void setMappedTypeReference(TypeReferenceState state) {
        this.mMappedTypeReference = state;
    }

    TypeReferenceState getMappedTypeReference() {
        return this.mMappedTypeReference;
    }

    void setSoapExtensionParameter(SoapExtensionParameterState state) {
        this.mSoapExtensionParameter = state;
    }

    SoapExtensionParameterState getSoapExtensionParameter() {
        return this.mSoapExtensionParameter;
    }

    void addFieldReference(FieldReferenceState state) {
        this.mFieldReferences.put(state.getName().toLowerCase(), state);
    }

    int getFieldReferenceCount() {
        return this.mFieldReferences.size();
    }

    FieldReferenceState getFieldReference(String name) {
        return (FieldReferenceState)((Object)this.mFieldReferences.get(name.toLowerCase()));
    }

    Vector getFieldReferences() {
        return new Vector(this.mFieldReferences.values());
    }

    void removeFieldReference(String aggregationKey) {
        this.mFieldReferences.remove(aggregationKey.toLowerCase());
    }

    void removeFieldReference(FieldReferenceState state) {
        this.mFieldReferences.remove(state.getName().toLowerCase());
    }

    void removeAllFieldReferences() {
        this.mFieldReferences.clear();
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("isExposed")) {
            this.setIsExposed(new Boolean((String)value));
        } else if (propertyName.equals("isOptional")) {
            this.setIsOptional(new Boolean((String)value));
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("DefaultValue")) {
            this.setDefaultValue((DefaultValueState)((Object)data));
        } else if (roleName.equals("FieldReferences")) {
            this.addFieldReference((FieldReferenceState)((Object)data));
        } else if (roleName.equals("MappedTypeReference")) {
            this.setMappedTypeReference((TypeReferenceState)((Object)data));
        } else if (roleName.equals("SoapExtensionParameter")) {
            this.setSoapExtensionParameter((SoapExtensionParameterState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

