/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.vi.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.vi.implementation.FaultState;
import com.sap.ide.metamodel.vi.implementation.MappableItemState;
import com.sap.ide.metamodel.vi.implementation.ParameterState;
import com.sap.ide.metamodel.vi.implementation.SoapExtensionFunctionState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class FunctionState
extends MappableItemState {
    private boolean mIsExposed = false;
    private boolean mHasIsExposed = false;
    private String mOriginalName = null;
    private boolean mHasOriginalName = false;
    private HashMap mFaults = new HashMap();
    private Vector mIncomingParameters = new Vector();
    private Vector mOutgoingParameters = new Vector();
    private SoapExtensionFunctionState mSoapExtensionFunction = null;

    FunctionState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        FunctionState lState = (FunctionState)object;
        if (!String.valueOf(this.mIsExposed).equals(String.valueOf(lState.mIsExposed))) {
            return false;
        }
        return String.valueOf(this.mOriginalName).equals(String.valueOf(lState.mOriginalName));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        FunctionState lState = (FunctionState)object;
        if (!String.valueOf(this.mIsExposed).equals(String.valueOf(lState.mIsExposed))) {
            compareContext.addPropertyDelta(sourceObject, "isExposed", (Object)new Boolean(lState.mIsExposed));
        }
        if (!String.valueOf(this.mOriginalName).equals(String.valueOf(lState.mOriginalName))) {
            compareContext.addPropertyDelta(sourceObject, "originalName", (Object)lState.mOriginalName);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FunctionState lState = (FunctionState)((Object)super.clone());
        lState.mFaults = new HashMap();
        Iterator it = this.mFaults.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mFaults.put(lKey, ((FaultState)((Object)this.mFaults.get(lKey))).clone());
        }
        lState.mIncomingParameters = new Vector();
        int i = 0;
        while (i < this.mIncomingParameters.size()) {
            lState.mIncomingParameters.add(((ParameterState)((Object)this.mIncomingParameters.get(i))).clone());
            ++i;
        }
        lState.mOutgoingParameters = new Vector();
        int i2 = 0;
        while (i2 < this.mOutgoingParameters.size()) {
            lState.mOutgoingParameters.add(((ParameterState)((Object)this.mOutgoingParameters.get(i2))).clone());
            ++i2;
        }
        if (this.mSoapExtensionFunction != null) {
            lState.mSoapExtensionFunction = (SoapExtensionFunctionState)((Object)this.mSoapExtensionFunction.clone());
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = this.mFaults.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = ((AbstractList)this.mIncomingParameters).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it3 = ((AbstractList)this.mOutgoingParameters).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).removeExternalReferences(innerObjectKeys);
        }
        if (this.mSoapExtensionFunction != null) {
            this.mSoapExtensionFunction.removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (this.mProxyRef != null) {
            this.setName(clipboardService.getNewName(this.mProxyRef));
            this.mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = this.mFaults.values().iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mIncomingParameters).iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mOutgoingParameters).iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        if (this.mSoapExtensionFunction != null) {
            if (clipboardService.isExcluded((Reference)this.mSoapExtensionFunction.getProxyReference())) {
                this.mSoapExtensionFunction = null;
            } else {
                this.mSoapExtensionFunction.refactor(clipboardService);
            }
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = this.mFaults.values().iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = ((AbstractList)this.mIncomingParameters).iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mOutgoingParameters).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mSoapExtensionFunction != null) {
            this.mSoapExtensionFunction.refactorInnerReferences(innerObjectKeys, clipboardService);
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        return super._hasReferencesToRefactor(oldReference);
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
    }

    void setIsExposed(boolean value) {
        this.mIsExposed = value;
        this.mHasIsExposed = true;
    }

    boolean getIsExposed() {
        return this.mIsExposed;
    }

    boolean hasIsExposed() {
        return this.mHasIsExposed;
    }

    void setOriginalName(String value) {
        if (value == null) {
            this.unsetOriginalName();
            return;
        }
        this.mOriginalName = value;
        this.mHasOriginalName = true;
    }

    String getOriginalName() {
        return this.mOriginalName;
    }

    boolean hasOriginalName() {
        return this.mHasOriginalName;
    }

    void unsetOriginalName() {
        this.mOriginalName = null;
        this.mHasOriginalName = false;
    }

    void setSoapExtensionFunction(SoapExtensionFunctionState state) {
        this.mSoapExtensionFunction = state;
    }

    SoapExtensionFunctionState getSoapExtensionFunction() {
        return this.mSoapExtensionFunction;
    }

    void addFault(FaultState state) {
        this.mFaults.put(state.getName().toLowerCase(), state);
    }

    int getFaultCount() {
        return this.mFaults.size();
    }

    FaultState getFault(String name) {
        return (FaultState)((Object)this.mFaults.get(name.toLowerCase()));
    }

    Vector getFaults() {
        return new Vector(this.mFaults.values());
    }

    void removeFault(String aggregationKey) {
        this.mFaults.remove(aggregationKey.toLowerCase());
    }

    void removeFault(FaultState state) {
        this.mFaults.remove(state.getName().toLowerCase());
    }

    void removeAllFaults() {
        this.mFaults.clear();
    }

    void addIncomingParameter(ParameterState state) {
        this.mIncomingParameters.add(state);
    }

    void addIncomingParameter(ParameterState state, int position) {
        this.mIncomingParameters.add(position, state);
    }

    int getIncomingParameterCount() {
        return this.mIncomingParameters.size();
    }

    ParameterState getIncomingParameter(String name) {
        int i = 0;
        while (i < this.mIncomingParameters.size()) {
            ParameterState lState = (ParameterState)((Object)this.mIncomingParameters.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getIncomingParameters() {
        return this.mIncomingParameters;
    }

    void removeIncomingParameter(ParameterState state) {
        this.mIncomingParameters.remove((Object)state);
    }

    void removeAllIncomingParameters() {
        this.mIncomingParameters.clear();
    }

    void addOutgoingParameter(ParameterState state) {
        this.mOutgoingParameters.add(state);
    }

    void addOutgoingParameter(ParameterState state, int position) {
        this.mOutgoingParameters.add(position, state);
    }

    int getOutgoingParameterCount() {
        return this.mOutgoingParameters.size();
    }

    ParameterState getOutgoingParameter(String name) {
        int i = 0;
        while (i < this.mOutgoingParameters.size()) {
            ParameterState lState = (ParameterState)((Object)this.mOutgoingParameters.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getOutgoingParameters() {
        return this.mOutgoingParameters;
    }

    void removeOutgoingParameter(ParameterState state) {
        this.mOutgoingParameters.remove((Object)state);
    }

    void removeAllOutgoingParameters() {
        this.mOutgoingParameters.clear();
    }

    void moveIncomingParameter(int fromPosition, int toPosition) {
        this.mIncomingParameters.add(toPosition, this.mIncomingParameters.remove(fromPosition));
    }

    void moveOutgoingParameter(int fromPosition, int toPosition) {
        this.mOutgoingParameters.add(toPosition, this.mOutgoingParameters.remove(fromPosition));
    }

    void reorderIncomingParameters(Vector orderedStates) {
        this.mIncomingParameters = orderedStates;
    }

    void reorderOutgoingParameters(Vector orderedStates) {
        this.mOutgoingParameters = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("isExposed")) {
            this.setIsExposed(new Boolean((String)value));
        } else if (propertyName.equals("originalName")) {
            this.setOriginalName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("Faults")) {
            this.addFault((FaultState)((Object)data));
        } else if (roleName.equals("IncomingParameters")) {
            this.addIncomingParameter((ParameterState)((Object)data));
        } else if (roleName.equals("OutgoingParameters")) {
            this.addOutgoingParameter((ParameterState)((Object)data));
        } else if (roleName.equals("SoapExtensionFunction")) {
            this.setSoapExtensionFunction((SoapExtensionFunctionState)((Object)data));
        } else {
            super.addData(roleName, data);
        }
    }
}

