/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.ApplThreadMonitor;
import com.sap.util.monitor.jarm.CompMonitor;
import com.sap.util.monitor.jarm.CompSingleMonitor;
import com.sap.util.monitor.jarm.CompSingleOverview;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.DummyMonitor;
import com.sap.util.monitor.jarm.IJarmDataRecipient;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.ReqMonitor;
import com.sap.util.monitor.jarm.RequestOverview;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TaskMonitor
implements IMonitor {
    private static boolean firstCallDone = false;
    private static Hashtable threadInfo = new Hashtable(ConfMonitor.initThreadNum);
    private static DummyMonitor dummyMonitor = new DummyMonitor();
    protected int status;
    protected int recipCount;
    protected IJarmDataRecipient recip_1;
    protected IJarmDataRecipient recip_2;
    protected IJarmDataRecipient recip_3;
    protected Vector recipVector;
    private int recipTypeCount;
    private int recipType;
    private int[] recipTypeArr;
    private ReqMonitor reqMonitor;
    private TaskMonitor parentTaskMonitor;
    private String reqNameLocal;
    private int taskEndStatus;
    private String origUserName;
    private String origReqName;
    private int compCount;
    private CompSingleMonitor firstCompElem;
    private CompSingleMonitor lastCompElem;
    private CompSingleMonitor currCompElem;
    private CompSingleMonitor lastMainComp;
    private ApplThreadMonitor applThread;
    private boolean compPropSwitchOn;
    private int compMonitorLevel;
    private boolean reqEndOutput;

    private TaskMonitor(String userName, String reqName, Thread myThreadParam, ApplThreadMonitor applThreadParam) {
        boolean startTrace;
        this.origUserName = userName;
        this.origReqName = reqName;
        if (reqName == null) {
            reqName = " ";
        }
        boolean bl = startTrace = ConfMonitor.initTraceSwitch == 1 && this.checkTrace(true);
        if (ConfMonitor.initMonitorSwitch == 1 || startTrace) {
            if (applThreadParam == null) {
                this.applThread = new ApplThreadMonitor();
                threadInfo.put(myThreadParam, this.applThread);
                this.applThread.myThread = myThreadParam;
                this.applThread.threadName = myThreadParam.getName();
                if (this.applThread.threadName == null) {
                    this.applThread.threadName = " ";
                }
                this.applThread.firstTaskTS = System.currentTimeMillis();
            } else {
                this.applThread = applThreadParam;
                if (this.applThread.myMonitor != null) {
                    switch (this.applThread.myMonitor.status) {
                        case 1: {
                            TaskMonitor hlpMon = this.applThread.myMonitor;
                            hlpMon.applThread.putCompElemList(hlpMon.firstCompElem);
                            hlpMon.applThread.endRequest(System.currentTimeMillis());
                            hlpMon.status = 4;
                        }
                    }
                }
            }
            this.privStartRequest(userName, reqName, startTrace);
        }
    }

    public static IMonitor getRequestMonitor(String userName, String reqName) {
        Thread myThread;
        ApplThreadMonitor applThreadObj;
        TaskMonitor myMonitor = null;
        if (!firstCallDone) {
            TaskMonitor.setStartupProperties();
        }
        if ((applThreadObj = (ApplThreadMonitor)threadInfo.get(myThread = Thread.currentThread())) != null && (myMonitor = applThreadObj.myMonitor) != null) {
            if (userName != null && myMonitor.reqMonitor.userName == null) {
                myMonitor.reqMonitor.userName = userName;
                applThreadObj.setUser(userName);
            }
            return myMonitor;
        }
        if (ConfMonitor.initMonitorSwitch == 1 || ConfMonitor.initTraceSwitch == 1) {
            myMonitor = new TaskMonitor(userName, reqName, myThread, applThreadObj);
            if (myMonitor.reqMonitor != null) {
                return myMonitor;
            }
        }
        return dummyMonitor;
    }

    protected static ApplThreadMonitor getApplThreadList() {
        ApplThreadMonitor headAppl = null;
        ApplThreadMonitor newAppl = null;
        ApplThreadMonitor hlpAppl = null;
        if (!firstCallDone) {
            TaskMonitor.setStartupProperties();
        }
        if (ConfMonitor.initMonitorSwitch == 0) {
            return null;
        }
        if (threadInfo == null) {
            return null;
        }
        Enumeration enumeration = threadInfo.elements();
        while (enumeration.hasMoreElements()) {
            newAppl = (ApplThreadMonitor)enumeration.nextElement();
            if (headAppl == null) {
                hlpAppl = headAppl = newAppl;
                continue;
            }
            hlpAppl.nextAppl = newAppl;
            hlpAppl = newAppl;
        }
        if (headAppl != null) {
            newAppl.nextAppl = null;
        }
        return headAppl;
    }

    protected static void removeThread(Thread oldThread) {
        ApplThreadMonitor applThreadObj = (ApplThreadMonitor)threadInfo.get(oldThread);
        if (applThreadObj != null && applThreadObj.myMonitor != null) {
            Thread thread = oldThread;
            synchronized (thread) {
                TaskMonitor activeTask = applThreadObj.myMonitor;
                if (activeTask != null) {
                    if (activeTask.reqMonitor != null) {
                        activeTask.reqMonitor.freeRequest(1);
                    } else {
                        activeTask.freeTask();
                    }
                    applThreadObj.myMonitor = null;
                }
            }
        }
        threadInfo.remove(oldThread);
    }

    private static synchronized void setStartupProperties() {
        if (!firstCallDone) {
            ConfMonitor.setPropertiesInternal();
            firstCallDone = true;
        }
    }

    public void endRequest(String reqName) {
        RequestOverview requestOverview = this.endRequest(0, reqName, -1);
    }

    public void endRequest(String reqName, int dataLength) {
        RequestOverview requestOverview = this.endRequest(0, reqName, dataLength);
    }

    public RequestOverview endRequest(int retOverview, String reqName) {
        return this.endRequest(retOverview, reqName, -1);
    }

    public RequestOverview endRequest(int retOverview, String reqName, int dataLength) {
        Thread locThread;
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: endRequest() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal + " endRequest name: " + reqName);
                }
                return null;
            }
        }
        if (reqName == null) {
            reqName = " ";
        }
        if (ConfMonitor.initInstrCheck == 1 && (locThread = Thread.currentThread()) != this.applThread.myThread) {
            ConfMonitor.logWriteError(0, "Instrumentation Error: endRequest() in thread " + locThread.getName() + " but request object in thread " + this.applThread.threadName, "Request name: " + this.reqNameLocal + " endRequest name: " + reqName);
            return null;
        }
        if (this.reqNameLocal.compareTo(reqName) != 0 && this.compCount < ConfMonitor.initMaxReqCompLow) {
            return null;
        }
        long currentTS = System.currentTimeMillis();
        boolean reqComplete = this.firstCompElem != null ? this.firstCompElem.endRequest(dataLength, currentTS) : true;
        this.status = 2;
        this.applThread.endRequest(currentTS);
        this.taskEndStatus = this.compCount >= ConfMonitor.initMaxReqCompHigh ? 3 : (this.compCount >= ConfMonitor.initMaxReqCompLow ? 2 : (!reqComplete ? 1 : 0));
        if (ConfMonitor.initInstrCheck == 1 && (this.taskEndStatus == 2 || this.taskEndStatus == 3)) {
            ConfMonitor.logWriteWarning(1, "Instrumentation Warning: endRequest() issued  because the number of components was too high.", "Request name: " + this.reqNameLocal + " endRequest name: " + reqName);
        }
        RequestOverview reqOverview = this.reqMonitor.endRequest(retOverview, this.taskEndStatus, dataLength, this.compCount, currentTS, this.compMonitorLevel);
        return reqOverview;
    }

    public void startComponent(String compName) {
        if (compName == null) {
            compName = " ";
        }
        this.privStartComponent(compName, false);
    }

    public void startComponent(int compLevel, String compName) {
        if (compLevel > this.compMonitorLevel) {
            return;
        }
        if (compName == null) {
            compName = " ";
        }
        this.privStartComponent(compName, false);
    }

    public void endComponent(String compName) {
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, -1, null);
    }

    public void endComponent(String compName, int dataLength) {
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, dataLength, null);
    }

    public void endComponent(String compName, Object compProps) {
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, -1, compProps);
    }

    public void endComponent(String compName, int dataLength, Object compProps) {
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, dataLength, compProps);
    }

    public void endComponent(int compLevel, String compName) {
        if (compLevel > this.compMonitorLevel) {
            return;
        }
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, -1, null);
    }

    public void endComponent(int compLevel, String compName, int dataLength) {
        if (compLevel > this.compMonitorLevel) {
            return;
        }
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, dataLength, null);
    }

    public void endComponent(int compLevel, String compName, Object compProps) {
        if (compLevel > this.compMonitorLevel) {
            return;
        }
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, -1, compProps);
    }

    public void endComponent(int compLevel, String compName, int dataLength, Object compProps) {
        if (compLevel > this.compMonitorLevel) {
            return;
        }
        if (compName == null) {
            compName = " ";
        }
        this.privEndComponent(compName, false, dataLength, compProps);
    }

    public void compAction(String compName, String action) {
        Thread locThread;
        String hlpCompName = compName != null ? compName : " ";
        String hlpAction = action != null ? action : " ";
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: compAction() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal + " Component name: " + hlpCompName + " Action: " + hlpAction);
                }
                return;
            }
        }
        if (ConfMonitor.initInstrCheck == 1 && (locThread = Thread.currentThread()) != this.applThread.myThread) {
            ConfMonitor.logWriteError(0, "Instrumentation Error: compAction() in thread " + locThread.getName() + " but request object in thread " + this.applThread.threadName, "Request name: " + this.reqNameLocal + " Component name: " + hlpCompName + " Action: " + hlpAction);
            return;
        }
        this.applThread.compAction(hlpCompName, hlpAction);
        if (this.reqMonitor.traceIsOn && this.currCompElem != null) {
            CompSingleMonitor actCompElem = this.currCompElem.findComponent(hlpCompName);
            if (actCompElem != null) {
                actCompElem.addAction(compName, action);
            } else {
                this.currCompElem.addAction(compName, action);
            }
        }
    }

    public void compAction(int compLevel, String compName, String action) {
        if (compLevel > this.compMonitorLevel) {
            return;
        }
        this.compAction(compName, action);
    }

    public boolean isJarmActiveForRequest() {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: isJarmActiveForRequest() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal);
                }
                return false;
            }
        }
        return true;
    }

    public boolean getMonitorSwitch() {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: getMonitorSwitch() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal);
                }
                return false;
            }
        }
        return this.reqMonitor.monitorIsOn;
    }

    public boolean getTraceSwitch() {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: getTraceSwitch() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal);
                }
                return false;
            }
        }
        return this.reqMonitor.traceIsOn;
    }

    public int getComponentLevel() {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: getComponentLevel() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal);
                }
                return -1;
            }
        }
        return this.compMonitorLevel;
    }

    public String getUser() {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: getUser() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal);
                }
                return " ";
            }
        }
        if (this.reqMonitor.userName != null) {
            return this.reqMonitor.userName;
        }
        return " ";
    }

    public String getReqName() {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: getReqName() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal);
                }
                return " ";
            }
        }
        if (this.reqMonitor.reqName != null) {
            return this.reqMonitor.reqName;
        }
        return " ";
    }

    public long getReqTS() {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: getReqTS() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal);
                }
                return -1L;
            }
        }
        return this.reqMonitor.reqTS;
    }

    public void setUser(String userName) {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    if (userName == null) {
                        userName = " ";
                    }
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: setUser() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal + " User name: " + userName);
                }
                return;
            }
        }
        if (userName != null && this.reqMonitor.userName == null) {
            this.reqMonitor.userName = userName;
            this.applThread.setUser(userName);
        }
    }

    public void setDescription(String descr) {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    if (descr == null) {
                        descr = " ";
                    }
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: setDescription() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal + " Description: " + descr);
                }
                return;
            }
        }
        if (this.reqMonitor.reqDescr == null) {
            this.reqMonitor.reqDescr = descr;
        }
    }

    public void setComponentLevel(int compLevel) {
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: setComponentLevel() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal + " Component level: " + compLevel);
                }
                return;
            }
        }
        if (this.firstCompElem == null) {
            this.compMonitorLevel = compLevel;
        }
    }

    protected int updComponents() {
        CompSingleMonitor compSingle = this.firstCompElem;
        this.compPropSwitchOn = ConfMonitor.initCompPropSetSwitch == 1;
        int i = 0;
        while (i < this.compCount) {
            CompMonitor.updComponent((CompSingleMonitor)compSingle, (boolean)this.compPropSwitchOn);
            ++i;
            compSingle = compSingle.succ;
        }
        this.status = 3;
        return this.compCount;
    }

    protected void freeTask() {
        this.reqMonitor = null;
        this.parentTaskMonitor = null;
        if (this.applThread != null) {
            this.applThread.putCompElemList(this.firstCompElem);
            this.applThread = null;
        }
        this.status = 4;
    }

    protected CompSingleOverview[] getCompOverview(boolean provideTrace) {
        CompSingleOverview[] compOver = null;
        if (this.compCount > 0) {
            compOver = new CompSingleOverview[this.compCount];
            this.compPropSwitchOn = ConfMonitor.initCompPropGetSwitch == 1;
            CompSingleMonitor currComp = this.firstCompElem;
            int i = 0;
            while (i < this.compCount) {
                compOver[i] = currComp.getCompOverview(this.compPropSwitchOn, provideTrace);
                currComp = currComp.succ;
                ++i;
            }
        } else {
            compOver = null;
        }
        return compOver;
    }

    protected boolean checkTrace(boolean beginOfRequest) {
        String reqName;
        String userName;
        boolean traceData = false;
        if (beginOfRequest) {
            userName = this.origUserName;
            reqName = this.origReqName;
        } else {
            userName = !this.reqMonitor.userName.equals(" ") ? this.reqMonitor.userName : null;
            reqName = !this.reqMonitor.reqName.equals(" ") ? this.reqMonitor.reqName : null;
        }
        ConfMonitor.copyDataRecipients(this);
        if (beginOfRequest) {
            if (this.recipCount > 0) {
                traceData = this.recip_1.isTraceOn(userName, reqName);
                this.recip_1 = null;
                if (this.recipCount > 1) {
                    if (!traceData) {
                        traceData = this.recip_2.isTraceOn(userName, reqName);
                    }
                    this.recip_2 = null;
                    if (this.recipCount > 2) {
                        if (!traceData) {
                            traceData = this.recip_3.isTraceOn(userName, reqName);
                        }
                        this.recip_3 = null;
                        int i = this.recipCount - 3 - 1;
                        while (i >= 0) {
                            if (!traceData) {
                                traceData = ((IJarmDataRecipient)this.recipVector.elementAt(i)).isTraceOn(userName, reqName);
                            }
                            this.recipVector.removeElementAt(i);
                            --i;
                        }
                    }
                }
            }
            this.recipCount = 0;
        } else {
            long duration = this.reqMonitor.reqTime;
            int outData = this.reqMonitor.reqOutData;
            int vectorDelCount = 0;
            if (this.recipCount > 0) {
                if (this.recip_1.isTraceOn(userName, reqName, duration, outData)) {
                    this.addRecipType(this.recip_1.getRecipientType());
                    traceData = true;
                } else {
                    this.recip_1 = null;
                }
                if (this.recipCount > 1) {
                    if (!this.checkRecipType(this.recip_2.getRecipientType()) && this.recip_2.isTraceOn(userName, reqName, duration, outData)) {
                        this.addRecipType(this.recip_2.getRecipientType());
                        traceData = true;
                    } else {
                        this.recip_2 = null;
                    }
                    if (this.recipCount > 2) {
                        if (!this.checkRecipType(this.recip_3.getRecipientType()) && this.recip_3.isTraceOn(userName, reqName, duration, outData)) {
                            this.addRecipType(this.recip_3.getRecipientType());
                            traceData = true;
                        } else {
                            this.recip_3 = null;
                        }
                        int i = this.recipCount - 3 - 1;
                        while (i >= 0) {
                            IJarmDataRecipient recipHlp = (IJarmDataRecipient)this.recipVector.elementAt(i);
                            if (!this.checkRecipType(recipHlp.getRecipientType()) && recipHlp.isTraceOn(userName, reqName, duration, outData)) {
                                this.addRecipType(recipHlp.getRecipientType());
                                traceData = true;
                            } else {
                                this.recipVector.removeElementAt(i);
                                ++vectorDelCount;
                            }
                            --i;
                        }
                    }
                }
            }
            this.recipCount -= vectorDelCount;
            this.clearRecipType();
        }
        return traceData;
    }

    protected void provideTraceData(RequestOverview reqOverview) {
        if (this.recipCount > 0) {
            if (this.recip_1 != null) {
                this.recip_1.notifyAtRequestEnd(reqOverview);
                this.recip_1 = null;
            }
            if (this.recipCount > 1) {
                if (this.recip_2 != null) {
                    this.recip_2.notifyAtRequestEnd(reqOverview);
                    this.recip_2 = null;
                }
                if (this.recipCount > 2) {
                    if (this.recip_3 != null) {
                        this.recip_3.notifyAtRequestEnd(reqOverview);
                        this.recip_3 = null;
                    }
                    int i = this.recipCount - 3 - 1;
                    while (i >= 0) {
                        ((IJarmDataRecipient)this.recipVector.elementAt(i)).notifyAtRequestEnd(reqOverview);
                        this.recipVector.removeElementAt(i);
                        --i;
                    }
                }
            }
        }
        this.recipCount = 0;
    }

    private void privStartRequest(String userName, String reqName, boolean startTrace) {
        long currentTS = System.currentTimeMillis();
        this.reqNameLocal = reqName;
        this.status = 1;
        this.parentTaskMonitor = null;
        this.compPropSwitchOn = ConfMonitor.initCompPropSetSwitch == 1;
        this.reqMonitor = new ReqMonitor(this, userName, reqName, currentTS, startTrace);
        this.compMonitorLevel = this.reqMonitor.monitorIsOn ? (!this.reqMonitor.traceIsOn ? ConfMonitor.initCompLevel : (ConfMonitor.initCompLevel <= ConfMonitor.initCompTraceLevel ? ConfMonitor.initCompTraceLevel : ConfMonitor.initCompLevel)) : ConfMonitor.initCompTraceLevel;
        this.applThread.startRequest(this, userName, reqName, currentTS);
    }

    private void privStartComponent(String compName, boolean foreign) {
        Thread locThread;
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: startComponent() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal + " Component name: " + compName);
                }
                return;
            }
        }
        if (ConfMonitor.initInstrCheck == 1 && (locThread = Thread.currentThread()) != this.applThread.myThread) {
            ConfMonitor.logWriteError(0, "Instrumentation Error: startComponent() in thread " + locThread.getName() + " but request object in thread " + this.applThread.threadName, "Request name: " + this.reqNameLocal + " Component name: " + compName);
            return;
        }
        if (this.compCount >= ConfMonitor.initMaxReqCompHigh) {
            this.endRequest(0, this.reqNameLocal, -1);
            return;
        }
        long currentTS = System.currentTimeMillis();
        ++this.compCount;
        this.currCompElem = this.applThread.getCompElem();
        this.currCompElem.pred = this.lastCompElem;
        this.currCompElem.succ = null;
        if (this.firstCompElem == null) {
            this.lastCompElem = this.firstCompElem = this.currCompElem;
        } else {
            this.lastCompElem.succ = this.currCompElem;
            this.lastCompElem = this.currCompElem;
        }
        if (this.lastCompElem.startComponent(compName, foreign, currentTS) == 0) {
            if (this.lastMainComp != null) {
                this.lastMainComp.nextMainComp = this.lastCompElem;
            }
            this.lastMainComp = this.lastCompElem;
        }
        this.applThread.startComponent(compName, foreign, currentTS);
    }

    private void privEndComponent(String compName, boolean foreign, int dataLength, Object compProps) {
        Thread locThread;
        switch (this.status) {
            case 1: {
                break;
            }
            default: {
                if (ConfMonitor.initInstrCheck == 1 && !this.reqEndOutput) {
                    this.reqEndOutput = true;
                    ConfMonitor.logWriteWarning(1, "Instrumentation Warning: endComponent() issued,  but request already ended.", "Check instrumentation or maybe request was ended  because the number of components was too high.", "Request name: " + this.reqNameLocal + " Component name: " + compName);
                }
                return;
            }
        }
        if (ConfMonitor.initInstrCheck == 1 && (locThread = Thread.currentThread()) != this.applThread.myThread) {
            ConfMonitor.logWriteError(0, "Instrumentation Error: endComponent() in thread " + locThread.getName() + " but request object in thread " + this.applThread.threadName, "Request name: " + this.reqNameLocal + " Component name: " + compName);
            return;
        }
        long currentTS = System.currentTimeMillis();
        if (!this.compPropSwitchOn && compProps != null) {
            compProps = null;
        }
        if (this.currCompElem != null) {
            this.currCompElem = this.currCompElem.endComponent(compName, dataLength, currentTS, compProps);
        }
        if (this.currCompElem != null && this.currCompElem.parentComp != null) {
            this.applThread.endComponent(this.currCompElem.parentComp.compName, this.currCompElem.parentComp.foreignComp, this.currCompElem.parentComp.startTS);
        } else if (this.currCompElem == null) {
            if (ConfMonitor.initInstrCheck == 1) {
                ConfMonitor.logWriteWarning(1, "Instrumentation Warning: endComponent() issued,  but no corresponding startComponent() found.", "Request name: " + this.reqNameLocal + " Component name: " + compName);
            }
            this.currCompElem = this.lastCompElem;
        } else {
            this.applThread.endComponent(" ", false, currentTS);
        }
    }

    private void addRecipType(int recipTypeParam) {
        if (this.recipTypeCount == 0) {
            this.recipType = recipTypeParam;
        } else {
            if (this.recipTypeArr == null) {
                this.recipTypeArr = new int[this.recipCount];
                this.recipTypeArr[0] = this.recipType;
            }
            this.recipTypeArr[this.recipTypeCount] = recipTypeParam;
        }
        ++this.recipTypeCount;
    }

    private boolean checkRecipType(int recipTypeParam) {
        if (this.recipTypeCount == 0) {
            return false;
        }
        if (this.recipTypeCount == 1) {
            return this.recipType == recipTypeParam;
        }
        int i = 0;
        while (i < this.recipTypeCount) {
            if (this.recipTypeArr[i] == recipTypeParam) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void clearRecipType() {
        this.recipTypeCount = 0;
        this.recipTypeArr = null;
    }
}

