/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.CompMonitor;
import com.sap.util.monitor.jarm.ICompProperties;
import com.sap.util.monitor.jarm.IConfMonitor;
import com.sap.util.monitor.jarm.IJarmDataRecipient;
import com.sap.util.monitor.jarm.MonitorConsumer;
import com.sap.util.monitor.jarm.MonitorException;
import com.sap.util.monitor.jarm.RmiMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.security.AccessControlException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ConfMonitor
implements IConfMonitor {
    protected static final int SWITCHOFF = 0;
    protected static final int SWITCHON = 1;
    protected static final int STATESTARTED = 1;
    protected static final int STATEENDED = 2;
    protected static final int STATECONDENSED = 3;
    protected static final int STATEREMOVE = 4;
    protected static final int LOGLEVELBASIC = 0;
    protected static final int LOGLEVELMEDIUM = 1;
    protected static final int LOGLEVELDETAIL = 2;
    protected static final int COMPATTRDESCRIPTION = 0;
    protected static final int COMPATTRPROPERTIES = 1;
    protected static final int COSTNETTIME = 0;
    protected static final int COSTOUTDATA = 1;
    private static final String RMISTARTSECMAN = "jarm/rmi/startsecman";
    private static final String RMIHOST = "jarm/rmi/host";
    private static final String USERSWITCH = "jarm/user/switch";
    private static final String CONDENSEDAEMON = "jarm/condense/daemon";
    private static final int THREADNUM = 200;
    private static final int NRTOPS = 100;
    private static final int MAXCOMPRET = 5000;
    private static final int MAXUSERRET = 50000;
    private static final int FREECOMPNUM = 50;
    private static final int MAXFREECOMPNUM = 200;
    private static final int CONDENSESLEEP = 10000;
    private static final int CONDENSEPAUSESLEEP = 1000;
    private static final int CONDENSESTART = 60000;
    private static final int CONDENSECOMPLIMIT = 25000;
    private static final int MAXREQCOMPLOW = 2500;
    private static final int MAXREQCOMPHIGH = 2600;
    private static final String DEFAULTPROFILE = "profile" + File.separator + "jarm.properties";
    private static final String LOGFILE = "jarm.log";
    private static final int RMISTATUSINIT = 0;
    private static final int RMISTATUSACTIVE = 1;
    private static final int RMISTATUSSUSPEND = 2;
    private static final int RMISTATUSERROR = 3;
    private static final int PROPINITNOTSTARTED = 0;
    private static final int PROPINITSTARTED = 1;
    private static final int PROPINITDONE = 2;
    private static final String PARAMETER = "Parameter: ";
    private static final String WRONGPARAMETER = "Wrong parameter: ";
    private static final String WRONGVALUE = " Wrong value: ";
    private static final String DEFLOGDIR = System.getProperty("user.dir");
    private static final String VERSION = "3.1.0";
    protected static final int RECIPFIXEDVARS = 3;
    private static final int RECIPINITVECTOR = 5;
    private static final String LINESTARTER = "                                       ";
    public static int initNrTops = 100;
    public static int initMaxCompRet = 5000;
    public static int initMaxUserRet = 50000;
    public static RmiMonitor rmiObject;
    protected static int initMonitorSwitch;
    protected static int initTraceSwitch;
    protected static int initThreadNum;
    protected static int initFreeCompNum;
    protected static int initMaxFreeCompNum;
    protected static int initCondenseSleep;
    protected static int initCondensePauseSleep;
    protected static int initCondenseStart;
    protected static int initCondenseCompLimit;
    protected static int initMaxReqCompLow;
    protected static int initMaxReqCompHigh;
    protected static int initRmiSwitch;
    protected static int initRmiStartRegistry;
    private static int initRmiStartSecMan;
    protected static int initRmiPort;
    private static String initRmiHost;
    protected static int initCompPropSetSwitch;
    protected static int initCompPropGetSwitch;
    protected static int initUserSwitch;
    protected static int initLogLevel;
    protected static int initCompLevel;
    protected static int initCompTraceLevel;
    protected static String initLogDir;
    protected static int initCondenseDaemon;
    protected static int initInstrCheck;
    protected static String threadPrefix;
    protected static String threadCondenseSuffix;
    protected static PrintWriter out;
    private static boolean profileRead;
    private static int propState;
    private static boolean logsCollected;
    private static boolean logInitInProcess;
    private static Vector logCollection;
    private static int newRmiSwitch;
    private static int newRmiStartRegistry;
    private static int newRmiStartSecMan;
    private static int newRmiPort;
    private static String newRmiHost;
    private static int rmiStatus;
    private static Object lockLog;
    private static int recipCount;
    private static IJarmDataRecipient recip_1;
    private static IJarmDataRecipient recip_2;
    private static IJarmDataRecipient recip_3;
    private static Vector recipVector;
    private static Object recipLock;
    private static boolean setJ2eePropertiesUsed;
    private static boolean setJ2eePropertiesRunning;

    public static synchronized void setMonitorOn() {
        if (setJ2eePropertiesUsed) {
            ConfMonitor.logWriteWarning(0, "Monitoring could not be switched on via setMonitorOn(); could only be done by the J2EE Engine");
            return;
        }
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        initMonitorSwitch = 1;
        ConfMonitor.logWriteInfo(0, "Set parameter jarm/switch = on");
    }

    public static synchronized void setMonitorOff() {
        if (setJ2eePropertiesUsed) {
            ConfMonitor.logWriteWarning(0, "Monitoring could not be switched off via setMonitorOff(); could only be done by the J2EE Engine");
            return;
        }
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        initMonitorSwitch = 0;
        ConfMonitor.logWriteInfo(0, "Set parameter jarm/switch = off");
    }

    public static boolean getMonitorSwitch() {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        return initMonitorSwitch == 1;
    }

    public static int getComponentLevel() {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        return initCompLevel;
    }

    public static int getComponentTraceLevel() {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        return initCompTraceLevel;
    }

    public static Properties getProperties() {
        Properties props = new Properties();
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        props.setProperty("jarm/switch", initMonitorSwitch == 1 ? "on" : "off");
        props.setProperty("jarm/tracemode/switch", initTraceSwitch == 1 ? "on" : "off");
        props.setProperty("jarm/version", VERSION);
        props.setProperty("jarm/maxreqcomplow", Integer.toString(initMaxReqCompLow));
        props.setProperty("jarm/maxreqcomphigh", Integer.toString(initMaxReqCompHigh));
        MonitorConsumer nextConsumer = MonitorConsumer.firstConsumer;
        while (nextConsumer != null) {
            props.setProperty("jarm/consumer/" + nextConsumer.name + "/switch", nextConsumer.consumerSwitch == 1 ? "on" : "off");
            if (nextConsumer.className != null) {
                props.setProperty("jarm/consumer/" + nextConsumer.name + "/class", nextConsumer.className);
            }
            props.setProperty("jarm/consumer/" + nextConsumer.name + "/restart", Integer.toString(nextConsumer.restart));
            nextConsumer = nextConsumer.succ;
        }
        props.setProperty("jarm/rmi/switch", initRmiSwitch == 1 ? "on" : "off");
        props.setProperty("jarm/rmi/startregistry", initRmiStartRegistry == 1 ? "on" : "off");
        props.setProperty("jarm/rmi/port", Integer.toString(initRmiPort));
        props.setProperty("jarm/comp/properties/set/switch", initCompPropSetSwitch == 1 ? "on" : "off");
        props.setProperty("jarm/comp/properties/get/switch", initCompPropGetSwitch == 1 ? "on" : "off");
        props.setProperty("jarm/comp/level", Integer.toString(initCompLevel));
        props.setProperty("jarm/comp/trace/level", Integer.toString(initCompTraceLevel));
        props.setProperty("jarm/log/dir", initLogDir);
        props.setProperty("jarm/instrumentation/check", initInstrCheck == 1 ? "on" : "off");
        props.setProperty("jarm/log/level", Integer.toString(initLogLevel));
        return props;
    }

    public static synchronized void setJ2eeProperties(Properties props) throws MonitorException {
        setJ2eePropertiesRunning = true;
        setJ2eePropertiesUsed = true;
        ConfMonitor.logWriteInfo(0, "setting JARM properties for J2EE Engine started");
        try {
            ConfMonitor.setProperties(props);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            ConfMonitor.logWriteInfo(0, "setting JARM properties for J2EE Engine ended");
            setJ2eePropertiesRunning = false;
            throw throwable;
        }
        ConfMonitor.logWriteInfo(0, "setting JARM properties for J2EE Engine ended");
        setJ2eePropertiesRunning = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void setProperties(Properties props) throws MonitorException {
        boolean startInitProps;
        block87: {
            block81: {
                String wrongKey = null;
                String wrongValue = null;
                int tmpInitMaxReqCompLow = initMaxReqCompLow;
                int tmpInitMaxReqCompHigh = initMaxReqCompHigh;
                boolean initMaxReqCompLowSet = false;
                boolean initMaxReqCompHighSet = false;
                boolean rmiError = false;
                startInitProps = false;
                if (setJ2eePropertiesUsed && !setJ2eePropertiesRunning) {
                    ConfMonitor.logWriteWarning(0, "JARM properties could not be set via setProperties(); could only be done by the J2EE Engine");
                    throw new MonitorException("Properties could only be set by the J2EE Engine");
                }
                try {
                    block82: {
                        block83: {
                            if (!profileRead) {
                                if (propState == 0) {
                                    startInitProps = true;
                                    propState = 1;
                                    ConfMonitor.logWriteInfo(0, "JARM started");
                                }
                                ConfMonitor.setPropertiesInternal();
                            }
                            if (props == null) {
                                Object var18_9 = null;
                                if (!startInitProps) return;
                                propState = 2;
                                break block81;
                            }
                            Enumeration<?> enumeration = props.propertyNames();
                            while (true) {
                                if (!enumeration.hasMoreElements()) {
                                    if (!initMaxReqCompLowSet && !initMaxReqCompHighSet) break block82;
                                    if (tmpInitMaxReqCompHigh >= tmpInitMaxReqCompLow) break block83;
                                    ConfMonitor.logWriteError(0, "Parameter jarm/maxreqcomplow / jarm/maxreqcomphigh ignored; lower limit (" + tmpInitMaxReqCompLow + ") greater than upper limit (" + tmpInitMaxReqCompHigh + ")");
                                    if (wrongKey == null) {
                                        if (!initMaxReqCompLowSet) break;
                                        wrongKey = "jarm/maxreqcomplow";
                                        wrongValue = Integer.toString(tmpInitMaxReqCompLow);
                                    }
                                    break block82;
                                }
                                String key = (String)enumeration.nextElement();
                                int keyLength = key.length();
                                String value = props.getProperty(key);
                                try {
                                    int tmpCompLevel;
                                    if (keyLength < "jarm/".length() || "jarm/".compareToIgnoreCase(key.substring(0, "jarm/".length())) != 0) continue;
                                    ConfMonitor.logWriteInfo(0, "Set parameter " + key + " = " + value);
                                    if (key.compareToIgnoreCase("jarm/switch") == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            initMonitorSwitch = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            initMonitorSwitch = 0;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/tracemode/switch") == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            initTraceSwitch = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            initTraceSwitch = 0;
                                            continue;
                                        }
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/maxreqcomplow") == 0) {
                                        block84: {
                                            try {
                                                tmpInitMaxReqCompLow = Integer.decode(value);
                                            }
                                            catch (NumberFormatException exc) {
                                                ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                                if (wrongKey != null) break block84;
                                                wrongKey = key;
                                                wrongValue = value;
                                            }
                                        }
                                        initMaxReqCompLowSet = true;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/maxreqcomphigh") == 0) {
                                        block85: {
                                            try {
                                                tmpInitMaxReqCompHigh = Integer.decode(value);
                                            }
                                            catch (NumberFormatException exc) {
                                                ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                                if (wrongKey != null) break block85;
                                                wrongKey = key;
                                                wrongValue = value;
                                            }
                                        }
                                        initMaxReqCompHighSet = true;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/rmi/switch") == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            newRmiSwitch = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            newRmiSwitch = 0;
                                            continue;
                                        }
                                        rmiError = true;
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/rmi/startregistry") == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            newRmiStartRegistry = 1;
                                        } else if (value.compareToIgnoreCase("off") == 0) {
                                            newRmiStartRegistry = 0;
                                        } else {
                                            rmiError = true;
                                            ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                            if (wrongKey == null) {
                                                wrongKey = key;
                                                wrongValue = value;
                                            }
                                        }
                                        if (rmiStatus == 0 || newRmiStartRegistry == initRmiStartRegistry) continue;
                                        rmiError = true;
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "must not be changed after RMI start");
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase(RMISTARTSECMAN) == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            newRmiStartSecMan = 1;
                                        } else if (value.compareToIgnoreCase("off") == 0) {
                                            newRmiStartSecMan = 0;
                                        } else {
                                            rmiError = true;
                                            ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                            if (wrongKey == null) {
                                                wrongKey = key;
                                                wrongValue = value;
                                            }
                                        }
                                        if (rmiStatus == 0 || newRmiStartSecMan == initRmiStartSecMan) continue;
                                        rmiError = true;
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "must not be changed after RMI start");
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/rmi/port") == 0) {
                                        block86: {
                                            try {
                                                newRmiPort = Integer.decode(value);
                                            }
                                            catch (NumberFormatException exc) {
                                                rmiError = true;
                                                ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                                if (wrongKey != null) break block86;
                                                wrongKey = key;
                                                wrongValue = value;
                                            }
                                        }
                                        if (rmiStatus == 0 || newRmiPort == initRmiPort) continue;
                                        rmiError = true;
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "must not be changed after RMI start");
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase(RMIHOST) == 0) {
                                        newRmiHost = value;
                                        if (rmiStatus == 0 || newRmiHost == initRmiHost) continue;
                                        rmiError = true;
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "must not be changed after RMI start");
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/comp/properties/set/switch") == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            initCompPropSetSwitch = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            initCompPropSetSwitch = 0;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/comp/properties/get/switch") == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            initCompPropGetSwitch = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            initCompPropGetSwitch = 0;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase(USERSWITCH) == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            initUserSwitch = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            initUserSwitch = 0;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/log/level") == 0) {
                                        boolean logError = false;
                                        int tmpLogLevel = 0;
                                        try {
                                            tmpLogLevel = Integer.decode(value);
                                            logError = tmpLogLevel < 0 || tmpLogLevel > 2;
                                        }
                                        catch (NumberFormatException exc) {
                                            logError = true;
                                        }
                                        if (!logError) {
                                            initLogLevel = tmpLogLevel;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/comp/level") == 0) {
                                        boolean compError = false;
                                        tmpCompLevel = 0;
                                        try {
                                            tmpCompLevel = Integer.decode(value);
                                            compError = tmpCompLevel < 0 || tmpCompLevel > 2;
                                        }
                                        catch (NumberFormatException exc) {
                                            compError = true;
                                        }
                                        if (!compError) {
                                            initCompLevel = tmpCompLevel;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/comp/trace/level") == 0) {
                                        boolean compError = false;
                                        tmpCompLevel = 0;
                                        try {
                                            tmpCompLevel = Integer.decode(value);
                                            compError = tmpCompLevel < 0 || tmpCompLevel > 2;
                                        }
                                        catch (NumberFormatException exc) {
                                            compError = true;
                                        }
                                        if (!compError) {
                                            initCompTraceLevel = tmpCompLevel;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/log/dir") == 0) {
                                        if (propState != 2) {
                                            initLogDir = value;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " = " + value + " ignored; " + "Initialization was already done");
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase("jarm/instrumentation/check") == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            initInstrCheck = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            initInstrCheck = 0;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (key.compareToIgnoreCase(CONDENSEDAEMON) == 0) {
                                        if (value.compareToIgnoreCase("on") == 0) {
                                            initCondenseDaemon = 1;
                                            continue;
                                        }
                                        if (value.compareToIgnoreCase("off") == 0) {
                                            initCondenseDaemon = 0;
                                            continue;
                                        }
                                        ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                        if (wrongKey != null) continue;
                                        wrongKey = key;
                                        wrongValue = value;
                                        continue;
                                    }
                                    if (keyLength >= "jarm/consumer/".length() && "jarm/consumer/".compareToIgnoreCase(key.substring(0, "jarm/consumer/".length())) == 0) {
                                        MonitorConsumer consumer;
                                        if (keyLength >= "/switch".length() && "/switch".compareToIgnoreCase(key.substring(keyLength - "/switch".length())) == 0) {
                                            consumer = ConfMonitor.getConsumer(key, "/switch");
                                            if (value.compareToIgnoreCase("on") == 0) {
                                                consumer.consumerSwitch = 1;
                                                continue;
                                            }
                                            if (value.compareToIgnoreCase("off") == 0) {
                                                consumer.consumerSwitch = 0;
                                                continue;
                                            }
                                            ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                            if (wrongKey != null) continue;
                                            wrongKey = key;
                                            wrongValue = value;
                                            continue;
                                        }
                                        if (keyLength >= "/class".length() && "/class".compareToIgnoreCase(key.substring(keyLength - "/class".length())) == 0) {
                                            consumer = ConfMonitor.getConsumer(key, "/class");
                                            consumer.className = value;
                                            continue;
                                        }
                                        if (keyLength >= "/restart".length() && "/restart".compareToIgnoreCase(key.substring(keyLength - "/restart".length())) == 0) {
                                            consumer = ConfMonitor.getConsumer(key, "/restart");
                                            try {
                                                consumer.restart = Integer.decode(value);
                                            }
                                            catch (NumberFormatException exc) {
                                                ConfMonitor.logWriteError(0, "Parameter " + key + " ignored; " + "wrong value: " + value);
                                                if (wrongKey != null) continue;
                                                wrongKey = key;
                                                wrongValue = value;
                                            }
                                            continue;
                                        }
                                        if (wrongKey != null) continue;
                                        ConfMonitor.logWriteError(0, "Illegal Parameter " + key);
                                        wrongKey = key;
                                        continue;
                                    }
                                    ConfMonitor.logWriteError(0, "Illegal Parameter " + key);
                                    if (wrongKey != null) continue;
                                    wrongKey = key;
                                }
                                catch (IndexOutOfBoundsException exc) {
                                    ConfMonitor.logWriteError(0, "Illegal Parameter " + key);
                                    if (wrongKey != null) continue;
                                    wrongKey = key;
                                }
                            }
                            wrongKey = "jarm/maxreqcomphigh";
                            wrongValue = Integer.toString(tmpInitMaxReqCompHigh);
                            break block82;
                        }
                        initMaxReqCompLow = tmpInitMaxReqCompLow;
                        initMaxReqCompHigh = tmpInitMaxReqCompHigh;
                    }
                    if (rmiError) {
                        newRmiSwitch = initRmiSwitch;
                    }
                    ConfMonitor.initRmi();
                    if (wrongKey != null) {
                        if (wrongValue == null) throw new MonitorException(WRONGPARAMETER + wrongKey);
                        throw new MonitorException(PARAMETER + wrongKey + WRONGVALUE + wrongValue);
                    }
                    break block87;
                }
                catch (Throwable throwable) {
                    Object var18_11 = null;
                    if (!startInitProps) throw throwable;
                    propState = 2;
                    ConfMonitor.logWriteInfo(0, "JARM properties initialization is ready");
                    throw throwable;
                }
            }
            ConfMonitor.logWriteInfo(0, "JARM properties initialization is ready");
            return;
        }
        Object var18_10 = null;
        if (!startInitProps) return;
        propState = 2;
        ConfMonitor.logWriteInfo(0, "JARM properties initialization is ready");
    }

    public static void setCompDescription(String compName, String compDescr) {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        CompMonitor.setCompAttr((String)compName, (int)0, (Object)compDescr);
    }

    public static void setCompProps(String compName, ICompProperties propImpl) {
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        CompMonitor.setCompAttr((String)compName, (int)1, (Object)propImpl);
    }

    public static boolean registerDataRecipient(IJarmDataRecipient dataRecip) {
        boolean noError = true;
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        Object object = recipLock;
        synchronized (object) {
            switch (recipCount) {
                case 0: {
                    recip_1 = dataRecip;
                    break;
                }
                case 1: {
                    if (recip_1 != dataRecip) {
                        recip_2 = dataRecip;
                        break;
                    }
                    noError = false;
                    break;
                }
                case 2: {
                    if (recip_1 != dataRecip && recip_2 != dataRecip) {
                        recip_3 = dataRecip;
                        break;
                    }
                    noError = false;
                    break;
                }
                default: {
                    if (recip_1 != dataRecip && recip_2 != dataRecip && recip_3 != dataRecip) {
                        int i = 3;
                        int j = 0;
                        while (i < recipCount) {
                            if ((IJarmDataRecipient)recipVector.elementAt(j) == dataRecip) {
                                noError = false;
                                break;
                            }
                            ++i;
                            ++j;
                        }
                        if (!noError) break;
                        if (recipVector == null) {
                            recipVector = new Vector(5);
                        }
                        recipVector.addElement(dataRecip);
                        break;
                    }
                    noError = false;
                }
            }
            if (noError) {
                ++recipCount;
            }
        }
        return noError;
    }

    public static boolean deRegisterDataRecipient(IJarmDataRecipient dataRecip) {
        boolean found = false;
        if (!profileRead) {
            ConfMonitor.setPropertiesInternal();
        }
        Object object = recipLock;
        synchronized (object) {
            if (recipCount > 0) {
                if (recip_1 == dataRecip) {
                    found = true;
                    recip_1 = recip_2;
                    recip_2 = recip_3;
                } else if (recipCount > 1 && recip_2 == dataRecip) {
                    found = true;
                    recip_2 = recip_3;
                } else if (recipCount > 2 && recip_3 == dataRecip) {
                    found = true;
                }
                if (found) {
                    if (recipCount > 3) {
                        recip_3 = (IJarmDataRecipient)recipVector.elementAt(0);
                        recipVector.removeElementAt(0);
                    }
                } else {
                    int i = 0;
                    while (i < recipCount - 3) {
                        if ((IJarmDataRecipient)recipVector.elementAt(i) == dataRecip) {
                            recipVector.removeElementAt(i);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (found) {
                --recipCount;
            }
        }
        return found;
    }

    protected static synchronized void setPropertiesInternal() {
        block21: {
            InputStream inStream = null;
            boolean startInitProps = false;
            if (profileRead) {
                return;
            }
            profileRead = true;
            if (setJ2eePropertiesUsed) {
                return;
            }
            if (propState == 0) {
                startInitProps = true;
                propState = 1;
                ConfMonitor.logWriteInfo(0, "JARM started");
            }
            try {
                try {
                    inStream = new FileInputStream(DEFAULTPROFILE);
                    ConfMonitor.logWriteInfo(0, "Profile '" + DEFAULTPROFILE + "' found in current directory");
                }
                catch (FileNotFoundException exc) {
                    ConfMonitor.logWriteInfo(0, "Profile '" + DEFAULTPROFILE + "' not found in current directory");
                }
                catch (SecurityException exc) {
                    ConfMonitor.logWriteError(0, "SecurityException when accessing '" + DEFAULTPROFILE + "' in current directory");
                }
                if (inStream == null) {
                    try {
                        inStream = ClassLoader.getSystemResourceAsStream(DEFAULTPROFILE);
                        if (inStream != null) {
                            ConfMonitor.logWriteInfo(0, "Profile '" + DEFAULTPROFILE + "' found in classpath");
                        } else {
                            ConfMonitor.logWriteInfo(0, "Profile '" + DEFAULTPROFILE + "' not found in classpath");
                        }
                    }
                    catch (SecurityException exc) {
                        ConfMonitor.logWriteError(0, "SecurityException when accessing '" + DEFAULTPROFILE + "' in classpath");
                    }
                }
                if (inStream == null) {
                    ConfMonitor.logWriteInfo(0, "Running without using profile '" + DEFAULTPROFILE + "'");
                } else {
                    try {
                        Properties props = new Properties();
                        props.load(inStream);
                        ConfMonitor.setProperties(props);
                    }
                    catch (IOException exc) {
                        ConfMonitor.logWriteError(0, "IOException: properties could not be loaded from '" + DEFAULTPROFILE + "'");
                    }
                    catch (MonitorException exc) {
                        // empty catch block
                    }
                }
                try {
                    ConfMonitor.initRmi();
                }
                catch (MonitorException monitorException) {
                }
                Object var6_9 = null;
                if (!startInitProps) break block21;
                propState = 2;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (startInitProps) {
                    propState = 2;
                    ConfMonitor.logWriteInfo(0, "JARM properties initialization is ready");
                }
                throw throwable;
            }
            ConfMonitor.logWriteInfo(0, "JARM properties initialization is ready");
            {
            }
        }
    }

    protected static void logInit(String logDir) {
        File fp = new File(logDir, LOGFILE);
        boolean fileError = true;
        boolean logInitStarted = false;
        if (!logInitInProcess) {
            logInitInProcess = true;
            logInitStarted = true;
        }
        try {
            if (fp != null) {
                try {
                    fp.createNewFile();
                    out = new PrintWriter((Writer)new FileWriter(fp), true);
                    fileError = false;
                }
                catch (IOException exc) {
                    ConfMonitor.logWriteError(0, "IOException when opening log file 'jarm.log' in directory '" + logDir + "'");
                }
                catch (SecurityException exc) {
                    ConfMonitor.logWriteError(0, "SecurityException when opening log file 'jarm.log' in directory '" + logDir + "'");
                }
            }
            if (fileError) {
                if (logDir != DEFLOGDIR) {
                    ConfMonitor.logInit(DEFLOGDIR);
                }
            } else {
                ConfMonitor.logWriteInfo(0, "Log file 'jarm.log' opened in directory '" + logDir + "'");
            }
            Object var7_6 = null;
            if (logInitStarted) {
                logInitInProcess = false;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (logInitStarted) {
                logInitInProcess = false;
            }
            throw throwable;
        }
    }

    protected static void logWriteInfo(int logLevel, String outStr) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "INFO:    " + outStr, null, null);
        }
    }

    protected static void logWriteInfo(int logLevel, String outStr1, String outStr2) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "INFO:    " + outStr1, outStr2, null);
        }
    }

    protected static void logWriteInfo(int logLevel, String outStr1, String outStr2, String outStr3) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "INFO:    " + outStr1, outStr2, outStr3);
        }
    }

    protected static void logWriteWarning(int logLevel, String outStr) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "WARNING: " + outStr, null, null);
        }
    }

    protected static void logWriteWarning(int logLevel, String outStr1, String outStr2) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "WARNING: " + outStr1, outStr2, null);
        }
    }

    protected static void logWriteWarning(int logLevel, String outStr1, String outStr2, String outStr3) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "WARNING: " + outStr1, outStr2, outStr3);
        }
    }

    protected static void logWriteError(int logLevel, String outStr) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "ERROR:   " + outStr, null, null);
        }
    }

    protected static void logWriteError(int logLevel, String outStr1, String outStr2) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "ERROR:   " + outStr1, outStr2, null);
        }
    }

    protected static void logWriteError(int logLevel, String outStr1, String outStr2, String outStr3) {
        if (logLevel <= initLogLevel) {
            ConfMonitor.logWrite(true, "ERROR:   " + outStr1, outStr2, outStr3);
        }
    }

    protected static void copyDataRecipients(TaskMonitor task) {
        Object object = recipLock;
        synchronized (object) {
            task.recipCount = recipCount;
            if (recipCount > 0) {
                task.recip_1 = recip_1;
                if (recipCount > 1) {
                    task.recip_2 = recip_2;
                    if (recipCount > 2) {
                        task.recip_3 = recip_3;
                        int i = 3;
                        int j = 0;
                        while (i < recipCount) {
                            if (task.recipVector == null) {
                                task.recipVector = new Vector(5);
                            }
                            task.recipVector.addElement(recipVector.elementAt(j));
                            ++i;
                            ++j;
                        }
                    }
                }
            }
        }
    }

    private static void logWrite(boolean addDate, String outStr1, String outStr2, String outStr3) {
        Object object = lockLog;
        synchronized (object) {
            if (propState == 2 && !logInitInProcess) {
                if (logsCollected) {
                    ConfMonitor.logInit(initLogDir);
                    logsCollected = false;
                    ConfMonitor.logWriteCollection();
                }
                if (out != null) {
                    if (addDate) {
                        out.print(new Date().toString() + " ");
                    }
                    out.println(outStr1);
                    if (outStr2 != null) {
                        out.print(LINESTARTER);
                        out.println(outStr2);
                        if (outStr3 != null) {
                            out.print(LINESTARTER);
                            out.println(outStr3);
                        }
                    }
                }
            } else {
                logsCollected = true;
                ConfMonitor.logAddToCollection(new Date().toString() + " " + outStr1);
                if (outStr2 != null) {
                    ConfMonitor.logAddToCollection(LINESTARTER + outStr2);
                    if (outStr3 != null) {
                        ConfMonitor.logAddToCollection(LINESTARTER + outStr3);
                    }
                }
            }
        }
    }

    private static void logAddToCollection(String outStr) {
        logCollection.add(outStr);
    }

    private static void logWriteCollection() {
        int logElems = logCollection.size();
        int i = 0;
        while (i < logElems) {
            ConfMonitor.logWrite(false, (String)logCollection.get(i), null, null);
            ++i;
        }
    }

    private static MonitorConsumer getConsumer(String key, String consumerSuffix) throws IndexOutOfBoundsException {
        boolean found = false;
        String tmpName = key.substring("jarm/consumer/".length());
        String name = tmpName.substring(0, tmpName.length() - consumerSuffix.length());
        MonitorConsumer nextConsumer = MonitorConsumer.firstConsumer;
        while (!found && nextConsumer != null) {
            found = name.compareToIgnoreCase(nextConsumer.name) == 0;
            if (found) continue;
            nextConsumer = nextConsumer.succ;
        }
        if (!found) {
            nextConsumer = new MonitorConsumer(name);
            if (MonitorConsumer.firstConsumer == null) {
                MonitorConsumer.lastConsumer = MonitorConsumer.firstConsumer = nextConsumer;
            } else {
                MonitorConsumer.lastConsumer.succ = nextConsumer;
                MonitorConsumer.lastConsumer = nextConsumer;
            }
        }
        return nextConsumer;
    }

    private static void initRmi() throws MonitorException {
        switch (rmiStatus) {
            case 0: {
                if (newRmiSwitch == 1) {
                    try {
                        ConfMonitor.startRmi();
                    }
                    catch (MonitorException exc) {
                        ConfMonitor.resetRmiValues();
                        rmiStatus = 3;
                        throw exc;
                    }
                    initRmiSwitch = 1;
                    rmiStatus = 1;
                }
                initRmiStartRegistry = newRmiStartRegistry;
                initRmiStartSecMan = newRmiStartSecMan;
                initRmiPort = newRmiPort;
                initRmiHost = newRmiHost;
                break;
            }
            case 1: {
                if (newRmiSwitch != 0) break;
                try {
                    ConfMonitor.stopRmi();
                }
                catch (MonitorException exc) {
                    ConfMonitor.resetRmiValues();
                    rmiStatus = 3;
                    throw exc;
                }
                initRmiSwitch = 0;
                rmiStatus = 2;
                break;
            }
            case 2: {
                if (newRmiSwitch != 1) break;
                try {
                    ConfMonitor.resumeRmi();
                }
                catch (MonitorException exc) {
                    ConfMonitor.resetRmiValues();
                    rmiStatus = 3;
                    throw exc;
                }
                initRmiSwitch = 1;
                rmiStatus = 1;
                break;
            }
            default: {
                ConfMonitor.resetRmiValues();
                throw new MonitorException("RMI: Status Error (is not recoverable)");
            }
        }
        ConfMonitor.resetRmiValues();
    }

    private static void startRmi() throws MonitorException {
        String bindURL = null;
        ConfMonitor.logWriteInfo(0, "Initialization for RMI interface started");
        if (newRmiStartSecMan == 1) {
            try {
                System.setSecurityManager(new RMISecurityManager());
                ConfMonitor.logWriteInfo(0, "RMI: switched to RMISecurityManager");
            }
            catch (SecurityException exc) {
                ConfMonitor.logWriteError(0, "RMI: Start of RMISecurityManager failed ");
                if (initLogLevel == 2) {
                    exc.printStackTrace();
                }
                throw new MonitorException("RMI: Start of Security Manager failed");
            }
        }
        if (newRmiStartRegistry == 1) {
            try {
                LocateRegistry.createRegistry(newRmiPort);
                ConfMonitor.logWriteInfo(0, "RMI: createRegistry done; Port = " + newRmiPort);
            }
            catch (RemoteException exc) {
                ConfMonitor.logWriteError(0, "RMI: createRegistry failed; Port = " + newRmiPort);
                if (initLogLevel == 2) {
                    exc.printStackTrace();
                }
                throw new MonitorException("RMI: Creation of Registry failed; Port = " + newRmiPort);
            }
        }
        try {
            rmiObject = new RmiMonitor();
        }
        catch (RemoteException exc) {
            ConfMonitor.logWriteError(0, "RMI: Creation of rmi object failed");
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Creation of rmi object failed");
        }
        try {
            bindURL = "//" + newRmiHost + ":" + newRmiPort + "/RmiMonitor";
            ConfMonitor.logWriteInfo(0, "RMI: URL for binding = " + bindURL);
            Naming.rebind(bindURL, (Remote)rmiObject);
            ConfMonitor.logWriteInfo(0, "RMI: binding done; Port = " + newRmiPort);
        }
        catch (MalformedURLException exc) {
            ConfMonitor.logWriteError(0, "RMI: binding failed (MalformedURLException); Port = " + newRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Bind object: MalformedURLException");
        }
        catch (RemoteException exc) {
            ConfMonitor.logWriteError(0, "RMI: binding failed (RemoteException); Port = " + newRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Bind object: RemoteException");
        }
        catch (AccessControlException exc) {
            ConfMonitor.logWriteError(0, "RMI: binding failed (AccessControlException); Port = " + newRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Bind object: AccessControlException");
        }
        ConfMonitor.logWriteInfo(0, "Initialization for RMI interface ended successfully");
    }

    private static void stopRmi() throws MonitorException {
        String bindURL = null;
        try {
            bindURL = "//" + initRmiHost + ":" + initRmiPort + "/RmiMonitor";
            ConfMonitor.logWriteInfo(0, "RMI: URL for unbind = " + bindURL);
            Naming.unbind(bindURL);
            ConfMonitor.logWriteInfo(0, "RMI: unbind done; Port = " + initRmiPort);
        }
        catch (NotBoundException exc) {
            ConfMonitor.logWriteError(0, "RMI: unbind failed (NotBoundException); Port = " + initRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Unbind object: NotBoundException");
        }
        catch (MalformedURLException exc) {
            ConfMonitor.logWriteError(0, "RMI: unbind failed (MalformedURLException); Port = " + initRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Unbind object: MalformedURLException");
        }
        catch (RemoteException exc) {
            ConfMonitor.logWriteError(0, "RMI: unbind failed (RemoteException); Port = " + initRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Unbind object: RemoteException");
        }
        catch (AccessControlException exc) {
            ConfMonitor.logWriteError(0, "RMI: unbind failed (AccessControlException); Port = " + initRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Unbind object: AccessControlException");
        }
        rmiObject = null;
        ConfMonitor.logWriteInfo(0, "Stopping the RMI interface done successfully");
    }

    private static void resumeRmi() throws MonitorException {
        String bindURL = null;
        try {
            rmiObject = new RmiMonitor();
        }
        catch (RemoteException exc) {
            throw new MonitorException("RMI: Creation of rmi object failed");
        }
        try {
            bindURL = "//" + initRmiHost + ":" + initRmiPort + "/RmiMonitor";
            ConfMonitor.logWriteInfo(0, "RMI: URL for binding = " + bindURL);
            Naming.rebind(bindURL, (Remote)rmiObject);
            ConfMonitor.logWriteInfo(0, "RMI: binding done; Port = " + initRmiPort);
        }
        catch (MalformedURLException exc) {
            ConfMonitor.logWriteError(0, "RMI: binding failed (MalformedURLException); Port = " + initRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Bind object: MalformedURLException");
        }
        catch (RemoteException exc) {
            ConfMonitor.logWriteError(0, "RMI: binding failed (RemoteException); Port = " + initRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Bind object: RemoteException");
        }
        catch (AccessControlException exc) {
            ConfMonitor.logWriteError(0, "RMI: binding failed (AccessControlException); Port = " + initRmiPort);
            if (initLogLevel == 2) {
                exc.printStackTrace();
            }
            throw new MonitorException("RMI: Bind object: AccessControlException");
        }
        ConfMonitor.logWriteInfo(0, "Resuming the RMI interface done successfully");
    }

    private static void resetRmiValues() {
        newRmiSwitch = initRmiSwitch;
        newRmiStartRegistry = initRmiStartRegistry;
        newRmiStartSecMan = initRmiStartSecMan;
        newRmiPort = initRmiPort;
        newRmiHost = initRmiHost;
    }

    static {
        initMonitorSwitch = 1;
        initTraceSwitch = 1;
        initThreadNum = 200;
        initFreeCompNum = 50;
        initMaxFreeCompNum = 200;
        initCondenseSleep = 10000;
        initCondensePauseSleep = 1000;
        initCondenseStart = 60000;
        initCondenseCompLimit = 25000;
        initMaxReqCompLow = 2500;
        initMaxReqCompHigh = 2600;
        initRmiSwitch = 0;
        initRmiStartRegistry = 1;
        initRmiStartSecMan = 0;
        initRmiPort = 1099;
        initRmiHost = "";
        initCompPropSetSwitch = 1;
        initCompPropGetSwitch = 1;
        initUserSwitch = 1;
        initLogLevel = 0;
        initCompLevel = 0;
        initCompTraceLevel = 1;
        initLogDir = DEFLOGDIR;
        initCondenseDaemon = 1;
        initInstrCheck = 0;
        threadPrefix = "Jarm";
        threadCondenseSuffix = "Condense";
        out = null;
        profileRead = false;
        propState = 0;
        logsCollected = false;
        logInitInProcess = false;
        logCollection = new Vector(20);
        newRmiSwitch = 0;
        newRmiStartRegistry = initRmiStartRegistry;
        newRmiStartSecMan = initRmiStartSecMan;
        newRmiPort = initRmiPort;
        newRmiHost = initRmiHost;
        rmiStatus = 0;
        lockLog = new Object();
        recipLock = new Object();
        setJ2eePropertiesUsed = false;
        setJ2eePropertiesRunning = false;
    }
}

