/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.offline;

import com.sap.engine.offline.ControlledCryptographyProvider;
import com.sap.engine.offline.FileClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class OfflineToolStart {
    public static final String OFFLINE_LOADER_NAME = "OfflineClassLoader";
    static /* synthetic */ Class class$com$sap$engine$offline$OfflineToolStart;

    public static void main(String[] args) {
        String provider = null;
        try {
            provider = ControlledCryptographyProvider.useProvider("SUN");
            if (args.length > 1) {
                String mainClassName = args[0];
                String dirPaths = args[1];
                ClassLoader systemLoader = (class$com$sap$engine$offline$OfflineToolStart == null ? (class$com$sap$engine$offline$OfflineToolStart = OfflineToolStart.class$("com.sap.engine.offline.OfflineToolStart")) : class$com$sap$engine$offline$OfflineToolStart).getClassLoader();
                FileClassLoader offlineToolLoader = new FileClassLoader(systemLoader, OFFLINE_LOADER_NAME);
                if (dirPaths != null) {
                    StringTokenizer tokenizer = new StringTokenizer(dirPaths, File.pathSeparator);
                    while (tokenizer.hasMoreTokens()) {
                        String nextToken = tokenizer.nextToken().trim();
                        File file = new File(nextToken);
                        if (!file.exists()) {
                            System.out.println("Warning : " + nextToken + " file stated but does not exist !");
                            continue;
                        }
                        if (file.isDirectory()) {
                            File[] jarFiles = file.listFiles(new FilenameFilter(){

                                public boolean accept(File dir, String name) {
                                    String fileName = name.toLowerCase();
                                    return fileName.endsWith(".jar") || fileName.endsWith(".zip");
                                }
                            });
                            offlineToolLoader.addJars(jarFiles);
                            continue;
                        }
                        offlineToolLoader.addJars(new File[]{file});
                    }
                }
                Thread.currentThread().setContextClassLoader(offlineToolLoader);
                String[] mainArgs = new String[args.length - 2];
                int i = 2;
                while (i < args.length) {
                    mainArgs[i - 2] = args[i];
                    ++i;
                }
                try {
                    Class mainClass = offlineToolLoader.loadClass(mainClassName);
                    Method mainMethod = mainClass.getDeclaredMethod("main", mainArgs.getClass());
                    mainMethod.invoke(null, new Object[]{mainArgs});
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                OfflineToolStart.dumpHelpMessage("Wrong number of input parameters", System.out);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            ControlledCryptographyProvider.useProvider(provider);
            throw throwable;
        }
        ControlledCryptographyProvider.useProvider(provider);
    }

    private static void dumpHelpMessage(String s, PrintStream out) {
        out.println("OfflineToolStart error message: [" + s + "]");
        out.println("  USAGE:");
        out.println("    java.exe " + (class$com$sap$engine$offline$OfflineToolStart == null ? (class$com$sap$engine$offline$OfflineToolStart = OfflineToolStart.class$("com.sap.engine.offline.OfflineToolStart")) : class$com$sap$engine$offline$OfflineToolStart).getName() + " <OfflineToolMainClass> <OfflineToolDirPathsJarPaths> [<parameters>]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

