/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.offline;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ControlledCryptographyProvider
extends Provider {
    public static final String NAME = "Controlled Provider";
    protected static final ThreadLocal current = new ThreadLocal();
    protected static final ControlledCryptographyProvider provider = new ControlledCryptographyProvider();
    private static Provider DEFAULT_PROVIDER = null;

    public ControlledCryptographyProvider() {
        super(NAME, 6.3, "Controlled provider by SAP-AG.\nIt may change the order of providers for special threads.");
    }

    public static final String useProvider(String name) {
        String result = (String)current.get();
        if (result == null && name != null || result != null && !result.equals(name)) {
            current.set(name);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Security.removeProvider(ControlledCryptographyProvider.NAME);
                    Security.insertProviderAt(provider, 1);
                    return null;
                }
            });
        }
        return result;
    }

    public static final void revertToProvider(String name) {
        current.set(name);
    }

    public Object get(Object key) {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Hashtable)currentProvider).get(key);
        }
        return null;
    }

    public String getProperty(String key) {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Properties)currentProvider).getProperty(key);
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return currentProvider.getProperty(key, defaultValue);
        }
        return null;
    }

    public Set entrySet() {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return currentProvider.keySet();
        }
        return super.entrySet();
    }

    public Set keySet() {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return currentProvider.keySet();
        }
        return super.keySet();
    }

    public Enumeration elements() {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Hashtable)currentProvider).elements();
        }
        return super.elements();
    }

    public Enumeration keys() {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Hashtable)currentProvider).keys();
        }
        return super.keys();
    }

    public Enumeration propertyNames() {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return currentProvider.propertyNames();
        }
        return super.propertyNames();
    }

    public Collection values() {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return currentProvider.values();
        }
        return super.values();
    }

    public boolean contains(Object key) {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Hashtable)currentProvider).contains(key);
        }
        return false;
    }

    public boolean containsKey(Object key) {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Hashtable)currentProvider).containsKey(key);
        }
        return false;
    }

    public boolean containsValue(Object value) {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Hashtable)currentProvider).containsValue(value);
        }
        return false;
    }

    public int size() {
        String name = (String)current.get();
        Provider currentProvider = this.getCurrentProvider(name);
        if (currentProvider != null) {
            return ((Hashtable)currentProvider).size();
        }
        return 0;
    }

    public void clear() {
    }

    public void load(InputStream in) {
    }

    public Object put(Object key, Object value) {
        return null;
    }

    public Object setProperty(String key, String value) {
        return null;
    }

    public void putAll(Map map) {
    }

    public Object remove(Object key) {
        return null;
    }

    private final Provider getCurrentProvider(String name) {
        if (name == null) {
            return null;
        }
        Provider result = Security.getProvider(name);
        if (result == null) {
            result = DEFAULT_PROVIDER;
        }
        return result;
    }

    static {
        DEFAULT_PROVIDER = Security.getProvider("SUN");
        if (DEFAULT_PROVIDER == null) {
            DEFAULT_PROVIDER = Security.getProvider("IBMJCE");
        }
    }
}

