/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tests.propmetadata;

import com.sap.caf.km.ejb.svc.propmetadata.IPropMetaGroup;
import com.sap.caf.km.ejb.svc.propmetadata.IPropMetaName;
import com.sap.caf.km.ejb.svc.propmetadata.IPropNamespace;
import com.sap.caf.km.ejb.svc.propmetadata.PropException;
import com.sap.caf.km.ejb.svc.propmetadata.PropMetadataLocal;
import com.sap.caf.km.ejb.svc.propmetadata.PropMetadataLocalHome;
import com.sap.tc.jtools.jver.framework.IJverTestAttributes;
import com.sap.tc.jtools.jver.framework.Test;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;

public class TestPropMetadata
extends Test {
    protected InitialContext m_initContext;
    private static List m_params = new ArrayList();
    protected static final String JNDI_NAME_PARAM = "JNDI_PROPMETADATA_NAME";
    protected static final String JNDI_NAME_VALUE = "localejbs/sap.com/caf~com.sap.caf.runtime/PropMetadataBean";
    protected PropMetadataLocal m_ejb;

    public static void adjustTestAttributes(IJverTestAttributes pAttribs) {
        pAttribs.setFixtureForMethod(false);
        pAttribs.setInstantiationForMethod(false);
        TestPropMetadata.addParameter("JNDI_PROPMETADATA_NAME=localejbs/sap.com/caf~com.sap.caf.runtime/PropMetadataBean");
        pAttribs.defineParameters(m_params.toArray(new String[m_params.size()]));
        pAttribs.setTestSet(new String[]{"testGetNamespaces", "testGetNamesByNamespace", "testGetNamesByGroupId", "testGetNamesByNamespaceAndGroupId", "testGetNames", "testGetGroups", "testGetGroupsByNamespace"});
    }

    protected static void addParameter(String param) {
        m_params.add(param);
    }

    public void prepare() throws Exception {
        this.m_initContext = new InitialContext();
        PropMetadataLocalHome home = (PropMetadataLocalHome)this.m_initContext.lookup(this.getParameter(JNDI_NAME_PARAM));
        this.m_ejb = home.create();
    }

    public void testGetNames() throws PropException {
        IPropMetaName[] names = this.m_ejb.getNames();
        this.verify(names != null && names.length > 0, "Meta names array is null or empty!");
    }

    public void testGetGroups() throws PropException {
        IPropMetaGroup[] groups = this.m_ejb.getGroups();
        this.verify(groups != null && groups.length > 0, "Meta groups array is null or empty!");
    }

    public void testGetGroupsByNamespace() throws PropException {
        IPropNamespace namespace = new IPropNamespace(){

            public String getAlias() {
                return "col";
            }

            public String getNamespace() {
                return "http://sapportals.com/xmlns/cm/collaboration";
            }
        };
        IPropMetaGroup[] groups = this.m_ejb.getGroups(namespace);
        this.verify(groups != null && groups.length > 0, "Meta groups array is null or empty!");
    }

    public void testGetNamesByGroupId() throws PropException {
        String groupId = "system";
        IPropMetaName[] names = this.m_ejb.getNames(groupId);
        this.verify(names != null && names.length > 0, "Could not get Meta Names by Group Id [" + groupId + "], meta names array is null or empty!");
    }

    public void testGetNamespaces() throws PropException {
        IPropNamespace[] namespaces = this.m_ejb.getNamespaces();
        this.verify(namespaces != null && namespaces.length > 0, "Could not get namespaces: either result array is null or empty!");
    }

    public void testGetNamesByNamespace() throws PropException {
        IPropNamespace[] namespaces = this.m_ejb.getNamespaces();
        this.verify(namespaces != null && namespaces.length > 0, "Could not get namespaces: either result array is null or empty!");
        IPropMetaName[] names = this.m_ejb.getNames(namespaces[0]);
        this.verify(names != null && names.length > 0, "Meta names array is null or empty!");
    }

    public void testGetNamesByNamespaceAndGroupId() throws PropException {
        IPropNamespace[] namespaces = this.m_ejb.getNamespaces();
        this.verify(namespaces != null && namespaces.length > 0, "Could not get namespaces: either result array is null or empty!");
        String groupId = namespaces[0].getAlias();
        IPropMetaName[] names = this.m_ejb.getNames(namespaces[0], groupId);
        this.verify(names != null && names.length > 0, "Meta names array is null or empty!");
    }
}

